/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.model;

import fr.profi.mzdb.model.PeakelDataMatrix;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;

public final class PeakelDataMatrix$
implements Serializable {
    public static final PeakelDataMatrix$ MODULE$;

    static {
        new PeakelDataMatrix$();
    }

    public byte[] pack(PeakelDataMatrix peakelDataMatrix) {
        int i;
        long[] spectrumIds = peakelDataMatrix.spectrumIds();
        float[] elutionTimes = peakelDataMatrix.elutionTimes();
        double[] mzValues = peakelDataMatrix.mzValues();
        float[] intensityValues = peakelDataMatrix.intensityValues();
        int len = spectrumIds.length;
        MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
        packer.packArrayHeader(4);
        packer.packArrayHeader(len);
        for (i = 0; i < len; ++i) {
            packer.packLong(spectrumIds[i]);
        }
        packer.packArrayHeader(len);
        for (i = 0; i < len; ++i) {
            packer.packFloat(elutionTimes[i]);
        }
        packer.packArrayHeader(len);
        for (i = 0; i < len; ++i) {
            packer.packDouble(mzValues[i]);
        }
        packer.packArrayHeader(len);
        for (i = 0; i < len; ++i) {
            packer.packFloat(intensityValues[i]);
        }
        byte[] result2 = packer.toByteArray();
        packer.close();
        return result2;
    }

    public PeakelDataMatrix unpack(byte[] peakelMessageAsBytes) {
        int i;
        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])peakelMessageAsBytes);
        unpacker.unpackArrayHeader();
        int len = unpacker.unpackArrayHeader();
        long[] spectrumIds = new long[len];
        float[] elutionTimes = new float[len];
        double[] mzValues = new double[len];
        float[] intensityValues = new float[len];
        for (i = 0; i < len; ++i) {
            spectrumIds[i] = unpacker.unpackLong();
        }
        unpacker.unpackArrayHeader();
        for (i = 0; i < len; ++i) {
            elutionTimes[i] = unpacker.unpackFloat();
        }
        unpacker.unpackArrayHeader();
        for (i = 0; i < len; ++i) {
            mzValues[i] = unpacker.unpackDouble();
        }
        unpacker.unpackArrayHeader();
        for (i = 0; i < len; ++i) {
            intensityValues[i] = unpacker.unpackFloat();
        }
        unpacker.close();
        return new PeakelDataMatrix(spectrumIds, elutionTimes, mzValues, intensityValues);
    }

    public PeakelDataMatrix apply(long[] spectrumIds, float[] elutionTimes, double[] mzValues, float[] intensityValues) {
        return new PeakelDataMatrix(spectrumIds, elutionTimes, mzValues, intensityValues);
    }

    public Option<Tuple4<long[], float[], double[], float[]>> unapply(PeakelDataMatrix x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.spectrumIds(), (Object)x$0.elutionTimes(), (Object)x$0.mzValues(), (Object)x$0.intensityValues()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PeakelDataMatrix$() {
        MODULE$ = this;
    }
}

