/*
 * Decompiled with CFR 0.152.
 */
package com.github.mzdb4s.io.reader.bb;

import com.github.mzdb4s.io.reader.bb.IBlobReader;
import com.github.mzdb4s.msdata.DataEncoding;
import com.github.mzdb4s.msdata.DataMode$;
import com.github.mzdb4s.msdata.PeakEncoding$;
import com.github.mzdb4s.msdata.SpectrumData;
import com.github.mzdb4s.msdata.SpectrumHeader;
import com.github.mzdb4s.msdata.SpectrumSlice;
import java.nio.ByteBuffer;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055e!B\u0001\u0003\u0003\u0003y!AE!cgR\u0014\u0018m\u0019;CY>\u0014'+Z1eKJT!a\u0001\u0003\u0002\u0005\t\u0014'BA\u0003\u0007\u0003\u0019\u0011X-\u00193fe*\u0011q\u0001C\u0001\u0003S>T!!\u0003\u0006\u0002\r5THM\u0019\u001bt\u0015\tYA\"\u0001\u0004hSRDWO\u0019\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9\u0002$D\u0001\u0003\u0013\tI\"AA\u0006J\u00052|'MU3bI\u0016\u0014\b\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\t9\u0002\u0001C\u0003 \u0001\u0019\u0005\u0001%A\bgSJ\u001cHo\u00159fGR\u0014X/\\%e+\u0005\t\u0003CA\t#\u0013\t\u0019#C\u0001\u0003M_:<\u0007\"B\u0013\u0001\r\u0003\u0001\u0013A\u00047bgR\u001c\u0006/Z2ueVl\u0017\n\u001a\u0005\u0006O\u00011\t\u0001K\u0001\u0013gB,7\r\u001e:v[\"+\u0017\rZ3s\u0005fLE-F\u0001*!\rQs&M\u0007\u0002W)\u0011A&L\u0001\b[V$\u0018M\u00197f\u0015\tq##\u0001\u0006d_2dWm\u0019;j_:L!\u0001M\u0016\u0003\u000f1{gnZ'baB\u0011!'N\u0007\u0002g)\u0011A\u0007C\u0001\u0007[N$\u0017\r^1\n\u0005Y\u001a$AD*qK\u000e$(/^7IK\u0006$WM\u001d\u0005\u0006q\u00011\t!O\u0001\u0019I\u0006$\u0018-\u00128d_\u0012Lgn\u001a\"z'B,7\r\u001e:v[&#W#\u0001\u001e\u0011\u0007)z3\b\u0005\u00023y%\u0011Qh\r\u0002\r\t\u0006$\u0018-\u00128d_\u0012Lgn\u001a\u0005\b\u007f\u0001\u0001\r\u0011\"\u0005A\u00035y6\u000f]3diJ\f7i\\;oiV\t\u0011\t\u0005\u0002\u0012\u0005&\u00111I\u0005\u0002\u0004\u0013:$\bbB#\u0001\u0001\u0004%\tBR\u0001\u0012?N\u0004Xm\u0019;sC\u000e{WO\u001c;`I\u0015\fHCA$K!\t\t\u0002*\u0003\u0002J%\t!QK\\5u\u0011\u001dYE)!AA\u0002\u0005\u000b1\u0001\u001f\u00132\u0011\u0019i\u0005\u0001)Q\u0005\u0003\u0006qql\u001d9fGR\u0014\u0018mQ8v]R\u0004\u0003bB(\u0001\u0001\u0004%\t\u0002U\u0001\u001d?N\u0004Xm\u0019;sk6\u001cF.[2f'R\f'\u000f\u001e)pg&$\u0018n\u001c8t+\u0005\t\u0006cA\tS\u0003&\u00111K\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b+\u0002\u0001\r\u0011\"\u0005W\u0003\u0001z6\u000f]3diJ,Xn\u00157jG\u0016\u001cF/\u0019:u!>\u001c\u0018\u000e^5p]N|F%Z9\u0015\u0005\u001d;\u0006bB&U\u0003\u0003\u0005\r!\u0015\u0005\u00073\u0002\u0001\u000b\u0015B)\u0002;}\u001b\b/Z2ueVl7\u000b\\5dKN#\u0018M\u001d;Q_NLG/[8og\u0002Bqa\u0017\u0001A\u0002\u0013E\u0001+\u0001\u0007`a\u0016\f7n]\"pk:$8\u000fC\u0004^\u0001\u0001\u0007I\u0011\u00030\u0002!}\u0003X-Y6t\u0007>,h\u000e^:`I\u0015\fHCA$`\u0011\u001dYE,!AA\u0002ECa!\u0019\u0001!B\u0013\t\u0016!D0qK\u0006\\7oQ8v]R\u001c\b\u0005C\u0003d\u0001\u0011\u0005C-A\thKR\fE\u000e\\*qK\u000e$(/^7JIN$\u0012!\u001a\t\u0004#I\u000b\u0003\"B4\u0001\t#A\u0017!\u0006:fC\u0012\u001c\u0006/Z2ueVl7\u000b\\5dK\u0012\u000bG/\u0019\u000b\tS24\bP\u001f?\u0002\u0004A\u0011!G[\u0005\u0003WN\u0012Ab\u00159fGR\u0014X/\u001c#bi\u0006DQ!\u001c4A\u00029\fAB\u00192CsR,')\u001e4gKJ\u0004\"a\u001c;\u000e\u0003AT!!\u001d:\u0002\u00079LwNC\u0001t\u0003\u0011Q\u0017M^1\n\u0005U\u0004(A\u0003\"zi\u0016\u0014UO\u001a4fe\")qO\u001aa\u0001\u0003\u0006)2\u000f]3diJ,Xn\u00157jG\u0016\u001cF/\u0019:u!>\u001c\b\"B=g\u0001\u0004\t\u0015\u0001\u00059fC.\u001c()\u001f;fg2+gn\u001a;i\u0011\u0015Yh\r1\u0001<\u0003\t!W\rC\u0003~M\u0002\u0007a0A\u0003nS:l%\u0010\u0005\u0002\u0012\u007f&\u0019\u0011\u0011\u0001\n\u0003\r\u0011{WO\u00197f\u0011\u0019\t)A\u001aa\u0001}\u0006)Q.\u0019=Nu\"9\u0011\u0011\u0002\u0001\u0005\u0012\u0005-\u0011aF2iK\u000e\\7\u000b]3diJ,X.\u00138eKb\u0014\u0016M\\4f)\r9\u0015Q\u0002\u0005\b\u0003\u001f\t9\u00011\u0001B\u0003\rIG\r\u001f\u0015\u0007\u0003\u000f\t\u0019\"!\r\u0011\u000bE\t)\"!\u0007\n\u0007\u0005]!C\u0001\u0004uQJ|wo\u001d\t\u0005\u00037\tYC\u0004\u0003\u0002\u001e\u0005\u001db\u0002BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rb\"\u0001\u0004=e>|GOP\u0005\u0002'%\u0019\u0011\u0011\u0006\n\u0002\u000fA\f7m[1hK&!\u0011QFA\u0018\u0005eIe\u000eZ3y\u001fV$xJ\u001a\"pk:$7/\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005%\"#M\u0004\u001f\u0003g\t\t%!\u001c\u0011\t\u0005U\u00121\b\b\u0004#\u0005]\u0012bAA\u001d%\u00051\u0001K]3eK\u001aLA!!\u0010\u0002@\t11\u000b\u001e:j]\u001eT1!!\u000f\u0013c%\u0019\u00131IA&\u0003G\ni%\u0006\u0003\u0002F\u0005\u001dSCAA\u001a\t\u001d\tIE\u0004b\u0001\u0003'\u0012\u0011\u0001V\u0005\u0005\u0003\u001b\ny%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003#\u0012\u0012A\u0002;ie><8/\u0005\u0003\u0002V\u0005m\u0003cA\t\u0002X%\u0019\u0011\u0011\f\n\u0003\u000f9{G\u000f[5oOB!\u0011QLA0\u001d\r\t\u0012qE\u0005\u0005\u0003C\nyCA\u0005UQJ|w/\u00192mKFJ1%!\u001a\u0002h\u0005%\u0014\u0011\u000b\b\u0004#\u0005\u001d\u0014bAA)%E*!%\u0005\n\u0002l\t)1oY1mCF\u001aa%!\u0007\t\u000f\u0005E\u0004\u0001\"\u0005\u0002t\u0005Q2\r[3dW\u0012\u000bG/Y#oG>$\u0017N\\4Jg:{GOT;mYR)q)!\u001e\u0002x!110a\u001cA\u0002mBq!!\u001f\u0002p\u0001\u0007\u0011%\u0001\u0006ta\u0016\u001cGO];n\u0013\u0012Dq!! \u0001\t\u0003\ny(A\u000bsK\u0006$\u0017\t\u001c7Ta\u0016\u001cGO];n'2L7-Z:\u0015\t\u0005\u0005\u0015\u0011\u0012\t\u0005#I\u000b\u0019\tE\u00023\u0003\u000bK1!a\"4\u00055\u0019\u0006/Z2ueVl7\u000b\\5dK\"9\u00111RA>\u0001\u0004\t\u0015A\u0003:v]Nc\u0017nY3JI\u0002")
public abstract class AbstractBlobReader
implements IBlobReader {
    private int _spectraCount;
    private int[] _spectrumSliceStartPositions;
    private int[] _peaksCounts;

    public abstract long firstSpectrumId();

    public abstract long lastSpectrumId();

    public abstract LongMap<SpectrumHeader> spectrumHeaderById();

    public abstract LongMap<DataEncoding> dataEncodingBySpectrumId();

    public int _spectraCount() {
        return this._spectraCount;
    }

    public void _spectraCount_$eq(int x$1) {
        this._spectraCount = x$1;
    }

    public int[] _spectrumSliceStartPositions() {
        return this._spectrumSliceStartPositions;
    }

    public void _spectrumSliceStartPositions_$eq(int[] x$1) {
        this._spectrumSliceStartPositions = x$1;
    }

    public int[] _peaksCounts() {
        return this._peaksCounts;
    }

    public void _peaksCounts_$eq(int[] x$1) {
        this._peaksCounts = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long[] getAllSpectrumIds() {
        void var2_2;
        int spectraCount = this.getSpectraCount();
        long[] spectrumIds = new long[spectraCount];
        for (int i = 0; i < spectraCount; ++i) {
            spectrumIds[i] = this.getSpectrumIdAt(i);
        }
        return var2_2;
    }

    public SpectrumData readSpectrumSliceData(ByteBuffer bbByteBuffer, int spectrumSliceStartPos, int peaksBytesLength, DataEncoding de, double minMz, double maxMz) {
        int peaksStartIdx;
        int peaksCount;
        Enumeration.Value pe;
        Enumeration.Value dataMode;
        block10: {
            int structSize;
            block9: {
                dataMode = de.getMode();
                pe = de.getPeakEncoding();
                structSize = de.getPeakStructSize();
                peaksCount = 0;
                peaksStartIdx = 0;
                if (!(minMz < 0.0) || !(maxMz < 0.0)) break block9;
                peaksCount = peaksBytesLength / structSize;
                peaksStartIdx = spectrumSliceStartPos;
                break block10;
            }
            double maxMzThreshold = maxMz;
            if (maxMz < 0.0) {
                maxMzThreshold = Double.MAX_VALUE;
            }
            for (int i = 0; i < peaksBytesLength; i += structSize) {
                Enumeration.Value value;
                block14: {
                    double d;
                    int peakStartPos;
                    block12: {
                        block13: {
                            block11: {
                                peakStartPos = spectrumSliceStartPos + i;
                                value = pe;
                                Enumeration.Value value2 = PeakEncoding$.MODULE$.HIGH_RES_PEAK();
                                Enumeration.Value value3 = value;
                                if (value2 != null ? !value2.equals(value3) : value3 != null) break block11;
                                d = bbByteBuffer.getDouble(peakStartPos);
                                break block12;
                            }
                            Enumeration.Value value4 = PeakEncoding$.MODULE$.LOW_RES_PEAK();
                            Enumeration.Value value5 = value;
                            if (value4 != null ? !value4.equals(value5) : value5 != null) break block13;
                            d = bbByteBuffer.getFloat(peakStartPos);
                            break block12;
                        }
                        Enumeration.Value value6 = PeakEncoding$.MODULE$.NO_LOSS_PEAK();
                        Enumeration.Value value7 = value;
                        if (value6 != null ? !value6.equals(value7) : value7 != null) break block14;
                        d = bbByteBuffer.getDouble(peakStartPos);
                    }
                    double mz = d;
                    if (!(mz >= minMz) || !(mz <= maxMzThreshold)) continue;
                    ++peaksCount;
                    if (!(mz >= minMz) || peaksStartIdx != 0) continue;
                    peaksStartIdx = peakStartPos;
                    continue;
                }
                throw new MatchError((Object)value);
            }
        }
        bbByteBuffer.position(peaksStartIdx);
        double[] mzArray = new double[peaksCount];
        float[] intensityArray = new float[peaksCount];
        float[] lwhmArray = new float[peaksCount];
        float[] rwhmArray = new float[peaksCount];
        for (int peakIdx = 0; peakIdx < peaksCount; ++peakIdx) {
            Enumeration.Value value;
            block18: {
                block16: {
                    BoxedUnit boxedUnit;
                    block17: {
                        block15: {
                            value = pe;
                            Enumeration.Value value8 = PeakEncoding$.MODULE$.HIGH_RES_PEAK();
                            Enumeration.Value value9 = value;
                            if (value8 != null ? !value8.equals(value9) : value9 != null) break block15;
                            mzArray[peakIdx] = bbByteBuffer.getDouble();
                            intensityArray[peakIdx] = bbByteBuffer.getFloat();
                            boxedUnit = BoxedUnit.UNIT;
                            break block16;
                        }
                        Enumeration.Value value10 = PeakEncoding$.MODULE$.LOW_RES_PEAK();
                        Enumeration.Value value11 = value;
                        if (value10 != null ? !value10.equals(value11) : value11 != null) break block17;
                        mzArray[peakIdx] = bbByteBuffer.getFloat();
                        intensityArray[peakIdx] = bbByteBuffer.getFloat();
                        boxedUnit = BoxedUnit.UNIT;
                        break block16;
                    }
                    Enumeration.Value value12 = PeakEncoding$.MODULE$.NO_LOSS_PEAK();
                    Enumeration.Value value13 = value;
                    if (value12 != null ? !value12.equals(value13) : value13 != null) break block18;
                    mzArray[peakIdx] = bbByteBuffer.getDouble();
                    intensityArray[peakIdx] = (float)bbByteBuffer.getDouble();
                    boxedUnit = BoxedUnit.UNIT;
                }
                Enumeration.Value value14 = dataMode;
                Enumeration.Value value15 = DataMode$.MODULE$.FITTED();
                if (value14 != null ? !value14.equals(value15) : value15 != null) continue;
                lwhmArray[peakIdx] = bbByteBuffer.getFloat();
                rwhmArray[peakIdx] = bbByteBuffer.getFloat();
                continue;
            }
            throw new MatchError((Object)value);
        }
        return new SpectrumData((WrappedArray<Object>)Predef$.MODULE$.wrapDoubleArray(mzArray), (WrappedArray<Object>)Predef$.MODULE$.wrapFloatArray(intensityArray), (WrappedArray<Object>)Predef$.MODULE$.wrapFloatArray(lwhmArray), (WrappedArray<Object>)Predef$.MODULE$.wrapFloatArray(rwhmArray));
    }

    public void checkSpectrumIndexRange(int idx) throws IndexOutOfBoundsException {
        if (idx < 0 || idx >= this.getSpectraCount()) {
            throw new IndexOutOfBoundsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spectrum index out of bounds (idx=", "), index counting starts at 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)idx)})));
        }
    }

    public void checkDataEncodingIsNotNull(DataEncoding de, long spectrumId) {
        if (de == null) {
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scared that the mzdb file is corrupted, spectrum id is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)spectrumId)})));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SpectrumSlice[] readAllSpectrumSlices(int runSliceId) {
        void var3_3;
        int spectraCount = this.getSpectraCount();
        SpectrumSlice[] sl = new SpectrumSlice[spectraCount];
        for (int i = 0; i < spectraCount; ++i) {
            SpectrumSlice s = this.readSpectrumSliceAt(i);
            s.setRunSliceId(runSliceId);
            sl[i] = s;
        }
        return var3_3;
    }

    public AbstractBlobReader() {
        Predef$.MODULE$.require(this.firstSpectrumId() <= this.lastSpectrumId(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "lastSpectrumId must be greater or the same than firstSpectrumId";
            }
        });
        this._spectraCount = 0;
        this._spectrumSliceStartPositions = null;
        this._peaksCounts = null;
    }
}

