/*
 * Decompiled with CFR 0.152.
 */
package com.github.mzdb4s.io.reader.bb2;

import com.github.mzdb4s.io.reader.bb2.BoundingBoxIndexFactory;
import com.github.mzdb4s.io.reader.bb2.IByteBufferAsInts;
import com.github.mzdb4s.msdata.DataEncoding;
import com.github.mzdb4s.util.collection.ResizedArray;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}4Q!\u0001\u0002\u0001\u00059\u0011\u0001CQ8v]\u0012Lgn\u001a\"pq&sG-\u001a=\u000b\u0005\r!\u0011a\u00012ce)\u0011QAB\u0001\u0007e\u0016\fG-\u001a:\u000b\u0005\u001dA\u0011AA5p\u0015\tI!\"\u0001\u0004nu\u0012\u0014Gg\u001d\u0006\u0003\u00171\taaZ5uQV\u0014'\"A\u0007\u0002\u0007\r|Wn\u0005\u0002\u0001\u001fA\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001aD\u0001B\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\u0019I\u0006$\u0018-\u00128d_\u0012Lgn\u001a\"z'B,7\r\u001e:v[&#7\u0001\u0001\t\u00043y\u0001S\"\u0001\u000e\u000b\u0005ma\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0003;E\t!bY8mY\u0016\u001cG/[8o\u0013\ty\"DA\u0004M_:<W*\u00199\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\rB\u0011AB7tI\u0006$\u0018-\u0003\u0002&E\taA)\u0019;b\u000b:\u001cw\u000eZ5oO\"Aq\u0005\u0001B\u0001B\u0003-\u0001&\u0001\u0007cE&#\u0007PR1di>\u0014\u0018\u0010\u0005\u0002*U5\t!!\u0003\u0002,\u0005\t9\"i\\;oI&twMQ8y\u0013:$W\r\u001f$bGR|'/\u001f\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005=\u0012DC\u0001\u00192!\tI\u0003\u0001C\u0003(Y\u0001\u000f\u0001\u0006C\u0003\u0017Y\u0001\u0007\u0001\u0004C\u00045\u0001\u0001\u0007I\u0011C\u001b\u0002\u001b}\u001b\b/Z2ue\u0006\u001cu.\u001e8u+\u00051\u0004C\u0001\t8\u0013\tA\u0014CA\u0002J]RDqA\u000f\u0001A\u0002\u0013E1(A\t`gB,7\r\u001e:b\u0007>,h\u000e^0%KF$\"\u0001P \u0011\u0005Ai\u0014B\u0001 \u0012\u0005\u0011)f.\u001b;\t\u000f\u0001K\u0014\u0011!a\u0001m\u0005\u0019\u0001\u0010J\u0019\t\r\t\u0003\u0001\u0015)\u00037\u00039y6\u000f]3diJ\f7i\\;oi\u0002B\u0011\u0002\u0012\u0001A\u0002\u0003\u0007I\u0011C#\u00029}\u001b\b/Z2ueVl7\u000b\\5dKN#\u0018M\u001d;Q_NLG/[8ogV\ta\tE\u0002\u001a\u000fZJ!\u0001\u0013\u000e\u0003\u0019]\u0013\u0018\r\u001d9fI\u0006\u0013(/Y=\t\u0013)\u0003\u0001\u0019!a\u0001\n#Y\u0015\u0001I0ta\u0016\u001cGO];n'2L7-Z*uCJ$\bk\\:ji&|gn]0%KF$\"\u0001\u0010'\t\u000f\u0001K\u0015\u0011!a\u0001\r\"1a\n\u0001Q!\n\u0019\u000bQdX:qK\u000e$(/^7TY&\u001cWm\u0015;beR\u0004vn]5uS>t7\u000f\t\u0005\n!\u0002\u0001\r\u00111A\u0005\u0012\u0015\u000bAb\u00189fC.\u001c8i\\;oiND\u0011B\u0015\u0001A\u0002\u0003\u0007I\u0011C*\u0002!}\u0003X-Y6t\u0007>,h\u000e^:`I\u0015\fHC\u0001\u001fU\u0011\u001d\u0001\u0015+!AA\u0002\u0019CaA\u0016\u0001!B\u00131\u0015!D0qK\u0006\\7oQ8v]R\u001c\b\u0005C\u0003Y\u0001\u0011%\u0011,A\n`K:\u001cXO]3Ta\u0016\u001cGO]1D_VtG\u000f\u0006\u0002=5\")1l\u0016a\u0001m\u0005a1\u000f]3diJ\f7i\\;oi\")1\f\u0001C\u0001k!\u0012AL\u0018\t\u0003!}K!\u0001Y\t\u0003\r%tG.\u001b8f\u0011\u0015\u0011\u0007\u0001\"\u0001F\u0003m\u0019\b/Z2ueVl7\u000b\\5dKN#\u0018M\u001d;Q_NLG/[8og\"\u0012\u0011M\u0018\u0005\u0006K\u0002!\t!R\u0001\fa\u0016\f7n]\"pk:$8\u000f\u000b\u0002e=\")\u0001\u000e\u0001C\u0001S\u0006\u0019\u0012N\u001c3fqN\u0003Xm\u0019;sk6\u001cF.[2fgR)\u0001G[8rm\")1n\u001aa\u0001Y\u0006ya-\u001b:tiN\u0003Xm\u0019;sk6LE\r\u0005\u0002\u0011[&\u0011a.\u0005\u0002\u0005\u0019>tw\rC\u0003qO\u0002\u0007A.\u0001\bmCN$8\u000b]3diJ,X.\u00133\t\u000bI<\u0007\u0019A:\u0002\u0019\t,hMZ3s\u0003NLe\u000e^:\u0011\u0005%\"\u0018BA;\u0003\u0005EI%)\u001f;f\u0005V4g-\u001a:Bg&sGo\u001d\u0005\u0006o\u001e\u0004\rAN\u0001\u0007]\nKH/Z:\t\u000be\u0004A\u0011\u0003>\u00025\rDWmY6ECR\fWI\\2pI&tw-S:O_RtU\u000f\u001c7\u0015\u0007qZX\u0010C\u0003}q\u0002\u0007\u0001%\u0001\u0002eK\")a\u0010\u001fa\u0001Y\u0006Q1\u000f]3diJ,X.\u00133")
public class BoundingBoxIndex {
    private final LongMap<DataEncoding> dataEncodingBySpectrumId;
    private final BoundingBoxIndexFactory bbIdxFactory;
    private int _spectraCount;
    private WrappedArray<Object> _spectrumSliceStartPositions;
    private WrappedArray<Object> _peaksCounts;

    public int _spectraCount() {
        return this._spectraCount;
    }

    public void _spectraCount_$eq(int x$1) {
        this._spectraCount = x$1;
    }

    public WrappedArray<Object> _spectrumSliceStartPositions() {
        return this._spectrumSliceStartPositions;
    }

    public void _spectrumSliceStartPositions_$eq(WrappedArray<Object> x$1) {
        this._spectrumSliceStartPositions = x$1;
    }

    public WrappedArray<Object> _peaksCounts() {
        return this._peaksCounts;
    }

    public void _peaksCounts_$eq(WrappedArray<Object> x$1) {
        this._peaksCounts = x$1;
    }

    private void _ensureSpectraCount(int spectraCount) {
        if (this._spectrumSliceStartPositions() == null || this.spectrumSliceStartPositions().length() < spectraCount) {
            this._spectrumSliceStartPositions_$eq((WrappedArray<Object>)Predef$.MODULE$.wrapIntArray(new int[spectraCount]));
        }
        if (this._peaksCounts() == null || this._peaksCounts().length() < spectraCount) {
            this._peaksCounts_$eq((WrappedArray<Object>)Predef$.MODULE$.wrapIntArray(new int[spectraCount]));
        }
    }

    public int spectraCount() {
        return this._spectraCount();
    }

    public WrappedArray<Object> spectrumSliceStartPositions() {
        return this._spectrumSliceStartPositions();
    }

    public WrappedArray<Object> peaksCounts() {
        return this._peaksCounts();
    }

    public BoundingBoxIndex indexSpectrumSlices(long firstSpectrumId, long lastSpectrumId, IByteBufferAsInts bufferAsInts, int nBytes) {
        int estimatedSpectraCount = (int)(1L + lastSpectrumId - firstSpectrumId);
        this._ensureSpectraCount(estimatedSpectraCount);
        int spectrumSliceIdx = 0;
        int byteIdx = 0;
        while (byteIdx < nBytes) {
            int spectrumId = bufferAsInts.apply(byteIdx, this.bbIdxFactory);
            this._spectrumSliceStartPositions().update(spectrumSliceIdx, (Object)BoxesRunTime.boxToInteger((int)byteIdx));
            int peaksCount = bufferAsInts.apply(byteIdx + 4, this.bbIdxFactory);
            this._peaksCounts().update(spectrumSliceIdx, (Object)BoxesRunTime.boxToInteger((int)peaksCount));
            DataEncoding de = (DataEncoding)this.dataEncodingBySpectrumId.apply((long)spectrumId);
            this.checkDataEncodingIsNotNull(de, spectrumId);
            byteIdx += 8 + peaksCount * de.getPeakStructSize();
            ++spectrumSliceIdx;
        }
        this._spectraCount_$eq(spectrumSliceIdx);
        if (this._spectrumSliceStartPositions().length() > this._spectraCount()) {
            this._spectrumSliceStartPositions_$eq(new ResizedArray.ofInt((int[])this._spectrumSliceStartPositions().array(), this._spectraCount()));
        }
        if (this._peaksCounts().length() > this._spectraCount()) {
            this._peaksCounts_$eq(new ResizedArray.ofInt((int[])this._peaksCounts().array(), this._spectraCount()));
        }
        return this;
    }

    public void checkDataEncodingIsNotNull(DataEncoding de, long spectrumId) {
        if (de == null) {
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scared that the mzDB file is corrupted, spectrum id is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)spectrumId)})));
        }
    }

    public BoundingBoxIndex(LongMap<DataEncoding> dataEncodingBySpectrumId, BoundingBoxIndexFactory bbIdxFactory) {
        this.dataEncodingBySpectrumId = dataEncodingBySpectrumId;
        this.bbIdxFactory = bbIdxFactory;
        this._spectraCount = 0;
    }
}

