/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.mzdb;

import fr.proline.mzscope.model.FeaturesExtractionRequest;
import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.model.IExportParameters;
import fr.proline.mzscope.model.IFeature;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.model.MsnExtractionRequest;
import fr.proline.mzscope.model.QCMetrics;
import fr.proline.mzscope.model.Spectrum;
import fr.proline.mzscope.mzdb.MzdbRawFile;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedMzdbRawFile
implements IRawFile {
    private static final Logger logger = LoggerFactory.getLogger(ThreadedMzdbRawFile.class);
    private final ExecutorService service;
    private final File file;
    private MzdbRawFile mzdbRawFile;

    public ThreadedMzdbRawFile(File file) {
        this.file = file;
        this.service = Executors.newSingleThreadExecutor();
        this.init();
    }

    private void init() {
        try {
            Future<?> future = this.service.submit(() -> {
                this.mzdbRawFile = new MzdbRawFile(this.file);
            });
            future.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("mzdbRawFile initialisation failed", (Throwable)ex);
        }
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.getName();
    }

    @Override
    public int getPreviousSpectrumId(int spectrumIndex, int msLevel) {
        try {
            return this.service.submit(() -> this.mzdbRawFile.getPreviousSpectrumId(spectrumIndex, msLevel)).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("getPreviousSpectrumId call fail", (Throwable)ex);
            return -1;
        }
    }

    @Override
    public int getSpectrumCount() {
        try {
            return this.service.submit(() -> this.mzdbRawFile.getSpectrumCount()).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("getPreviousSpectrumId call fail", (Throwable)ex);
            return -1;
        }
    }

    @Override
    public int getNextSpectrumId(int spectrumIndex, int msLevel) {
        try {
            return this.service.submit(() -> this.mzdbRawFile.getNextSpectrumId(spectrumIndex, msLevel)).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("getNextSpectrumId call fail", (Throwable)ex);
            return -1;
        }
    }

    @Override
    public int getSpectrumId(double retentionTime) {
        try {
            return this.service.submit(() -> this.mzdbRawFile.getSpectrumId(retentionTime)).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("getSpectrumId call fail", (Throwable)ex);
            return -1;
        }
    }

    @Override
    public double[] getElutionTimes(int msLevel) {
        try {
            return this.service.submit(() -> this.mzdbRawFile.getElutionTimes(msLevel)).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("getElutionTimes call fail", (Throwable)ex);
            return null;
        }
    }

    @Override
    public double getSpectrumElutionTime(int spectrumIndex) {
        try {
            return this.service.submit(() -> this.mzdbRawFile.getSpectrumElutionTime(spectrumIndex)).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("getSpectrumElutionTime call fail", (Throwable)ex);
            return -1.0;
        }
    }

    @Override
    public Spectrum getSpectrum(int spectrumIndex) {
        try {
            return this.service.submit(() -> this.mzdbRawFile.getSpectrum(spectrumIndex)).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("getSpectrum call fail", (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<IFeature> extractFeatures(FeaturesExtractionRequest params) {
        try {
            logger.info("extract feature starting");
            Future<List> future = this.service.submit(() -> {
                List<IFeature> result = this.mzdbRawFile.extractFeatures(params);
                result.stream().forEach(f -> f.setRawFile(this));
                return result;
            });
            logger.info("waiting for feature extraction ... ");
            return future.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("extractFeatures call fail", (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<IPeakel> extractPeakels(FeaturesExtractionRequest params) {
        try {
            logger.info("extract peakels starting");
            Future<List> future = this.service.submit(() -> {
                List<IPeakel> result = this.mzdbRawFile.extractPeakels(params);
                result.stream().forEach(f -> f.setRawFile(this));
                return result;
            });
            logger.info("waiting for peakels extraction ... ");
            return future.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("extractPeakels call fail", (Throwable)ex);
            return null;
        }
    }

    @Override
    public IChromatogram getBPI() {
        try {
            return this.service.submit(() -> {
                IChromatogram chromatogram = this.mzdbRawFile.getBPI();
                return chromatogram;
            }).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("getBPI call fail", (Throwable)ex);
            return null;
        }
    }

    @Override
    public IChromatogram getXIC(MsnExtractionRequest params) {
        try {
            return this.service.submit(() -> {
                IChromatogram chromatogram = this.mzdbRawFile.getXIC(params);
                return chromatogram;
            }).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("getXIC call fail", (Throwable)ex);
            return null;
        }
    }

    @Override
    public IChromatogram getTIC(int msLevel) {
        try {
            return this.service.submit(() -> {
                IChromatogram chromatogram = this.mzdbRawFile.getTIC(msLevel);
                return chromatogram;
            }).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("getTIC call fail", (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<Float> getMsMsEvent(double minMz, double maxMz) {
        return this.mzdbRawFile.getMsMsEvent(minMz, maxMz);
    }

    @Override
    public boolean exportRawFile(String mgfFileName, IExportParameters exportParams) {
        try {
            return this.service.submit(() -> this.mzdbRawFile.exportRawFile(mgfFileName, exportParams)).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("export  call fail", (Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean isDIAFile() {
        return this.mzdbRawFile.isDIAFile();
    }

    @Override
    public Map<String, Object> getFileProperties() {
        try {
            return this.service.submit(() -> {
                Map<String, Object> data = this.mzdbRawFile.getFileProperties();
                return data;
            }).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("getFileMetaData call fail", (Throwable)ex);
            return null;
        }
    }

    @Override
    public QCMetrics getFileMetrics() {
        try {
            return this.service.submit(() -> {
                QCMetrics metrics = this.mzdbRawFile.getFileMetrics();
                metrics.setRawFile(this);
                return metrics;
            }).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("getFileMetaData call fail", (Throwable)ex);
            return null;
        }
    }

    @Override
    public void closeIRawFile() {
        try {
            Future<?> future = this.service.submit(() -> this.mzdbRawFile.closeIRawFile());
            future.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.error("mzdbRawFile clise failed", (Throwable)ex);
        }
    }
}

