/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.processing;

import fr.proline.mzscope.model.AnnotatedChromatogram;
import fr.proline.mzscope.model.BasePeakel;
import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.model.MsnExtractionRequest;
import fr.proline.mzscope.processing.IAnnotator;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromatogramAnnotator
implements IAnnotator {
    private static final Logger logger = LoggerFactory.getLogger(ChromatogramAnnotator.class);

    @Override
    public AnnotatedChromatogram annotate(IRawFile rawFile, IChromatogram chromatogram, MsnExtractionRequest request, Integer expectedCharge) {
        try {
            int cRtIndex;
            int maxConsecutiveGaps = 3;
            double[] refTime = rawFile.getElutionTimes(request.getMsLevel());
            double[] intensities = chromatogram.getIntensities();
            double[] time = chromatogram.getTime();
            int rtIndex = ~Arrays.binarySearch(refTime, (double)request.getElutionTime());
            int cIndex = cRtIndex = ~Arrays.binarySearch(time, (double)request.getElutionTime());
            if (rtIndex != -1) {
                int k;
                int consecutiveGaps = 0;
                int cEndIdx = cIndex;
                int cStartIdx = cIndex;
                int startIdx = rtIndex;
                int endIdx = rtIndex;
                double maxIntensity = -1.0;
                for (k = rtIndex; k < refTime.length && consecutiveGaps <= maxConsecutiveGaps; ++k) {
                    if (Math.abs(refTime[k] - time[cIndex]) < 0.01) {
                        if (intensities[cIndex] > 0.0) {
                            consecutiveGaps = 0;
                            cEndIdx = cIndex;
                            endIdx = k;
                            maxIntensity = Math.max(maxIntensity, intensities[cIndex]);
                        } else {
                            ++consecutiveGaps;
                        }
                        ++cIndex;
                        continue;
                    }
                    ++consecutiveGaps;
                }
                consecutiveGaps = 0;
                cIndex = cRtIndex;
                for (k = rtIndex; k > 0 && consecutiveGaps <= maxConsecutiveGaps; --k) {
                    if (Math.abs(refTime[k] - time[cIndex]) < 0.01) {
                        if (intensities[cIndex] > 0.0) {
                            consecutiveGaps = 0;
                            cStartIdx = cIndex;
                            startIdx = k;
                            maxIntensity = Math.max(maxIntensity, intensities[cIndex]);
                        } else {
                            ++consecutiveGaps;
                        }
                        --cIndex;
                        continue;
                    }
                    ++consecutiveGaps;
                }
                BasePeakel feature = new BasePeakel((chromatogram.getMaxMz() + chromatogram.getMinMz()) / 2.0, (float)time[cRtIndex] * 60.0f, (float)time[cStartIdx] * 60.0f, (float)time[cEndIdx] * 60.0f, rawFile, request.getMsLevel());
                feature.setApexIntensity((float)maxIntensity);
                feature.setMs1Count(endIdx - startIdx + 1);
                return new AnnotatedChromatogram(chromatogram, feature);
            }
        }
        catch (Exception e) {
            logger.error("Annotation failed", (Throwable)e);
        }
        return new AnnotatedChromatogram(chromatogram, null);
    }
}

