/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.model.MsnExtractionRequest;
import fr.proline.mzscope.ui.IMzScopeController;
import fr.proline.mzscope.ui.IRawFileViewer;
import fr.proline.mzscope.ui.model.MzScopePreferences;
import fr.proline.mzscope.utils.Display;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XICExtractionPanel
extends JPanel {
    private static Logger logger = LoggerFactory.getLogger((String)"ProlineStudio.mzScope.XICExtractionPanel");
    private JScrollPane scrollPane;
    private JPanel internalPanel;
    private JPanel mainPanel;
    private JPanel massRangePanel;
    private JTextField massRangeTF;
    private JPanel tolerancePanel;
    private JTextField toleranceTF;
    private JPanel fragmentMassRangePanel;
    private JTextField fragmentMassRangeTF;
    private JPanel fragmentTolerancePanel;
    private JTextField fragmentToleranceTF;
    private final IMzScopeController appController;

    public XICExtractionPanel(IMzScopeController appController) {
        this.initComponents();
        this.appController = appController;
        this.toleranceTF.setText(Integer.toString(Math.round(MzScopePreferences.getInstance().getMzPPMTolerance())));
        this.fragmentToleranceTF.setText(Integer.toString(Math.round(MzScopePreferences.getInstance().getFragmentMzPPMTolerance())));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getScrollPane(), "Center");
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.getInternalPanel());
            this.add(this.scrollPane);
        }
        return this.scrollPane;
    }

    private JPanel getInternalPanel() {
        if (this.internalPanel == null) {
            this.internalPanel = new JPanel();
            this.internalPanel.setLayout(new BorderLayout());
            this.internalPanel.add((Component)this.getMainPanel(), "First");
        }
        return this.internalPanel;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new FlowLayout(3));
            this.mainPanel.add(this.getlMassRangePanel());
            this.mainPanel.add(this.getTolerancePanel());
            this.mainPanel.add(this.getFragmentMassRangePanel());
            this.mainPanel.add(this.getFragmentTolerancePanel());
        }
        return this.mainPanel;
    }

    private JPanel getlMassRangePanel() {
        if (this.massRangePanel == null) {
            this.massRangePanel = new JPanel();
            this.massRangePanel.setLayout(new FlowLayout(3));
            JLabel massRangeLabel = new JLabel();
            massRangeLabel.setText("Precursor Mass :");
            this.massRangePanel.add(massRangeLabel);
            this.massRangePanel.add(this.getMassRangeTF());
        }
        return this.massRangePanel;
    }

    private JTextField getMassRangeTF() {
        if (this.massRangeTF == null) {
            this.massRangeTF = new JTextField();
            this.massRangeTF.setToolTipText("<html><p width=\"500\">Precursor mass range to extract. A single value can be entered (the following tolerance value will be used) or a range of values using '-' delimiter</p></html>");
            this.massRangeTF.setColumns(10);
            this.massRangeTF.setPreferredSize(new Dimension(this.massRangeTF.getPreferredSize().width, 16));
            this.massRangeTF.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    XICExtractionPanel.this.startExtraction();
                }
            });
        }
        return this.massRangeTF;
    }

    private JPanel getTolerancePanel() {
        if (this.tolerancePanel == null) {
            this.tolerancePanel = new JPanel();
            this.tolerancePanel.setLayout(new FlowLayout(3));
            JLabel toleranceLabel = new JLabel();
            toleranceLabel.setText("+/-");
            this.tolerancePanel.add(toleranceLabel);
            this.tolerancePanel.add(this.getToleranceTF());
            JLabel toleranceUnitLabel = new JLabel();
            toleranceUnitLabel.setText("ppm");
            this.tolerancePanel.add(toleranceUnitLabel);
        }
        return this.tolerancePanel;
    }

    private JTextField getToleranceTF() {
        if (this.toleranceTF == null) {
            this.toleranceTF = new JTextField();
            this.toleranceTF.setColumns(3);
            this.toleranceTF.setPreferredSize(new Dimension(this.toleranceTF.getPreferredSize().width, 16));
            this.toleranceTF.setToolTipText("Precursor mass tolerance in ppm");
            this.toleranceTF.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    float ppm = Float.parseFloat(XICExtractionPanel.this.toleranceTF.getText().trim());
                    MzScopePreferences.getInstance().setMzPPMTolerance(ppm);
                    if (!XICExtractionPanel.this.getMassRangeTF().getText().isEmpty()) {
                        XICExtractionPanel.this.startExtraction();
                    }
                }
            });
        }
        return this.toleranceTF;
    }

    private JPanel getFragmentMassRangePanel() {
        if (this.fragmentMassRangePanel == null) {
            this.fragmentMassRangePanel = new JPanel();
            this.fragmentMassRangePanel.setLayout(new FlowLayout(3));
            JLabel fragmentMassLabel = new JLabel();
            fragmentMassLabel.setText("Fragment mass:");
            this.fragmentMassRangePanel.add(fragmentMassLabel);
            this.fragmentMassRangePanel.add(this.getFragmentMassRangeTF());
        }
        return this.fragmentMassRangePanel;
    }

    private JTextField getFragmentMassRangeTF() {
        if (this.fragmentMassRangeTF == null) {
            this.fragmentMassRangeTF = new JTextField();
            this.fragmentMassRangeTF.setToolTipText("<html><p width=\"500\">Fragment mass range to extract. A single value can be entered (the following tolerance value will be used) or a range of values using '-' delimiter</p></html>");
            this.fragmentMassRangeTF.setColumns(10);
            this.fragmentMassRangeTF.setPreferredSize(new Dimension(this.fragmentMassRangeTF.getPreferredSize().width, 16));
            this.fragmentMassRangeTF.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    XICExtractionPanel.this.startExtraction();
                }
            });
        }
        return this.fragmentMassRangeTF;
    }

    private JPanel getFragmentTolerancePanel() {
        if (this.fragmentTolerancePanel == null) {
            this.fragmentTolerancePanel = new JPanel();
            this.fragmentTolerancePanel.setLayout(new FlowLayout(3));
            JLabel gramentToleranceLabel = new JLabel();
            gramentToleranceLabel.setText("+/-");
            this.fragmentTolerancePanel.add(gramentToleranceLabel);
            this.fragmentTolerancePanel.add(this.getFragmentToleranceTF());
            JLabel fragmentToleranceUnitLabel = new JLabel();
            fragmentToleranceUnitLabel.setText("ppm");
            this.fragmentTolerancePanel.add(fragmentToleranceUnitLabel);
        }
        return this.fragmentTolerancePanel;
    }

    private JTextField getFragmentToleranceTF() {
        if (this.fragmentToleranceTF == null) {
            this.fragmentToleranceTF = new JTextField();
            this.fragmentToleranceTF.setColumns(3);
            this.fragmentToleranceTF.setPreferredSize(new Dimension(this.fragmentToleranceTF.getPreferredSize().width, 16));
            this.fragmentToleranceTF.setToolTipText("Fragment mass tolerance in ppm");
            this.fragmentToleranceTF.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    float ppm = Float.parseFloat(XICExtractionPanel.this.fragmentToleranceTF.getText().trim());
                    MzScopePreferences.getInstance().setFragmentMzPPMTolerance(ppm);
                    if (!XICExtractionPanel.this.getFragmentMassRangeTF().getText().isEmpty()) {
                        XICExtractionPanel.this.startExtraction();
                    }
                }
            });
        }
        return this.fragmentToleranceTF;
    }

    private void startExtraction() {
        IRawFileViewer currentViewer;
        float ppm;
        if (this.massRangeTF.getText() == null || this.massRangeTF.getText().isEmpty()) {
            return;
        }
        MsnExtractionRequest.Builder<?> builder = MsnExtractionRequest.builder();
        String text = this.massRangeTF.getText().trim();
        double firstMzValue = Double.NaN;
        double secondMzValue = Double.NaN;
        String[] masses = text.split("-");
        try {
            firstMzValue = Double.parseDouble(masses[0]);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "The mass value is incorrect: " + masses[0]);
            return;
        }
        try {
            ppm = Float.parseFloat(this.toleranceTF.getText().trim());
            MzScopePreferences.getInstance().setMzPPMTolerance(ppm);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "The tolerance value is incorrect: " + this.toleranceTF.getText().trim());
            return;
        }
        if (masses.length == 1) {
            builder.setMz(firstMzValue);
            builder.setMzTolPPM(ppm);
        } else {
            try {
                secondMzValue = Double.parseDouble(masses[1]);
                builder.setMinMz(firstMzValue);
                builder.setMaxMz(secondMzValue);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "The max mass value is incorrect: " + masses[1]);
                return;
            }
        }
        if (this.fragmentMassRangeTF.isEnabled() && this.fragmentMassRangeTF.getText() != null && !this.fragmentMassRangeTF.getText().isEmpty()) {
            text = this.fragmentMassRangeTF.getText().trim();
            masses = text.split("-");
            try {
                firstMzValue = Double.parseDouble(masses[0]);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "The mass value is incorrect: " + masses[0]);
                return;
            }
            try {
                ppm = Float.parseFloat(this.fragmentToleranceTF.getText().trim());
                MzScopePreferences.getInstance().setFragmentMzPPMTolerance(ppm);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "The tolerance value is incorrect: " + this.fragmentToleranceTF.getText().trim());
                return;
            }
            if (masses.length == 1) {
                builder.setFragmentMz(firstMzValue);
                builder.setFragmentMzTolPPM(ppm);
            } else {
                try {
                    secondMzValue = Double.parseDouble(masses[1]);
                    builder.setFragmentMinMz(firstMzValue);
                    builder.setFragmentMaxMz(secondMzValue);
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "The max mass value is incorrect: " + masses[1]);
                    return;
                }
            }
        }
        if ((currentViewer = this.appController.getCurrentRawFileViewer()) != null) {
            currentViewer.extractAndDisplayChromatogram(builder.build(), new Display(currentViewer.getChromatogramDisplayMode()), null);
        }
    }

    public void setDIAEnabled(boolean diaEnabled) {
        this.getFragmentMassRangeTF().setEnabled(diaEnabled);
        this.getFragmentToleranceTF().setEditable(diaEnabled);
    }
}

