/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.model;

import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.DoubleFilter;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.IntegerFilter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotDataSpec;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.table.LazyData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTableModel
extends AbstractTableModel
implements GlobalTableModelInterface {
    private static final Logger logger = LoggerFactory.getLogger(MapTableModel.class);
    private String name;
    private List<List<Object>> valuesByRows = new ArrayList<List<Object>>();
    private List<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>();

    public void setData(List<Map<String, Object>> maps, List<String> names) {
        this.columns = this.extractKeys(maps);
        this.valuesByRows = new ArrayList<List<Object>>();
        for (int k = 0; k < maps.size(); ++k) {
            Map<String, Object> map = maps.get(k);
            ArrayList<Object> rowValues = new ArrayList<Object>();
            rowValues.add(names.get(k));
            for (int c = 1; c < this.columns.size(); ++c) {
                ColumnDescriptor col = this.columns.get(c);
                Object value = map.get(col.label);
                rowValues.add(value);
            }
            this.valuesByRows.add(rowValues);
        }
        this.fireTableStructureChanged();
    }

    private List<ColumnDescriptor> extractKeys(List<Map<String, Object>> maps) {
        ArrayList<ColumnDescriptor> keys = new ArrayList<ColumnDescriptor>();
        keys.add(new ColumnDescriptor("Id", String.class));
        HashSet<String> dictionnary = new HashSet<String>();
        for (Map<String, Object> map : maps) {
            for (Map.Entry<String, Object> e : map.entrySet()) {
                if (dictionnary.contains(e.getKey())) continue;
                keys.add(new ColumnDescriptor(e.getKey(), this.getValueClass(e.getKey(), maps)));
                dictionnary.add(e.getKey());
            }
        }
        return keys;
    }

    private Class getValueClass(String key, List<Map<String, Object>> maps) {
        Map<String, Object> map;
        Object value = null;
        Iterator<Map<String, Object>> iterator = maps.iterator();
        while (iterator.hasNext() && (value = (map = iterator.next()).get(key)) == null) {
        }
        return value.getClass();
    }

    @Override
    public int getRowCount() {
        return this.valuesByRows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.valuesByRows.get(rowIndex).get(columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns.get((int)columnIndex).label;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columns.get((int)columnIndex).clazz;
    }

    public String getToolTipForHeader(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public String getTootlTipValue(int row, int col) {
        return null;
    }

    public TableCellRenderer getRenderer(int row, int col) {
        return null;
    }

    public Long getTaskId() {
        return -1L;
    }

    public LazyData getLazyData(int row, int col) {
        return null;
    }

    public void givePriorityTo(Long taskId, int row, int col) {
    }

    public void sortingChanged(int col) {
    }

    public int getSubTaskId(int col) {
        return -1;
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        return this.getColumnClass(columnIndex);
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        return this.getValueAt(rowIndex, columnIndex);
    }

    public PlotDataSpec getDataSpecAt(int i) {
        return null;
    }

    public int[] getKeysColumn() {
        return null;
    }

    public int getInfoColumn() {
        return 0;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        return null;
    }

    public long row2UniqueId(int rowIndex) {
        return rowIndex;
    }

    public int uniqueId2Row(long id) {
        return (int)id;
    }

    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        block12: for (int k = 0; k < this.columns.size(); ++k) {
            switch (this.columns.get((int)k).clazz.getSimpleName()) {
                case "String": {
                    filtersMap.put(k, (Filter)new StringDiffFilter(this.getColumnName(k), null, k));
                    continue block12;
                }
                case "Double": 
                case "double": {
                    filtersMap.put(k, (Filter)new DoubleFilter(this.getColumnName(k), null, k));
                    continue block12;
                }
                case "Integer": 
                case "int": {
                    filtersMap.put(k, (Filter)new IntegerFilter(this.getColumnName(k), null, k));
                    continue block12;
                }
                default: {
                    System.out.println("no filter for type : " + this.columns.get((int)k).clazz.getSimpleName());
                }
            }
        }
    }

    public boolean isLoaded() {
        return true;
    }

    public int getLoadingPercentage() {
        return 100;
    }

    public PlotType getBestPlotType() {
        return PlotType.SCATTER_PLOT;
    }

    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    public String getExportRowCell(int row, int col) {
        return null;
    }

    public String getExportColumnName(int col) {
        return this.getColumnName(col);
    }

    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return null;
    }

    public Object getValue(Class c) {
        return null;
    }

    public void addSingleValue(Object v) {
    }

    public Object getSingleValue(Class c) {
        return null;
    }

    public Object getRowValue(Class c, int row) {
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    private static class ColumnDescriptor {
        String label;
        Class clazz;

        public ColumnDescriptor(String label, Class clazz) {
            this.label = label;
            this.clazz = clazz;
        }
    }
}

