/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm;

import fr.proline.studio.dam.taskinfo.TaskInfoManager;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.util.JMSConnectionManager;
import java.util.LinkedList;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import org.slf4j.LoggerFactory;

public class AccessJMSManagerThread
extends Thread {
    private static AccessJMSManagerThread m_instance;
    private Connection m_connection;
    private Session m_session;
    private LinkedList<AbstractJMSTask> m_taskList = new LinkedList();

    public static AccessJMSManagerThread getAccessJMSManagerThread() {
        if (m_instance == null) {
            m_instance = new AccessJMSManagerThread();
            m_instance.start();
        }
        return m_instance;
    }

    private AccessJMSManagerThread() {
        super("AccessJMSManagerThread");
        this.initSession();
    }

    public Session getSession() {
        return this.m_session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                AbstractJMSTask task = null;
                AccessJMSManagerThread accessJMSManagerThread = this;
                synchronized (accessJMSManagerThread) {
                    while (true) {
                        if (!this.m_taskList.isEmpty()) break;
                        this.wait();
                    }
                    task = this.m_taskList.poll();
                    this.notifyAll();
                }
                this.initSession();
                LoggerFactory.getLogger((String)"ProlineStudio.DPM").debug("**JMSTEST** " + Thread.currentThread().getId() + ":" + Thread.currentThread().getName() + " task.askJMS " + ((Object)((Object)task)).getClass());
                task.askJMS();
            }
        }
        catch (InterruptedException | JMSException t) {
            LoggerFactory.getLogger((String)"ProlineStudio.DPM").debug("Unexpected exception in main loop of AccessServiceThread", t);
            m_instance = null;
            return;
        }
    }

    private void initSession() {
        if (this.m_connection == null) {
            try {
                this.m_connection = JMSConnectionManager.getJMSConnectionManager().getJMSConnection();
                this.m_connection.start();
                this.m_session = this.m_connection.createSession(false, 2);
            }
            catch (JMSException je) {
                LoggerFactory.getLogger((String)"ProlineStudio.DPM").error("Unexpected exception when initializing JMS Connection", (Throwable)je);
            }
            catch (Exception e) {
                LoggerFactory.getLogger((String)"ProlineStudio.DPM").error("Unexpected exception when initializing JMS Connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTask(AbstractJMSTask task) {
        TaskInfoManager.getTaskInfoManager().add(task.getTaskInfo());
        AccessJMSManagerThread accessJMSManagerThread = this;
        synchronized (accessJMSManagerThread) {
            this.m_taskList.add(task);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        if (this.m_session != null) {
            AccessJMSManagerThread accessJMSManagerThread = this;
            synchronized (accessJMSManagerThread) {
                try {
                    this.m_session.close();
                    this.m_taskList.clear();
                }
                catch (Exception exception) {
                }
                finally {
                    this.m_session = null;
                    this.m_connection = null;
                }
            }
        }
    }
}

