/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dpm.task.jms;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dpm.serverfilesystem.ServerFile;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class FileSystemBrowseTask
extends AbstractJMSTask {
    private String m_dirPath;
    private ArrayList<ServerFile> m_files;

    public FileSystemBrowseTask(AbstractJMSCallback callback, String dirPath, ArrayList<ServerFile> files) {
        super(callback, new TaskInfo("Browse Server File System " + dirPath, true, "Services JMS", TaskInfo.INFO_IMPORTANCE_LOW));
        this.m_dirPath = dirPath;
        this.m_files = files;
    }

    @Override
    public void taskRun() throws JMSException {
        JSONRPC2Request jsonRequest = new JSONRPC2Request("retrieve_directory_content", (Object)this.m_taskInfo.getId());
        jsonRequest.setNamedParams(this.createParams());
        TextMessage message = this.m_session.createTextMessage(jsonRequest.toJSONString());
        message.setJMSReplyTo((Destination)this.m_replyQueue);
        message.setStringProperty("Proline_ServiceName", "proline/misc/FileSystem");
        this.addSupplementaryInfo((Message)message);
        this.setTaskInfoRequest(message.getText());
        this.m_producer.send((Message)message);
        m_loggerProline.info("Message [{}] sent", (Object)message.getJMSMessageID());
        this.m_taskInfo.setJmsMessageID(message.getJMSMessageID());
    }

    private HashMap<String, Object> createParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("label_path", this.m_dirPath);
        params.put("include_files", Boolean.TRUE);
        params.put("include_dirs", Boolean.TRUE);
        return params;
    }

    @Override
    public void taskDone(Message jmsMessage) throws Exception {
        TextMessage textMessage = (TextMessage)jmsMessage;
        String jsonString = textMessage.getText();
        JSONRPC2Message jsonMessage = JSONRPC2Message.parse((String)jsonString);
        if (jsonMessage instanceof JSONRPC2Notification) {
            m_loggerProline.warn("JSON Notification method: " + ((JSONRPC2Notification)jsonMessage).getMethod() + " instead of JSON Response");
            throw new Exception("Invalid JSONRPC2Message type");
        }
        if (jsonMessage instanceof JSONRPC2Response) {
            JSONRPC2Response jsonResponse = (JSONRPC2Response)jsonMessage;
            m_loggerProline.debug("JSON Response Id: " + jsonResponse.getID());
            JSONRPC2Error jsonError = jsonResponse.getError();
            if (jsonError != null) {
                m_loggerProline.error("JSON Error code {}, message : \"{}\"", (Object)jsonError.getCode(), (Object)jsonError.getMessage());
                m_loggerProline.error("JSON Throwable", (Throwable)jsonError);
                throw jsonError;
            }
            Object result = jsonResponse.getResult();
            if (result == null || !ArrayList.class.isInstance(result)) {
                m_loggerProline.debug("Invalid or no result");
                throw new Exception("null or invalid result " + result);
            }
            ArrayList resultList = (ArrayList)result;
            for (int i = 0; i < resultList.size(); ++i) {
                ServerFile f;
                Map fileMap = (Map)resultList.get(i);
                boolean isDir = (Boolean)fileMap.get("is_dir");
                if (isDir) {
                    f = new ServerFile((String)fileMap.get("path"), (String)fileMap.get("name"), true, 0L, 0L);
                } else {
                    Long size = fileMap.containsKey("size") ? (Long)fileMap.get("size") : 0L;
                    f = new ServerFile((String)fileMap.get("path"), (String)fileMap.get("name"), false, (Long)fileMap.get("lastmodified"), size);
                }
                this.m_files.add(f);
            }
        }
        this.m_currentState = AbstractJMSTask.JMSState.STATE_DONE;
    }
}

