/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.forester.io.parsers.FastaParser;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.msa.Msa;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.BranchWidth;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sequence.MolecularSequence;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class PhylogenyMethods {
    private PhylogenyMethods() {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public static boolean extractFastaInformation(Phylogeny phy) {
        boolean could_extract = false;
        PhylogenyNodeIterator iter = phy.iteratorExternalForward();
        while (iter.hasNext()) {
            Matcher name_m;
            PhylogenyNode node = iter.next();
            if (ForesterUtil.isEmpty(node.getName()) || !(name_m = FastaParser.FASTA_DESC_LINE.matcher(node.getName())).lookingAt()) continue;
            could_extract = true;
            String acc_source = name_m.group(1);
            String acc = name_m.group(2);
            String seq_name = name_m.group(3);
            String tax_sn = name_m.group(4);
            if (!ForesterUtil.isEmpty(acc_source) && !ForesterUtil.isEmpty(acc)) {
                ForesterUtil.ensurePresenceOfSequence(node);
                node.getNodeData().getSequence(0).setAccession(new Accession(acc, acc_source));
            }
            if (!ForesterUtil.isEmpty(seq_name)) {
                ForesterUtil.ensurePresenceOfSequence(node);
                node.getNodeData().getSequence(0).setName(seq_name);
            }
            if (ForesterUtil.isEmpty(tax_sn)) continue;
            ForesterUtil.ensurePresenceOfTaxonomy(node);
            node.getNodeData().getTaxonomy(0).setScientificName(tax_sn);
        }
        return could_extract;
    }

    public static DescriptiveStatistics calculateBranchLengthStatistics(Phylogeny phy) {
        BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
        PhylogenyNodeIterator iter = phy.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode n = iter.next();
            if (n.isRoot() || !(n.getDistanceToParent() >= 0.0)) continue;
            stats.addValue(n.getDistanceToParent());
        }
        return stats;
    }

    public static List<DescriptiveStatistics> calculateConfidenceStatistics(Phylogeny phy) {
        ArrayList<DescriptiveStatistics> stats = new ArrayList<DescriptiveStatistics>();
        PhylogenyNodeIterator iter = phy.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode n = iter.next();
            if (n.isExternal() || n.isRoot() || !n.getBranchData().isHasConfidences()) continue;
            for (int i = 0; i < n.getBranchData().getConfidences().size(); ++i) {
                Confidence c = n.getBranchData().getConfidences().get(i);
                if (i > stats.size() - 1 || stats.get(i) == null) {
                    stats.add(i, new BasicDescriptiveStatistics());
                }
                if (!ForesterUtil.isEmpty(c.getType())) {
                    if (!ForesterUtil.isEmpty(((DescriptiveStatistics)stats.get(i)).getDescription()) && !((DescriptiveStatistics)stats.get(i)).getDescription().equalsIgnoreCase(c.getType())) {
                        throw new IllegalArgumentException("support values in node [" + n.toString() + "] appear inconsistently ordered");
                    }
                    ((DescriptiveStatistics)stats.get(i)).setDescription(c.getType());
                }
                ((DescriptiveStatistics)stats.get(i)).addValue(c != null && c.getValue() >= 0.0 ? c.getValue() : 0.0);
            }
        }
        return stats;
    }

    public static double calculateDistance(PhylogenyNode node1, PhylogenyNode node2) {
        PhylogenyNode lca = PhylogenyMethods.calculateLCA(node1, node2);
        PhylogenyNode n1 = node1;
        PhylogenyNode n2 = node2;
        return PhylogenyMethods.getDistance(n1, lca) + PhylogenyMethods.getDistance(n2, lca);
    }

    public static final PhylogenyNode calculateLCA(PhylogenyNode node1, PhylogenyNode node2) {
        if (node1 == null) {
            throw new IllegalArgumentException("first argument (node) is null");
        }
        if (node2 == null) {
            throw new IllegalArgumentException("second argument (node) is null");
        }
        if (node1 == node2) {
            return node1;
        }
        if (node1.getParent() == node2.getParent()) {
            return node1.getParent();
        }
        int depth1 = node1.calculateDepth();
        int depth2 = node2.calculateDepth();
        while (depth1 > -1 && depth2 > -1) {
            if (depth1 > depth2) {
                node1 = node1.getParent();
                --depth1;
                continue;
            }
            if (depth2 > depth1) {
                node2 = node2.getParent();
                --depth2;
                continue;
            }
            if (node1 == node2) {
                return node1;
            }
            node1 = node1.getParent();
            node2 = node2.getParent();
            --depth1;
            --depth2;
        }
        throw new IllegalArgumentException("illegal attempt to calculate LCA of two nodes which do not share a common root");
    }

    public static final PhylogenyNode calculateLCAonTreeWithIdsInPreOrder(PhylogenyNode node1, PhylogenyNode node2) {
        if (node1 == null) {
            throw new IllegalArgumentException("first argument (node) is null");
        }
        if (node2 == null) {
            throw new IllegalArgumentException("second argument (node) is null");
        }
        while (node1 != node2) {
            if (node1.getId() > node2.getId()) {
                node1 = node1.getParent();
                continue;
            }
            node2 = node2.getParent();
        }
        return node1;
    }

    public static short calculateMaxBranchesToLeaf(PhylogenyNode node) {
        if (node.isExternal()) {
            return 0;
        }
        short max = 0;
        Iterator<PhylogenyNode> iterator = node.getAllExternalDescendants().iterator();
        while (iterator.hasNext()) {
            short steps = 0;
            for (PhylogenyNode d = iterator.next(); d != node; d = d.getParent()) {
                steps = d.isCollapse() ? (short)0 : (short)(steps + 1);
            }
            if (max >= steps) continue;
            max = steps;
        }
        return max;
    }

    public static int calculateMaxDepth(Phylogeny phy) {
        int max = 0;
        PhylogenyNodeIterator iter = phy.iteratorExternalForward();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            int steps = node.calculateDepth();
            if (steps <= max) continue;
            max = steps;
        }
        return max;
    }

    public static double calculateMaxDistanceToRoot(Phylogeny phy) {
        double max = 0.0;
        PhylogenyNodeIterator iter = phy.iteratorExternalForward();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            double d = node.calculateDistanceToRoot();
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    public static PhylogenyNode calculateNodeWithMaxDistanceToRoot(Phylogeny phy) {
        double max = 0.0;
        PhylogenyNode max_node = phy.getFirstExternalNode();
        PhylogenyNodeIterator iter = phy.iteratorExternalForward();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            double d = node.calculateDistanceToRoot();
            if (!(d > max)) continue;
            max = d;
            max_node = node;
        }
        return max_node;
    }

    public static int calculateNumberOfExternalNodesWithoutTaxonomy(PhylogenyNode node) {
        List<PhylogenyNode> descs = node.getAllExternalDescendants();
        int x = 0;
        for (PhylogenyNode n : descs) {
            if (n.getNodeData().isHasTaxonomy() && !n.getNodeData().getTaxonomy().isEmpty()) continue;
            ++x;
        }
        return x;
    }

    public static DescriptiveStatistics calculateNumberOfDescendantsPerNodeStatistics(Phylogeny phy) {
        BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
        PhylogenyNodeIterator iter = phy.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode n = iter.next();
            if (n.isExternal()) continue;
            stats.addValue(n.getNumberOfDescendants());
        }
        return stats;
    }

    public static final void collapseSubtreeStructure(PhylogenyNode n) {
        List<PhylogenyNode> eds = n.getAllExternalDescendants();
        ArrayList<Double> d = new ArrayList<Double>();
        for (PhylogenyNode ed : eds) {
            d.add(PhylogenyMethods.calculateDistanceToAncestor(n, ed));
        }
        for (int i = 0; i < eds.size(); ++i) {
            n.setChildNode(i, eds.get(i));
            eds.get(i).setDistanceToParent((Double)d.get(i));
        }
    }

    public static int countNumberOfOneDescendantNodes(Phylogeny phy) {
        int count = 0;
        PhylogenyNodeIterator iter = phy.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode n = iter.next();
            if (n.isExternal() || n.getNumberOfDescendants() != 1) continue;
            ++count;
        }
        return count;
    }

    public static int countNumberOfPolytomies(Phylogeny phy) {
        int count = 0;
        PhylogenyNodeIterator iter = phy.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode n = iter.next();
            if (n.isExternal() || n.getNumberOfDescendants() <= 2) continue;
            ++count;
        }
        return count;
    }

    public static final HashMap<String, PhylogenyNode> createNameToExtNodeMap(Phylogeny phy) {
        HashMap<String, PhylogenyNode> nodes = new HashMap<String, PhylogenyNode>();
        List<PhylogenyNode> ext = phy.getExternalNodes();
        for (PhylogenyNode n : ext) {
            nodes.put(n.getName(), n);
        }
        return nodes;
    }

    public static void deleteExternalNodesNegativeSelection(Set<Long> to_delete, Phylogeny phy) {
        for (Long id : to_delete) {
            phy.deleteSubtree(phy.getNode(id), true);
        }
        phy.clearHashIdToNodeMap();
        phy.externalNodesHaveChanged();
    }

    public static void deleteExternalNodesNegativeSelection(String[] node_names_to_delete, Phylogeny p) throws IllegalArgumentException {
        for (String element : node_names_to_delete) {
            if (ForesterUtil.isEmpty(element)) continue;
            List<PhylogenyNode> nodes = null;
            nodes = p.getNodes(element);
            for (PhylogenyNode n : nodes) {
                if (!n.isExternal()) {
                    throw new IllegalArgumentException("attempt to delete non-external node \"" + element + "\"");
                }
                p.deleteSubtree(n, true);
            }
        }
        p.clearHashIdToNodeMap();
        p.externalNodesHaveChanged();
    }

    public static List<String> deleteExternalNodesPositiveSelection(String[] node_names_to_keep, Phylogeny p) {
        PhylogenyNodeIterator it = p.iteratorExternalForward();
        String[] to_delete = new String[p.getNumberOfExternalNodes()];
        int i = 0;
        Arrays.sort(node_names_to_keep);
        while (it.hasNext()) {
            String curent_name = it.next().getName();
            if (Arrays.binarySearch(node_names_to_keep, curent_name) >= 0) continue;
            to_delete[i++] = curent_name;
        }
        PhylogenyMethods.deleteExternalNodesNegativeSelection(to_delete, p);
        ArrayList<String> deleted = new ArrayList<String>();
        for (String n : to_delete) {
            if (ForesterUtil.isEmpty(n)) continue;
            deleted.add(n);
        }
        return deleted;
    }

    public static void deleteExternalNodesPositiveSelectionT(List<Taxonomy> species_to_keep, Phylogeny phy) {
        HashSet<Long> to_delete = new HashSet<Long>();
        PhylogenyNodeIterator it = phy.iteratorExternalForward();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (n.getNodeData().isHasTaxonomy()) {
                if (species_to_keep.contains(n.getNodeData().getTaxonomy())) continue;
                to_delete.add(n.getId());
                continue;
            }
            throw new IllegalArgumentException("node " + n.getId() + " has no taxonomic data");
        }
        PhylogenyMethods.deleteExternalNodesNegativeSelection(to_delete, phy);
    }

    public static final void deleteInternalNodesWithOnlyOneDescendent(Phylogeny phy) {
        ArrayList<PhylogenyNode> to_delete = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator iter = phy.iteratorPostorder();
        while (iter.hasNext()) {
            PhylogenyNode n = iter.next();
            if (n.isExternal() || n.getNumberOfDescendants() != 1) continue;
            to_delete.add(n);
        }
        for (PhylogenyNode d : to_delete) {
            PhylogenyMethods.removeNode(d, phy);
        }
        phy.clearHashIdToNodeMap();
        phy.externalNodesHaveChanged();
    }

    public static final void deleteNonOrthologousExternalNodes(Phylogeny phy, PhylogenyNode n) {
        if (n.isInternal()) {
            throw new IllegalArgumentException("node is not external");
        }
        ArrayList<PhylogenyNode> to_delete = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator it = phy.iteratorExternalForward();
        while (it.hasNext()) {
            PhylogenyNode i = it.next();
            if (PhylogenyMethods.getEventAtLCA(n, i).isSpeciation()) continue;
            to_delete.add(i);
        }
        for (PhylogenyNode d : to_delete) {
            phy.deleteSubtree(d, true);
        }
        phy.clearHashIdToNodeMap();
        phy.externalNodesHaveChanged();
    }

    public static final List<List<PhylogenyNode>> divideIntoSubTrees(Phylogeny phy, double min_distance_to_root) {
        if (min_distance_to_root <= 0.0) {
            throw new IllegalArgumentException("attempt to use min distance to root of: " + min_distance_to_root);
        }
        ArrayList<List<PhylogenyNode>> l = new ArrayList<List<PhylogenyNode>>();
        PhylogenyMethods.setAllIndicatorsToZero(phy);
        PhylogenyNodeIterator it = phy.iteratorExternalForward();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (n.getIndicator() != 0) continue;
            l.add(PhylogenyMethods.divideIntoSubTreesHelper(n, min_distance_to_root));
            if (!l.isEmpty()) continue;
            throw new RuntimeException("this should not have happened");
        }
        return l;
    }

    public static List<PhylogenyNode> getAllDescendants(PhylogenyNode node) {
        ArrayList<PhylogenyNode> descs = new ArrayList<PhylogenyNode>();
        HashSet<Long> encountered = new HashSet<Long>();
        if (!node.isExternal()) {
            List<PhylogenyNode> exts = node.getAllExternalDescendants();
            for (PhylogenyNode current : exts) {
                descs.add(current);
                while (current != node) {
                    if (encountered.contains((current = current.getParent()).getId())) continue;
                    descs.add(current);
                    encountered.add(current.getId());
                }
            }
        }
        return descs;
    }

    public static Color getBranchColorValue(PhylogenyNode node) {
        if (node.getBranchData().getBranchColor() == null) {
            return null;
        }
        return node.getBranchData().getBranchColor().getValue();
    }

    public static double getBranchWidthValue(PhylogenyNode node) {
        if (!node.getBranchData().isHasBranchWidth()) {
            return 1.0;
        }
        return node.getBranchData().getBranchWidth().getValue();
    }

    public static double getConfidenceValue(PhylogenyNode node) {
        if (!node.getBranchData().isHasConfidences()) {
            return -9999.0;
        }
        return node.getBranchData().getConfidence(0).getValue();
    }

    public static double[] getConfidenceValuesAsArray(PhylogenyNode node) {
        if (!node.getBranchData().isHasConfidences()) {
            return new double[0];
        }
        double[] values = new double[node.getBranchData().getConfidences().size()];
        int i = 0;
        for (Confidence c : node.getBranchData().getConfidences()) {
            values[i++] = c.getValue();
        }
        return values;
    }

    public static final Event getEventAtLCA(PhylogenyNode n1, PhylogenyNode n2) {
        return PhylogenyMethods.calculateLCA(n1, n2).getNodeData().getEvent();
    }

    public static Taxonomy getExternalDescendantsTaxonomy(PhylogenyNode node) {
        List<PhylogenyNode> descs = node.getAllExternalDescendants();
        Taxonomy tax = null;
        for (PhylogenyNode n : descs) {
            if (!n.getNodeData().isHasTaxonomy() || n.getNodeData().getTaxonomy().isEmpty()) {
                return null;
            }
            if (tax == null) {
                tax = n.getNodeData().getTaxonomy();
                continue;
            }
            if (!n.getNodeData().getTaxonomy().isEmpty() && tax.isEqual(n.getNodeData().getTaxonomy())) continue;
            return null;
        }
        return tax;
    }

    public static PhylogenyNode getFurthestDescendant(PhylogenyNode node) {
        List<PhylogenyNode> children = node.getAllExternalDescendants();
        PhylogenyNode farthest = null;
        double longest = -1.7976931348623157E308;
        for (PhylogenyNode child : children) {
            if (!(PhylogenyMethods.getDistance(child, node) > longest)) continue;
            farthest = child;
            longest = PhylogenyMethods.getDistance(child, node);
        }
        return farthest;
    }

    public static double getMaximumConfidenceValue(Phylogeny phy) {
        double max = -1.7976931348623157E308;
        PhylogenyNodeIterator iter = phy.iteratorPreorder();
        while (iter.hasNext()) {
            double s = PhylogenyMethods.getConfidenceValue(iter.next());
            if (s == -9999.0 || !(s > max)) continue;
            max = s;
        }
        return max;
    }

    public static int getMinimumDescendentsPerInternalNodes(Phylogeny phy) {
        int min = Integer.MAX_VALUE;
        int d = 0;
        PhylogenyNodeIterator it = phy.iteratorPreorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (!n.isInternal() || (d = n.getNumberOfDescendants()) >= min) continue;
            min = d;
        }
        return min;
    }

    public static String getSpecies(PhylogenyNode node) {
        if (!node.getNodeData().isHasTaxonomy()) {
            return "";
        }
        if (!ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getScientificName())) {
            return node.getNodeData().getTaxonomy().getScientificName();
        }
        if (!ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getTaxonomyCode())) {
            return node.getNodeData().getTaxonomy().getTaxonomyCode();
        }
        return node.getNodeData().getTaxonomy().getCommonName();
    }

    public static String getTaxonomyIdentifier(PhylogenyNode node) {
        if (!node.getNodeData().isHasTaxonomy() || node.getNodeData().getTaxonomy().getIdentifier() == null) {
            return "";
        }
        return node.getNodeData().getTaxonomy().getIdentifier().getValue();
    }

    public static final boolean isAllDecendentsAreDuplications(PhylogenyNode n) {
        if (n.isExternal()) {
            return true;
        }
        if (n.isDuplication()) {
            for (PhylogenyNode desc : n.getDescendants()) {
                if (PhylogenyMethods.isAllDecendentsAreDuplications(desc)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isHasExternalDescendant(PhylogenyNode node) {
        for (int i = 0; i < node.getNumberOfDescendants(); ++i) {
            if (!node.getChildNode(i).isExternal()) continue;
            return true;
        }
        return false;
    }

    public static synchronized boolean isTaxonomyHasIdentifierOfGivenProvider(Taxonomy tax, String[] providers) {
        if (tax.getIdentifier() != null && !ForesterUtil.isEmpty(tax.getIdentifier().getProvider())) {
            String my_tax_prov = tax.getIdentifier().getProvider();
            for (String provider : providers) {
                if (!provider.equalsIgnoreCase(my_tax_prov)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static void midpointRoot(Phylogeny phylogeny) {
        if (phylogeny.getNumberOfExternalNodes() < 2 || PhylogenyMethods.calculateMaxDistanceToRoot(phylogeny) <= 0.0) {
            return;
        }
        int counter = 0;
        int total_nodes = phylogeny.getNodeCount();
        while (true) {
            if (++counter > total_nodes) {
                throw new RuntimeException("this should not have happened: midpoint rooting does not converge");
            }
            PhylogenyNode a = null;
            double da = 0.0;
            double db = 0.0;
            for (int i = 0; i < phylogeny.getRoot().getNumberOfDescendants(); ++i) {
                PhylogenyNode f = PhylogenyMethods.getFurthestDescendant(phylogeny.getRoot().getChildNode(i));
                double df = PhylogenyMethods.getDistance(f, phylogeny.getRoot());
                if (!(df > 0.0)) continue;
                if (df > da) {
                    db = da;
                    da = df;
                    a = f;
                    continue;
                }
                if (!(df > db)) continue;
                db = df;
            }
            double diff = da - db;
            if (diff < 1.0E-6) break;
            double x = da - diff / 2.0;
            while (x > a.getDistanceToParent() && !a.isRoot()) {
                x -= a.getDistanceToParent() > 0.0 ? a.getDistanceToParent() : 0.0;
                a = a.getParent();
            }
            phylogeny.reRoot(a, x);
        }
        phylogeny.recalculateNumberOfExternalDescendants(true);
    }

    public static void normalizeBootstrapValues(Phylogeny phylogeny, double max_bootstrap_value, double max_normalized_value) {
        PhylogenyNodeIterator iter = phylogeny.iteratorPreorder();
        while (iter.hasNext()) {
            double confidence;
            PhylogenyNode node = iter.next();
            if (!node.isInternal() || (confidence = PhylogenyMethods.getConfidenceValue(node)) == -9999.0) continue;
            if (confidence >= max_bootstrap_value) {
                PhylogenyMethods.setBootstrapConfidence(node, max_normalized_value);
                continue;
            }
            PhylogenyMethods.setBootstrapConfidence(node, confidence * max_normalized_value / max_bootstrap_value);
        }
    }

    public static List<PhylogenyNode> obtainAllNodesAsList(Phylogeny phy) {
        ArrayList<PhylogenyNode> nodes = new ArrayList<PhylogenyNode>();
        if (phy.isEmpty()) {
            return nodes;
        }
        PhylogenyNodeIterator iter = phy.iteratorPreorder();
        while (iter.hasNext()) {
            nodes.add(iter.next());
        }
        return nodes;
    }

    public static Map<Taxonomy, Integer> obtainDistinctTaxonomyCounts(PhylogenyNode node) {
        List<PhylogenyNode> descs = node.getAllExternalDescendants();
        HashMap<Taxonomy, Integer> tax_map = new HashMap<Taxonomy, Integer>();
        for (PhylogenyNode n : descs) {
            if (!n.getNodeData().isHasTaxonomy() || n.getNodeData().getTaxonomy().isEmpty()) {
                return null;
            }
            Taxonomy t = n.getNodeData().getTaxonomy();
            if (tax_map.containsKey(t)) {
                tax_map.put(t, (Integer)tax_map.get(t) + 1);
                continue;
            }
            tax_map.put(t, 1);
        }
        return tax_map;
    }

    public static void orderAppearance(PhylogenyNode n, boolean order, boolean order_ext_alphabetically, DESCENDANT_SORT_PRIORITY pri) {
        if (n.isExternal()) {
            return;
        }
        PhylogenyNode temp = null;
        if (n.getNumberOfDescendants() == 2 && n.getChildNode1().getNumberOfExternalNodes() != n.getChildNode2().getNumberOfExternalNodes() && n.getChildNode1().getNumberOfExternalNodes() < n.getChildNode2().getNumberOfExternalNodes() == order) {
            temp = n.getChildNode1();
            n.setChild1(n.getChildNode2());
            n.setChild2(temp);
        } else if (order_ext_alphabetically) {
            boolean all_ext = true;
            for (PhylogenyNode i : n.getDescendants()) {
                if (i.isExternal()) continue;
                all_ext = false;
                break;
            }
            if (all_ext) {
                PhylogenyMethods.sortNodeDescendents(n, pri);
            }
        }
        for (int i = 0; i < n.getNumberOfDescendants(); ++i) {
            PhylogenyMethods.orderAppearance(n.getChildNode(i), order, order_ext_alphabetically, pri);
        }
    }

    public static void postorderBranchColorAveragingExternalNodeBased(Phylogeny p) {
        PhylogenyNodeIterator iter = p.iteratorPostorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            double red = 0.0;
            double green = 0.0;
            double blue = 0.0;
            int n = 0;
            if (!node.isInternal()) continue;
            for (int i = 0; i < node.getNumberOfDescendants(); ++i) {
                PhylogenyNode child_node = node.getChildNode(i);
                Color child_color = PhylogenyMethods.getBranchColorValue(child_node);
                if (child_color == null) continue;
                ++n;
                red += (double)child_color.getRed();
                green += (double)child_color.getGreen();
                blue += (double)child_color.getBlue();
            }
            PhylogenyMethods.setBranchColorValue(node, new Color(ForesterUtil.roundToInt(red / (double)n), ForesterUtil.roundToInt(green / (double)n), ForesterUtil.roundToInt(blue / (double)n)));
        }
    }

    public static final void preOrderReId(Phylogeny phy) {
        if (phy.isEmpty()) {
            return;
        }
        phy.setIdToNodeMap(null);
        long i = PhylogenyNode.getNodeCount();
        PhylogenyNodeIterator it = phy.iteratorPreorder();
        while (it.hasNext()) {
            it.next().setId(i++);
        }
        PhylogenyNode.setNodeCount(i);
    }

    public static final Phylogeny[] readPhylogenies(PhylogenyParser parser, File file) throws IOException {
        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
        Phylogeny[] trees = factory.create(file, parser);
        if (trees == null || trees.length == 0) {
            throw new PhylogenyParserException("Unable to parse phylogeny from file: " + file);
        }
        return trees;
    }

    public static final Phylogeny[] readPhylogenies(PhylogenyParser parser, List<File> files) throws IOException {
        ArrayList<Phylogeny> tree_list = new ArrayList<Phylogeny>();
        for (File file : files) {
            PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny[] trees = factory.create(file, parser);
            if (trees == null || trees.length == 0) {
                throw new PhylogenyParserException("Unable to parse phylogeny from file: " + file);
            }
            tree_list.addAll(Arrays.asList(trees));
        }
        return tree_list.toArray(new Phylogeny[tree_list.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void removeNode(PhylogenyNode remove_me, Phylogeny phylogeny) {
        if (remove_me.isRoot()) {
            if (remove_me.getNumberOfDescendants() != 1) throw new IllegalArgumentException("attempt to remove a root node with more than one descendants");
            PhylogenyNode desc = remove_me.getDescendants().get(0);
            desc.setDistanceToParent(PhylogenyMethods.addPhylogenyDistances(remove_me.getDistanceToParent(), desc.getDistanceToParent()));
            desc.setParent(null);
            phylogeny.setRoot(desc);
            phylogeny.clearHashIdToNodeMap();
            return;
        } else if (remove_me.isExternal()) {
            phylogeny.deleteSubtree(remove_me, false);
            phylogeny.clearHashIdToNodeMap();
            phylogeny.externalNodesHaveChanged();
            return;
        } else {
            PhylogenyNode parent = remove_me.getParent();
            List<PhylogenyNode> descs = remove_me.getDescendants();
            parent.removeChildNode(remove_me);
            for (PhylogenyNode desc : descs) {
                parent.addAsChild(desc);
                desc.setDistanceToParent(PhylogenyMethods.addPhylogenyDistances(remove_me.getDistanceToParent(), desc.getDistanceToParent()));
            }
            remove_me.setParent(null);
            phylogeny.clearHashIdToNodeMap();
            phylogeny.externalNodesHaveChanged();
        }
    }

    public static List<PhylogenyNode> searchData(String query, Phylogeny phy, boolean case_sensitive, boolean partial, boolean regex, boolean search_domains, double domains_confidence_threshold) {
        ArrayList<PhylogenyNode> nodes = new ArrayList<PhylogenyNode>();
        if (phy.isEmpty() || query == null) {
            return nodes;
        }
        if (ForesterUtil.isEmpty(query)) {
            return nodes;
        }
        String my_query = query;
        NDF ndf = null;
        if (my_query.length() > 2 && my_query.indexOf(":") == 2 && (ndf = NDF.fromString(my_query)) != null) {
            my_query = my_query.substring(3);
        }
        PhylogenyNodeIterator iter = phy.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            boolean match = false;
            if ((ndf == null || ndf == NDF.NodeName) && PhylogenyMethods.match(node.getName(), my_query, case_sensitive, partial, regex)) {
                match = true;
            } else if ((ndf == null || ndf == NDF.TaxonomyCode) && node.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(node.getNodeData().getTaxonomy().getTaxonomyCode(), my_query, case_sensitive, partial, regex)) {
                match = true;
            } else if ((ndf == null || ndf == NDF.TaxonomyCommonName) && node.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(node.getNodeData().getTaxonomy().getCommonName(), my_query, case_sensitive, partial, regex)) {
                match = true;
            } else if ((ndf == null || ndf == NDF.TaxonomyScientificName) && node.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(node.getNodeData().getTaxonomy().getScientificName(), my_query, case_sensitive, partial, regex)) {
                match = true;
            } else if ((ndf == null || ndf == NDF.TaxonomyIdentifier) && node.getNodeData().isHasTaxonomy() && node.getNodeData().getTaxonomy().getIdentifier() != null && PhylogenyMethods.match(node.getNodeData().getTaxonomy().getIdentifier().getValue(), my_query, case_sensitive, partial, regex)) {
                match = true;
            } else if ((ndf == null || ndf == NDF.TaxonomySynonym) && node.getNodeData().isHasTaxonomy() && !node.getNodeData().getTaxonomy().getSynonyms().isEmpty()) {
                List<String> syns = node.getNodeData().getTaxonomy().getSynonyms();
                for (String syn : syns) {
                    if (!PhylogenyMethods.match(syn, my_query, case_sensitive, partial, regex)) continue;
                    match = true;
                    break;
                }
            }
            if (!match && (ndf == null || ndf == NDF.SequenceName) && node.getNodeData().isHasSequence() && PhylogenyMethods.match(node.getNodeData().getSequence().getName(), my_query, case_sensitive, partial, regex)) {
                match = true;
            }
            if (!match && (ndf == null || ndf == NDF.GeneName) && node.getNodeData().isHasSequence() && PhylogenyMethods.match(node.getNodeData().getSequence().getGeneName(), my_query, case_sensitive, partial, regex)) {
                match = true;
            }
            if (!match && (ndf == null || ndf == NDF.SequenceSymbol) && node.getNodeData().isHasSequence() && PhylogenyMethods.match(node.getNodeData().getSequence().getSymbol(), my_query, case_sensitive, partial, regex)) {
                match = true;
            }
            if (!match && (ndf == null || ndf == NDF.SequenceAccession) && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getAccession() != null && PhylogenyMethods.match(node.getNodeData().getSequence().getAccession().getValue(), my_query, case_sensitive, partial, regex)) {
                match = true;
            }
            if (!match && (ndf == null && search_domains || ndf == NDF.Domain) && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getDomainArchitecture() != null) {
                Iterator da = node.getNodeData().getSequence().getDomainArchitecture();
                for (int i = 0; i < ((DomainArchitecture)((Object)da)).getNumberOfDomains(); ++i) {
                    if (!(((DomainArchitecture)((Object)da)).getDomain(i).getConfidence() <= domains_confidence_threshold) || !PhylogenyMethods.match(((DomainArchitecture)((Object)da)).getDomain(i).getName(), my_query, case_sensitive, partial, regex)) continue;
                    match = true;
                    break;
                }
            }
            if (!match && (ndf == null || ndf == NDF.Annotation) && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getAnnotations() != null) {
                for (Annotation ann : node.getNodeData().getSequence().getAnnotations()) {
                    if (PhylogenyMethods.match(ann.getDesc(), my_query, case_sensitive, partial, regex)) {
                        match = true;
                        break;
                    }
                    if (!PhylogenyMethods.match(ann.getRef(), my_query, case_sensitive, partial, regex)) continue;
                    match = true;
                    break;
                }
            }
            if (!match && (ndf == null || ndf == NDF.CrossRef) && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getCrossReferences() != null) {
                for (Accession x : node.getNodeData().getSequence().getCrossReferences()) {
                    if (PhylogenyMethods.match(x.getComment(), my_query, case_sensitive, partial, regex)) {
                        match = true;
                        break;
                    }
                    if (PhylogenyMethods.match(x.getSource(), my_query, case_sensitive, partial, regex)) {
                        match = true;
                        break;
                    }
                    if (!PhylogenyMethods.match(x.getValue(), my_query, case_sensitive, partial, regex)) continue;
                    match = true;
                    break;
                }
            }
            if (!(match || ndf != null && ndf != NDF.BinaryCharacter || node.getNodeData().getBinaryCharacters() == null)) {
                Iterator it = node.getNodeData().getBinaryCharacters().getPresentCharacters().iterator();
                while (it.hasNext()) {
                    if (!PhylogenyMethods.match((String)it.next(), my_query, case_sensitive, partial, regex)) continue;
                    match = true;
                    break;
                }
                it = node.getNodeData().getBinaryCharacters().getGainedCharacters().iterator();
                while (it.hasNext()) {
                    if (!PhylogenyMethods.match((String)it.next(), my_query, case_sensitive, partial, regex)) continue;
                    match = true;
                    break;
                }
            }
            if (!match && ndf == NDF.MolecularSequence && node.getNodeData().isHasSequence() && PhylogenyMethods.match(node.getNodeData().getSequence().getMolecularSequence(), my_query, case_sensitive, true, regex)) {
                match = true;
            }
            if (!match) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static List<PhylogenyNode> searchDataLogicalAnd(String[] queries, Phylogeny phy, boolean case_sensitive, boolean partial, boolean search_domains, double domains_confidence_threshold) {
        ArrayList<PhylogenyNode> nodes = new ArrayList<PhylogenyNode>();
        if (phy.isEmpty() || queries == null || queries.length < 1) {
            return nodes;
        }
        PhylogenyNodeIterator iter = phy.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            boolean all_matched = true;
            for (String query : queries) {
                if (query == null) continue;
                query = query.trim();
                NDF ndf = null;
                if (query.length() > 2 && query.indexOf(":") == 2 && (ndf = NDF.fromString(query)) != null) {
                    query = query.substring(3);
                }
                boolean match = false;
                if (ForesterUtil.isEmpty(query)) continue;
                if ((ndf == null || ndf == NDF.NodeName) && PhylogenyMethods.match(node.getName(), query, case_sensitive, partial, false)) {
                    match = true;
                } else if ((ndf == null || ndf == NDF.TaxonomyCode) && node.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(node.getNodeData().getTaxonomy().getTaxonomyCode(), query, case_sensitive, partial, false)) {
                    match = true;
                } else if ((ndf == null || ndf == NDF.TaxonomyCommonName) && node.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(node.getNodeData().getTaxonomy().getCommonName(), query, case_sensitive, partial, false)) {
                    match = true;
                } else if ((ndf == null || ndf == NDF.TaxonomyScientificName) && node.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(node.getNodeData().getTaxonomy().getScientificName(), query, case_sensitive, partial, false)) {
                    match = true;
                } else if ((ndf == null || ndf == NDF.TaxonomyIdentifier) && node.getNodeData().isHasTaxonomy() && node.getNodeData().getTaxonomy().getIdentifier() != null && PhylogenyMethods.match(node.getNodeData().getTaxonomy().getIdentifier().getValue(), query, case_sensitive, partial, false)) {
                    match = true;
                } else if ((ndf == null || ndf == NDF.TaxonomySynonym) && node.getNodeData().isHasTaxonomy() && !node.getNodeData().getTaxonomy().getSynonyms().isEmpty()) {
                    List<String> syns = node.getNodeData().getTaxonomy().getSynonyms();
                    for (String syn : syns) {
                        if (!PhylogenyMethods.match(syn, query, case_sensitive, partial, false)) continue;
                        match = true;
                        break;
                    }
                }
                if (!match && (ndf == null || ndf == NDF.SequenceName) && node.getNodeData().isHasSequence() && PhylogenyMethods.match(node.getNodeData().getSequence().getName(), query, case_sensitive, partial, false)) {
                    match = true;
                }
                if (!match && (ndf == null || ndf == NDF.GeneName) && node.getNodeData().isHasSequence() && PhylogenyMethods.match(node.getNodeData().getSequence().getGeneName(), query, case_sensitive, partial, false)) {
                    match = true;
                }
                if (!match && (ndf == null || ndf == NDF.SequenceSymbol) && node.getNodeData().isHasSequence() && PhylogenyMethods.match(node.getNodeData().getSequence().getSymbol(), query, case_sensitive, partial, false)) {
                    match = true;
                }
                if (!match && (ndf == null || ndf == NDF.SequenceAccession) && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getAccession() != null && PhylogenyMethods.match(node.getNodeData().getSequence().getAccession().getValue(), query, case_sensitive, partial, false)) {
                    match = true;
                }
                if (!match && (ndf == null && search_domains || ndf == NDF.Domain) && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getDomainArchitecture() != null) {
                    Iterator da = node.getNodeData().getSequence().getDomainArchitecture();
                    for (int i = 0; i < ((DomainArchitecture)((Object)da)).getNumberOfDomains(); ++i) {
                        if (!(((DomainArchitecture)((Object)da)).getDomain(i).getConfidence() <= domains_confidence_threshold) || !PhylogenyMethods.match(((DomainArchitecture)((Object)da)).getDomain(i).getName(), query, case_sensitive, partial, false)) continue;
                        match = true;
                        break;
                    }
                }
                if (!match && (ndf == null || ndf == NDF.Annotation) && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getAnnotations() != null) {
                    for (Annotation ann : node.getNodeData().getSequence().getAnnotations()) {
                        if (PhylogenyMethods.match(ann.getDesc(), query, case_sensitive, partial, false)) {
                            match = true;
                            break;
                        }
                        if (!PhylogenyMethods.match(ann.getRef(), query, case_sensitive, partial, false)) continue;
                        match = true;
                        break;
                    }
                }
                if (!match && (ndf == null || ndf == NDF.CrossRef) && node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getCrossReferences() != null) {
                    for (Accession x : node.getNodeData().getSequence().getCrossReferences()) {
                        if (PhylogenyMethods.match(x.getComment(), query, case_sensitive, partial, false)) {
                            match = true;
                            break;
                        }
                        if (PhylogenyMethods.match(x.getSource(), query, case_sensitive, partial, false)) {
                            match = true;
                            break;
                        }
                        if (!PhylogenyMethods.match(x.getValue(), query, case_sensitive, partial, false)) continue;
                        match = true;
                        break;
                    }
                }
                if (!(match || ndf != null && ndf != NDF.BinaryCharacter || node.getNodeData().getBinaryCharacters() == null)) {
                    Iterator it = node.getNodeData().getBinaryCharacters().getPresentCharacters().iterator();
                    while (it.hasNext()) {
                        if (!PhylogenyMethods.match((String)it.next(), query, case_sensitive, partial, false)) continue;
                        match = true;
                        break;
                    }
                    it = node.getNodeData().getBinaryCharacters().getGainedCharacters().iterator();
                    while (it.hasNext()) {
                        if (!PhylogenyMethods.match((String)it.next(), query, case_sensitive, partial, false)) continue;
                        match = true;
                        break;
                    }
                }
                if (!match && ndf == NDF.MolecularSequence && node.getNodeData().isHasSequence() && PhylogenyMethods.match(node.getNodeData().getSequence().getMolecularSequence(), query, case_sensitive, true, false)) {
                    match = true;
                }
                if (match) continue;
                all_matched = false;
                break;
            }
            if (!all_matched) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static void setAllIndicatorsToZero(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            it.next().setIndicator((byte)0);
        }
    }

    public static void setBootstrapConfidence(PhylogenyNode node, double bootstrap_confidence_value) {
        PhylogenyMethods.setConfidence(node, bootstrap_confidence_value, "bootstrap");
    }

    public static void setBranchColorValue(PhylogenyNode node, Color color) {
        if (node.getBranchData().getBranchColor() == null) {
            node.getBranchData().setBranchColor(new BranchColor());
        }
        node.getBranchData().getBranchColor().setValue(color);
    }

    public static void setBranchWidthValue(PhylogenyNode node, double branch_width_value) {
        node.getBranchData().setBranchWidth(new BranchWidth(branch_width_value));
    }

    public static void setConfidence(PhylogenyNode node, double confidence_value) {
        PhylogenyMethods.setConfidence(node, confidence_value, "");
    }

    public static void setConfidence(PhylogenyNode node, double confidence_value, String type) {
        Confidence c = null;
        if (node.getBranchData().getNumberOfConfidences() > 0) {
            c = node.getBranchData().getConfidence(0);
        } else {
            c = new Confidence();
            node.getBranchData().addConfidence(c);
        }
        c.setType(type);
        c.setValue(confidence_value);
    }

    public static void setScientificName(PhylogenyNode node, String scientific_name) {
        if (!node.getNodeData().isHasTaxonomy()) {
            node.getNodeData().setTaxonomy(new Taxonomy());
        }
        node.getNodeData().getTaxonomy().setScientificName(scientific_name);
    }

    public static void setTaxonomyCode(PhylogenyNode node, String taxonomy_code) throws PhyloXmlDataFormatException {
        if (!node.getNodeData().isHasTaxonomy()) {
            node.getNodeData().setTaxonomy(new Taxonomy());
        }
        node.getNodeData().getTaxonomy().setTaxonomyCode(taxonomy_code);
    }

    public static final void sortNodeDescendents(PhylogenyNode node, DESCENDANT_SORT_PRIORITY pri) {
        Comparator<PhylogenyNode> c;
        switch (pri) {
            case SEQUENCE: {
                c = new PhylogenyNodeSortSequencePriority();
                break;
            }
            case NODE_NAME: {
                c = new PhylogenyNodeSortNodeNamePriority();
                break;
            }
            default: {
                c = new PhylogenyNodeSortTaxonomyPriority();
            }
        }
        List<PhylogenyNode> descs = node.getDescendants();
        Collections.sort(descs, c);
        int i = 0;
        for (PhylogenyNode desc : descs) {
            node.setChildNode(i++, desc);
        }
    }

    public static List<PhylogenyNode> taxonomyBasedDeletionOfExternalNodes(Phylogeny reference, Phylogeny to_be_stripped) {
        HashSet<String> ref_ext_taxo = new HashSet<String>();
        PhylogenyNodeIterator it = reference.iteratorExternalForward();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (!n.getNodeData().isHasTaxonomy()) {
                throw new IllegalArgumentException("no taxonomic data in node: " + n);
            }
            if (!ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getScientificName())) {
                ref_ext_taxo.add(n.getNodeData().getTaxonomy().getScientificName());
            }
            if (!ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getTaxonomyCode())) {
                ref_ext_taxo.add(n.getNodeData().getTaxonomy().getTaxonomyCode());
            }
            if (n.getNodeData().getTaxonomy().getIdentifier() == null || ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getIdentifier().getValue())) continue;
            ref_ext_taxo.add(n.getNodeData().getTaxonomy().getIdentifier().getValuePlusProvider());
        }
        ArrayList<PhylogenyNode> nodes_to_delete = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator it2 = to_be_stripped.iteratorExternalForward();
        while (it2.hasNext()) {
            PhylogenyNode n = it2.next();
            if (!n.getNodeData().isHasTaxonomy()) {
                nodes_to_delete.add(n);
                continue;
            }
            if (ref_ext_taxo.contains(n.getNodeData().getTaxonomy().getScientificName()) || ref_ext_taxo.contains(n.getNodeData().getTaxonomy().getTaxonomyCode()) || n.getNodeData().getTaxonomy().getIdentifier() != null && ref_ext_taxo.contains(n.getNodeData().getTaxonomy().getIdentifier().getValuePlusProvider())) continue;
            nodes_to_delete.add(n);
        }
        for (PhylogenyNode n : nodes_to_delete) {
            to_be_stripped.deleteSubtree(n, true);
        }
        to_be_stripped.clearHashIdToNodeMap();
        to_be_stripped.externalNodesHaveChanged();
        return nodes_to_delete;
    }

    public static final void transferInternalNamesToBootstrapSupport(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (n.isExternal() || ForesterUtil.isEmpty(n.getName())) continue;
            double value = -1.0;
            try {
                value = Double.parseDouble(n.getName());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("failed to parse number from [" + n.getName() + "]: " + e.getLocalizedMessage());
            }
            if (!(value >= 0.0)) continue;
            n.getBranchData().addConfidence(new Confidence(value, "bootstrap"));
            n.setName("");
        }
    }

    public static final boolean isInternalNamesLookLikeConfidences(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (n.isExternal() || n.isRoot() || ForesterUtil.isEmpty(n.getName())) continue;
            double value = -1.0;
            try {
                value = Double.parseDouble(n.getName());
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (!(value < 0.0) && !(value > 100.0)) continue;
            return false;
        }
        return true;
    }

    public static final void transferInternalNodeNamesToConfidence(Phylogeny phy, String confidence_type) {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyMethods.transferInternalNodeNameToConfidence(confidence_type, it.next());
        }
    }

    private static void transferInternalNodeNameToConfidence(String confidence_type, PhylogenyNode n) {
        if (!(n.isExternal() || n.getBranchData().isHasConfidences() || ForesterUtil.isEmpty(n.getName()))) {
            double d = -1.0;
            try {
                d = Double.parseDouble(n.getName());
            }
            catch (Exception e) {
                d = -1.0;
            }
            if (d >= 0.0) {
                n.getBranchData().addConfidence(new Confidence(d, confidence_type));
                n.setName("");
            }
        }
    }

    public static final void transferNodeNameToField(Phylogeny phy, PhylogenyNodeField field, boolean external_only) throws PhyloXmlDataFormatException {
        PhylogenyNodeIterator it = phy.iteratorPostorder();
        while (it.hasNext()) {
            String name;
            PhylogenyNode n = it.next();
            if (external_only && n.isInternal() || ForesterUtil.isEmpty(name = n.getName().trim())) continue;
            switch (field) {
                case TAXONOMY_CODE: {
                    n.setName("");
                    PhylogenyMethods.setTaxonomyCode(n, name);
                    break;
                }
                case TAXONOMY_SCIENTIFIC_NAME: {
                    n.setName("");
                    if (!n.getNodeData().isHasTaxonomy()) {
                        n.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    n.getNodeData().getTaxonomy().setScientificName(name);
                    break;
                }
                case TAXONOMY_COMMON_NAME: {
                    n.setName("");
                    if (!n.getNodeData().isHasTaxonomy()) {
                        n.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    n.getNodeData().getTaxonomy().setCommonName(name);
                    break;
                }
                case SEQUENCE_SYMBOL: {
                    n.setName("");
                    if (!n.getNodeData().isHasSequence()) {
                        n.getNodeData().setSequence(new Sequence());
                    }
                    n.getNodeData().getSequence().setSymbol(name);
                    break;
                }
                case SEQUENCE_NAME: {
                    n.setName("");
                    if (!n.getNodeData().isHasSequence()) {
                        n.getNodeData().setSequence(new Sequence());
                    }
                    n.getNodeData().getSequence().setName(name);
                    break;
                }
                case TAXONOMY_ID_UNIPROT_1: {
                    if (!n.getNodeData().isHasTaxonomy()) {
                        n.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    String id = name;
                    int i = name.indexOf(95);
                    if (i > 0) {
                        id = name.substring(0, i);
                    } else {
                        n.setName("");
                    }
                    n.getNodeData().getTaxonomy().setIdentifier(new Identifier(id, "uniprot"));
                    break;
                }
                case TAXONOMY_ID_UNIPROT_2: {
                    if (!n.getNodeData().isHasTaxonomy()) {
                        n.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    String id = name;
                    int i = name.indexOf(95);
                    if (i > 0) {
                        id = name.substring(i + 1, name.length());
                    } else {
                        n.setName("");
                    }
                    n.getNodeData().getTaxonomy().setIdentifier(new Identifier(id, "uniprot"));
                    break;
                }
                case TAXONOMY_ID: {
                    if (!n.getNodeData().isHasTaxonomy()) {
                        n.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    n.getNodeData().getTaxonomy().setIdentifier(new Identifier(name));
                }
            }
        }
    }

    static double addPhylogenyDistances(double a, double b) {
        if (a >= 0.0 && b >= 0.0) {
            return a + b;
        }
        if (a >= 0.0) {
            return a;
        }
        if (b >= 0.0) {
            return b;
        }
        return -1024.0;
    }

    static double calculateDistanceToAncestor(PhylogenyNode anc, PhylogenyNode desc) {
        double d = 0.0;
        boolean all_default = true;
        while (anc != desc) {
            if (desc.getDistanceToParent() != -1024.0) {
                d += desc.getDistanceToParent();
                if (all_default) {
                    all_default = false;
                }
            }
            desc = desc.getParent();
        }
        if (all_default) {
            return -1024.0;
        }
        return d;
    }

    static PhylogenyNode copySubTree(PhylogenyNode source) {
        if (source == null) {
            return null;
        }
        PhylogenyNode newnode = source.copyNodeData();
        if (!source.isExternal()) {
            for (int i = 0; i < source.getNumberOfDescendants(); ++i) {
                newnode.setChildNode(i, PhylogenyMethods.copySubTree(source.getChildNode(i)));
            }
        }
        return newnode;
    }

    static PhylogenyNode copySubTreeShallow(PhylogenyNode source) {
        if (source == null) {
            return null;
        }
        PhylogenyNode newnode = source.copyNodeDataShallow();
        if (!source.isExternal()) {
            for (int i = 0; i < source.getNumberOfDescendants(); ++i) {
                newnode.setChildNode(i, PhylogenyMethods.copySubTreeShallow(source.getChildNode(i)));
            }
        }
        return newnode;
    }

    private static final List<PhylogenyNode> divideIntoSubTreesHelper(PhylogenyNode node, double min_distance_to_root) {
        ArrayList<PhylogenyNode> l = new ArrayList<PhylogenyNode>();
        PhylogenyNode r = PhylogenyMethods.moveTowardsRoot(node, min_distance_to_root);
        for (PhylogenyNode ext : r.getAllExternalDescendants()) {
            if (ext.getIndicator() != 0) {
                throw new RuntimeException("this should not have happened");
            }
            ext.setIndicator((byte)1);
            l.add(ext);
        }
        return l;
    }

    private static double getDistance(PhylogenyNode n1, PhylogenyNode n2) {
        double d = 0.0;
        while (n1 != n2) {
            if (n1.getDistanceToParent() > 0.0) {
                d += n1.getDistanceToParent();
            }
            n1 = n1.getParent();
        }
        return d;
    }

    private static boolean match(String s, String query, boolean case_sensitive, boolean partial, boolean regex) {
        if (ForesterUtil.isEmpty(s) || ForesterUtil.isEmpty(query)) {
            return false;
        }
        String my_s = s.trim();
        String my_query = query.trim();
        if (!case_sensitive && !regex) {
            my_s = my_s.toLowerCase();
            my_query = my_query.toLowerCase();
        }
        if (regex) {
            Pattern p = null;
            try {
                p = case_sensitive ? Pattern.compile(my_query) : Pattern.compile(my_query, 2);
            }
            catch (PatternSyntaxException e) {
                return false;
            }
            if (p != null) {
                return p.matcher(my_s).find();
            }
            return false;
        }
        if (partial) {
            return my_s.indexOf(my_query) >= 0;
        }
        Pattern p = null;
        try {
            p = Pattern.compile("(\\b|_)" + Pattern.quote(my_query) + "(\\b|_)");
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        if (p != null) {
            return p.matcher(my_s).find();
        }
        return false;
    }

    private static final PhylogenyNode moveTowardsRoot(PhylogenyNode node, double min_distance_to_root) {
        PhylogenyNode n = node;
        PhylogenyNode prev = node;
        while (min_distance_to_root < n.calculateDistanceToRoot()) {
            prev = n;
            n = n.getParent();
        }
        return prev;
    }

    public static void addMolecularSeqsToTree(Phylogeny phy, Msa msa) {
        for (int s = 0; s < msa.getNumberOfSequences(); ++s) {
            MolecularSequence seq = msa.getSequence(s);
            PhylogenyNode node = phy.getNode(seq.getIdentifier());
            Sequence new_seq = new Sequence();
            new_seq.setMolecularSequenceAligned(true);
            new_seq.setMolecularSequence(seq.getMolecularSequenceAsString());
            new_seq.setName(seq.getIdentifier());
            try {
                new_seq.setType("protein");
            }
            catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                // empty catch block
            }
            node.getNodeData().addSequence(new_seq);
        }
    }

    private static final class PhylogenyNodeSortNodeNamePriority
    implements Comparator<PhylogenyNode> {
        private PhylogenyNodeSortNodeNamePriority() {
        }

        @Override
        public int compare(PhylogenyNode n1, PhylogenyNode n2) {
            if (!ForesterUtil.isEmpty(n1.getName()) && !ForesterUtil.isEmpty(n2.getName())) {
                return n1.getName().toLowerCase().compareTo(n2.getName().toLowerCase());
            }
            if (n1.getNodeData().isHasTaxonomy() && n2.getNodeData().isHasTaxonomy()) {
                if (!ForesterUtil.isEmpty(n1.getNodeData().getTaxonomy().getScientificName()) && !ForesterUtil.isEmpty(n2.getNodeData().getTaxonomy().getScientificName())) {
                    return n1.getNodeData().getTaxonomy().getScientificName().toLowerCase().compareTo(n2.getNodeData().getTaxonomy().getScientificName().toLowerCase());
                }
                if (!ForesterUtil.isEmpty(n1.getNodeData().getTaxonomy().getTaxonomyCode()) && !ForesterUtil.isEmpty(n2.getNodeData().getTaxonomy().getTaxonomyCode())) {
                    return n1.getNodeData().getTaxonomy().getTaxonomyCode().compareTo(n2.getNodeData().getTaxonomy().getTaxonomyCode());
                }
            }
            if (n1.getNodeData().isHasSequence() && n2.getNodeData().isHasSequence()) {
                if (!ForesterUtil.isEmpty(n1.getNodeData().getSequence().getName()) && !ForesterUtil.isEmpty(n2.getNodeData().getSequence().getName())) {
                    return n1.getNodeData().getSequence().getName().toLowerCase().compareTo(n2.getNodeData().getSequence().getName().toLowerCase());
                }
                if (!ForesterUtil.isEmpty(n1.getNodeData().getSequence().getGeneName()) && !ForesterUtil.isEmpty(n2.getNodeData().getSequence().getGeneName())) {
                    return n1.getNodeData().getSequence().getGeneName().compareTo(n2.getNodeData().getSequence().getGeneName());
                }
                if (!ForesterUtil.isEmpty(n1.getNodeData().getSequence().getSymbol()) && !ForesterUtil.isEmpty(n2.getNodeData().getSequence().getSymbol())) {
                    return n1.getNodeData().getSequence().getSymbol().compareTo(n2.getNodeData().getSequence().getSymbol());
                }
            }
            return 0;
        }
    }

    private static final class PhylogenyNodeSortSequencePriority
    implements Comparator<PhylogenyNode> {
        private PhylogenyNodeSortSequencePriority() {
        }

        @Override
        public int compare(PhylogenyNode n1, PhylogenyNode n2) {
            if (n1.getNodeData().isHasSequence() && n2.getNodeData().isHasSequence()) {
                if (!ForesterUtil.isEmpty(n1.getNodeData().getSequence().getName()) && !ForesterUtil.isEmpty(n2.getNodeData().getSequence().getName())) {
                    return n1.getNodeData().getSequence().getName().toLowerCase().compareTo(n2.getNodeData().getSequence().getName().toLowerCase());
                }
                if (!ForesterUtil.isEmpty(n1.getNodeData().getSequence().getGeneName()) && !ForesterUtil.isEmpty(n2.getNodeData().getSequence().getGeneName())) {
                    return n1.getNodeData().getSequence().getGeneName().compareTo(n2.getNodeData().getSequence().getGeneName());
                }
                if (!ForesterUtil.isEmpty(n1.getNodeData().getSequence().getSymbol()) && !ForesterUtil.isEmpty(n2.getNodeData().getSequence().getSymbol())) {
                    return n1.getNodeData().getSequence().getSymbol().compareTo(n2.getNodeData().getSequence().getSymbol());
                }
            }
            if (n1.getNodeData().isHasTaxonomy() && n2.getNodeData().isHasTaxonomy()) {
                if (!ForesterUtil.isEmpty(n1.getNodeData().getTaxonomy().getScientificName()) && !ForesterUtil.isEmpty(n2.getNodeData().getTaxonomy().getScientificName())) {
                    return n1.getNodeData().getTaxonomy().getScientificName().toLowerCase().compareTo(n2.getNodeData().getTaxonomy().getScientificName().toLowerCase());
                }
                if (!ForesterUtil.isEmpty(n1.getNodeData().getTaxonomy().getTaxonomyCode()) && !ForesterUtil.isEmpty(n2.getNodeData().getTaxonomy().getTaxonomyCode())) {
                    return n1.getNodeData().getTaxonomy().getTaxonomyCode().compareTo(n2.getNodeData().getTaxonomy().getTaxonomyCode());
                }
            }
            if (!ForesterUtil.isEmpty(n1.getName()) && !ForesterUtil.isEmpty(n2.getName())) {
                return n1.getName().toLowerCase().compareTo(n2.getName().toLowerCase());
            }
            return 0;
        }
    }

    private static final class PhylogenyNodeSortTaxonomyPriority
    implements Comparator<PhylogenyNode> {
        private PhylogenyNodeSortTaxonomyPriority() {
        }

        @Override
        public int compare(PhylogenyNode n1, PhylogenyNode n2) {
            if (n1.getNodeData().isHasTaxonomy() && n2.getNodeData().isHasTaxonomy()) {
                if (!ForesterUtil.isEmpty(n1.getNodeData().getTaxonomy().getScientificName()) && !ForesterUtil.isEmpty(n2.getNodeData().getTaxonomy().getScientificName())) {
                    return n1.getNodeData().getTaxonomy().getScientificName().toLowerCase().compareTo(n2.getNodeData().getTaxonomy().getScientificName().toLowerCase());
                }
                if (!ForesterUtil.isEmpty(n1.getNodeData().getTaxonomy().getTaxonomyCode()) && !ForesterUtil.isEmpty(n2.getNodeData().getTaxonomy().getTaxonomyCode())) {
                    return n1.getNodeData().getTaxonomy().getTaxonomyCode().compareTo(n2.getNodeData().getTaxonomy().getTaxonomyCode());
                }
            }
            if (n1.getNodeData().isHasSequence() && n2.getNodeData().isHasSequence()) {
                if (!ForesterUtil.isEmpty(n1.getNodeData().getSequence().getName()) && !ForesterUtil.isEmpty(n2.getNodeData().getSequence().getName())) {
                    return n1.getNodeData().getSequence().getName().toLowerCase().compareTo(n2.getNodeData().getSequence().getName().toLowerCase());
                }
                if (!ForesterUtil.isEmpty(n1.getNodeData().getSequence().getGeneName()) && !ForesterUtil.isEmpty(n2.getNodeData().getSequence().getGeneName())) {
                    return n1.getNodeData().getSequence().getGeneName().compareTo(n2.getNodeData().getSequence().getGeneName());
                }
                if (!ForesterUtil.isEmpty(n1.getNodeData().getSequence().getSymbol()) && !ForesterUtil.isEmpty(n2.getNodeData().getSequence().getSymbol())) {
                    return n1.getNodeData().getSequence().getSymbol().compareTo(n2.getNodeData().getSequence().getSymbol());
                }
            }
            if (!ForesterUtil.isEmpty(n1.getName()) && !ForesterUtil.isEmpty(n2.getName())) {
                return n1.getName().toLowerCase().compareTo(n2.getName().toLowerCase());
            }
            return 0;
        }
    }

    public static enum PhylogenyNodeField {
        CLADE_NAME,
        SEQUENCE_NAME,
        SEQUENCE_SYMBOL,
        TAXONOMY_CODE,
        TAXONOMY_COMMON_NAME,
        TAXONOMY_ID,
        TAXONOMY_ID_UNIPROT_1,
        TAXONOMY_ID_UNIPROT_2,
        TAXONOMY_SCIENTIFIC_NAME;

    }

    public static enum DESCENDANT_SORT_PRIORITY {
        NODE_NAME,
        SEQUENCE,
        TAXONOMY;

    }

    private static enum NDF {
        NodeName("NN"),
        TaxonomyCode("TC"),
        TaxonomyCommonName("CN"),
        TaxonomyScientificName("TS"),
        TaxonomyIdentifier("TI"),
        TaxonomySynonym("SY"),
        SequenceName("SN"),
        GeneName("GN"),
        SequenceSymbol("SS"),
        SequenceAccession("SA"),
        Domain("DO"),
        Annotation("AN"),
        CrossRef("XR"),
        BinaryCharacter("BC"),
        MolecularSequence("MS");

        private final String _text;

        private NDF(String text) {
            this._text = text;
        }

        public static NDF fromString(String text) {
            for (NDF n : NDF.values()) {
                if (!text.startsWith(n._text)) continue;
                return n;
            }
            return null;
        }
    }
}

