/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.util.ForesterUtil;

public class GeneralTable<IDENTIFIER_TYPE, VALUE_TYPE> {
    private Map<IDENTIFIER_TYPE, Map<IDENTIFIER_TYPE, VALUE_TYPE>> _rows;
    private SortedSet<IDENTIFIER_TYPE> _row_identifiers;
    private SortedSet<IDENTIFIER_TYPE> _column_identifiers;

    public GeneralTable() {
        this.init();
    }

    public SortedSet<IDENTIFIER_TYPE> getColumnIdentifiers() {
        return this._column_identifiers;
    }

    private Map<IDENTIFIER_TYPE, VALUE_TYPE> getRow(IDENTIFIER_TYPE row) {
        return this.getRows().get(row);
    }

    public SortedSet<IDENTIFIER_TYPE> getRowIdentifiers() {
        return this._row_identifiers;
    }

    private Map<IDENTIFIER_TYPE, Map<IDENTIFIER_TYPE, VALUE_TYPE>> getRows() {
        return this._rows;
    }

    public VALUE_TYPE getValue(IDENTIFIER_TYPE col, IDENTIFIER_TYPE row) throws IllegalArgumentException {
        Map<IDENTIFIER_TYPE, VALUE_TYPE> row_map = this.getRow(row);
        if (row_map == null || row_map.size() < 1) {
            return null;
        }
        return row_map.get(col);
    }

    public String getValueAsString(IDENTIFIER_TYPE col, IDENTIFIER_TYPE row) throws IllegalArgumentException {
        VALUE_TYPE value = this.getValue(col, row);
        return value == null ? "" : this.getValue(col, row).toString();
    }

    private void init() {
        this._rows = new HashMap<IDENTIFIER_TYPE, Map<IDENTIFIER_TYPE, VALUE_TYPE>>();
        this._row_identifiers = new TreeSet<IDENTIFIER_TYPE>();
        this._column_identifiers = new TreeSet<IDENTIFIER_TYPE>();
    }

    public void setValue(IDENTIFIER_TYPE col, IDENTIFIER_TYPE row, VALUE_TYPE value) {
        this.getColumnIdentifiers().add(col);
        this.getRowIdentifiers().add(row);
        Map<Object, Object> row_map = null;
        if (this.getRows().containsKey(row)) {
            row_map = this.getRows().get(row);
        } else {
            row_map = new HashMap();
            this.getRows().put(row, row_map);
        }
        row_map.put(col, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t");
        for (Object col : this.getColumnIdentifiers()) {
            sb.append(col.toString());
            sb.append("\t");
        }
        sb.append(ForesterUtil.LINE_SEPARATOR);
        for (Object row : this.getRowIdentifiers()) {
            sb.append(row.toString());
            sb.append("\t");
            for (Object col : this.getColumnIdentifiers()) {
                sb.append(this.getValueAsString(col, row));
                sb.append("\t");
            }
            sb.append(ForesterUtil.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public String toString(NumberFormat number_format) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t");
        for (Object col : this.getColumnIdentifiers()) {
            sb.append(col.toString());
            sb.append("\t");
        }
        sb.append(ForesterUtil.LINE_SEPARATOR);
        for (Object row : this.getRowIdentifiers()) {
            sb.append(row.toString());
            sb.append("\t");
            for (Object col : this.getColumnIdentifiers()) {
                try {
                    sb.append(number_format.format(this.getValue(col, row)));
                }
                catch (IllegalArgumentException e) {
                    sb.append(this.getValueAsString(col, row));
                }
                sb.append("\t");
            }
            sb.append(ForesterUtil.LINE_SEPARATOR);
        }
        return sb.toString();
    }
}

