/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.main;

import fr.proline.studio.NbPreferences;
import fr.proline.studio.dpm.ServerConnectionManager;
import fr.proline.studio.rsmexplorer.MainFrame;
import fr.proline.studio.rsmexplorer.SplashScreenWindow;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");

    public static void main(String[] args) {
        String userPath = null;
        boolean nextIsuserDirPath = false;
        for (String arg : args) {
            if (arg.compareToIgnoreCase("--userdir") == 0) {
                nextIsuserDirPath = true;
                continue;
            }
            if (nextIsuserDirPath) {
                userPath = arg;
                break;
            }
            m_logger.warn("Application Parameter has not been recognized: " + arg);
        }
        if (userPath != null) {
            NbPreferences.initPreferences(userPath);
        }
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    final SplashScreenWindow splashScreen = new SplashScreenWindow();
                    splashScreen.setVisible(true);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainFrame frame = MainFrame.getInstance();
                            Main.initTheme();
                            ((Window)((Object)frame)).setVisible(true);
                            ((Frame)((Object)frame)).setExtendedState(((Frame)((Object)frame)).getExtendedState() | 6);
                            splashScreen.setVisible(false);
                        }
                    });
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initTheme() {
        Main.setUI();
        ServerConnectionManager.getServerConnectionManager();
    }

    private static void setUI() {
        final String OS = System.getProperty("os.name").toLowerCase();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (Main.isMacOS(OS) || Main.isUnixOS(OS)) {
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    } else if (OS.contains("win")) {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    MainFrame frame = MainFrame.getInstance();
                    SwingUtilities.updateComponentTreeUI((Component)((Object)frame));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                    m_logger.error("Setting look and feel failed", (Throwable)e);
                }
            }
        });
    }

    private static boolean isMacOS(String os) {
        return os.contains("mac");
    }

    private static boolean isUnixOS(String os) {
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") > 0;
    }
}

