/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseProteinsAndPeptidesTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.data.AdjacencyMatrixData;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.Component;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.DrawVisualization;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.MatrixSelectionPanel;

public class DataBoxAdjacencyMatrixChoice
extends AbstractDataBox {
    private ResultSummary m_rsm = null;
    private boolean m_keepSameSet = false;
    private boolean m_doNotTakeFirstSelection = false;

    public DataBoxAdjacencyMatrixChoice() {
        super(AbstractDataBox.DataboxType.DataBoxAdjacencyMatrixChoice, AbstractDataBox.DataboxStyle.STYLE_RSM);
        this.m_typeName = "Proteins Adjacency Matrices";
        this.m_description = "All Adjacency Matrices";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(ResultSummary.class);
        inParameter.addParameter(DProteinSet.class);
        inParameter.addParameter(DProteinMatch.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DrawVisualization.class);
        outParameter.addParameter(Component.class);
        this.registerOutParameter(outParameter);
    }

    public void setKeepSameset(boolean keepSameSet) {
        this.m_keepSameSet = keepSameSet;
    }

    public void doNotTakeFirstSelection(boolean doNotTakeFirstSelection) {
        this.m_doNotTakeFirstSelection = doNotTakeFirstSelection;
    }

    @Override
    public void createPanel() {
        MatrixSelectionPanel p = new MatrixSelectionPanel();
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        DProteinSet proteinSet;
        ResultSummary _rsm = this.m_rsm != null ? this.m_rsm : (ResultSummary)this.getData(ResultSummary.class);
        this.linkCache((TransientDataInterface)_rsm);
        DProteinMatch proteinMatch = (DProteinMatch)this.getData(DProteinMatch.class);
        if (proteinMatch == null && (proteinSet = (DProteinSet)this.getData(DProteinSet.class)) != null) {
            proteinMatch = proteinSet.getTypicalProteinMatch();
        }
        final DProteinMatch _proteinMatch = proteinMatch;
        final AdjacencyMatrixData matrixData = new AdjacencyMatrixData();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                try {
                    ((MatrixSelectionPanel)DataBoxAdjacencyMatrixChoice.this.getDataBoxPanelInterface()).setData(matrixData, _proteinMatch, DataBoxAdjacencyMatrixChoice.this.m_keepSameSet, DataBoxAdjacencyMatrixChoice.this.m_doNotTakeFirstSelection);
                    DataBoxAdjacencyMatrixChoice.this.m_doNotTakeFirstSelection = false;
                    if (finished) {
                        DataBoxAdjacencyMatrixChoice.this.unregisterTask(taskId);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        };
        ((MatrixSelectionPanel)this.getDataBoxPanelInterface()).setData(_proteinMatch, this.m_doNotTakeFirstSelection);
        this.registerTask((AbstractDatabaseTask)new DatabaseProteinsAndPeptidesTask(callback, this.getProjectId(), _rsm, matrixData));
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        if (data instanceof ResultSummary) {
            this.m_rsm = (ResultSummary)data;
            this.dataChanged();
        }
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(Component.class)) {
                return ((MatrixSelectionPanel)this.getDataBoxPanelInterface()).getCurrentComponent();
            }
            if (parameterType.equals(DrawVisualization.class)) {
                return ((MatrixSelectionPanel)this.getDataBoxPanelInterface()).getDrawVisualization();
            }
            if (parameterType.equals(ResultSummary.class) && this.m_rsm != null) {
                return this.m_rsm;
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }
}

