/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.rsmexplorer.gui.spectrum.PeptideFragmentationData;
import fr.proline.studio.rsmexplorer.gui.spectrum.RsetPeptideFragmentationTablePanel;

public class DataBoxRsetPeptideFragmentation
extends AbstractDataBox {
    private DPeptideMatch m_previousPeptideMatch = null;

    public DataBoxRsetPeptideFragmentation() {
        super(AbstractDataBox.DataboxType.DataBoxRsetPeptideFragmentation, AbstractDataBox.DataboxStyle.STYLE_RSET);
        this.m_typeName = "Fragmentation Table";
        this.m_description = "Fragmentation table of a Peptide";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DPeptideMatch.class);
        inParameter.addParameter(PeptideFragmentationData.class);
        this.registerInParameter(inParameter);
    }

    @Override
    public void createPanel() {
        RsetPeptideFragmentationTablePanel p = new RsetPeptideFragmentationTablePanel();
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        DPeptideMatch peptideMatch;
        PeptideFragmentationData fragmentationData = (PeptideFragmentationData)this.getData(PeptideFragmentationData.class);
        DPeptideMatch dPeptideMatch = peptideMatch = fragmentationData != null ? fragmentationData.getPeptideMatch() : null;
        if (this.m_previousPeptideMatch == peptideMatch && fragmentationData == null) {
            return;
        }
        this.m_previousPeptideMatch = peptideMatch;
        if (peptideMatch == null) {
            ((RsetPeptideFragmentationTablePanel)this.getDataBoxPanelInterface()).setData(null, null);
        } else {
            ((RsetPeptideFragmentationTablePanel)this.getDataBoxPanelInterface()).setData(peptideMatch, fragmentationData);
        }
    }
}

