/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseProteinMatchesTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.RsetProteinsPanel;

public class DataBoxRsetProteinsForPeptideMatch
extends AbstractDataBox {
    private long m_peptideMatchCurId = -1L;
    private Long m_previousTaskId = null;

    public DataBoxRsetProteinsForPeptideMatch() {
        super(AbstractDataBox.DataboxType.DataBoxRsetProteinsForPeptideMatch, AbstractDataBox.DataboxStyle.STYLE_RSET);
        this.m_typeName = "Proteins";
        this.m_description = "Proteins for a Peptide Match";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DPeptideMatch.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DProteinMatch.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        RsetProteinsPanel p = new RsetProteinsPanel(false);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        final DPeptideMatch peptideMatch = (DPeptideMatch)this.getData(DPeptideMatch.class);
        if (peptideMatch == null) {
            ((RsetProteinsPanel)this.getDataBoxPanelInterface()).setDataPeptideMatch(null);
            this.m_peptideMatchCurId = -1L;
            return;
        }
        if (this.m_peptideMatchCurId != -1L && peptideMatch.getId() == this.m_peptideMatchCurId) {
            return;
        }
        this.m_peptideMatchCurId = peptideMatch.getId();
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (subTask == null) {
                    ((RsetProteinsPanel)DataBoxRsetProteinsForPeptideMatch.this.getDataBoxPanelInterface()).setDataPeptideMatch(peptideMatch);
                } else {
                    ((RsetProteinsPanel)DataBoxRsetProteinsForPeptideMatch.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                DataBoxRsetProteinsForPeptideMatch.this.setLoaded(loadingId);
                if (finished) {
                    DataBoxRsetProteinsForPeptideMatch.this.unregisterTask(taskId);
                    DataBoxRsetProteinsForPeptideMatch.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataBoxRsetProteinsForPeptideMatch.this.propagateDataChanged();
                }
            }
        };
        DatabaseProteinMatchesTask task = new DatabaseProteinMatchesTask(callback, this.getProjectId(), peptideMatch);
        Long taskId = task.getId();
        if (this.m_previousTaskId != null) {
            AccessDatabaseThread.getAccessDatabaseThread().abortTask(this.m_previousTaskId);
        }
        this.m_previousTaskId = taskId;
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(DProteinMatch.class)) {
                return ((RsetProteinsPanel)this.getDataBoxPanelInterface()).getSelectedProteinMatch();
            }
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }
}

