/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.GenericPanel;
import java.util.ArrayList;

public class DataboxGeneric
extends AbstractDataBox {
    private GlobalTableModelInterface m_entryModel = null;
    private final boolean m_removeStripAndSort;

    public DataboxGeneric(String dataName, String typeName, boolean removeStripAndSort) {
        super(AbstractDataBox.DataboxType.DataboxCompareResult, AbstractDataBox.DataboxStyle.STYLE_UNKNOWN);
        this.m_dataName = dataName;
        this.m_typeName = typeName;
        this.m_description = typeName;
        this.m_removeStripAndSort = removeStripAndSort;
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(ExtendedTableModelInterface.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(ExtendedTableModelInterface.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        GenericPanel p = new GenericPanel(this.m_removeStripAndSort);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void setEntryData(Object data) {
        if (data instanceof GlobalTableModelInterface) {
            this.m_entryModel = (GlobalTableModelInterface)data;
            ArrayList extraDataTypeList = this.m_entryModel.getExtraDataTypes();
            if (extraDataTypeList != null) {
                ParameterList outParameter = new ParameterList();
                for (ExtraDataType extraDataType : extraDataTypeList) {
                    Class c = extraDataType.getTypeClass();
                    outParameter.addParameter(c);
                }
                this.registerOutParameter(outParameter);
            }
        }
        this.dataChanged();
    }

    @Override
    public void dataChanged() {
        GlobalTableModelInterface dataInterface = this.m_entryModel;
        if (dataInterface == null) {
            dataInterface = (GlobalTableModelInterface)this.getData(GlobalTableModelInterface.class);
        }
        ((GenericPanel)this.getDataBoxPanelInterface()).setData(dataInterface);
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
            }
            ArrayList extraDataTypeList = this.m_entryModel.getExtraDataTypes();
            if (extraDataTypeList != null) {
                for (ExtraDataType extraDataType : extraDataTypeList) {
                    if (!extraDataType.getTypeClass().equals(parameterType)) continue;
                    return ((GenericPanel)this.getDataBoxPanelInterface()).getValue(parameterType, extraDataType.isList());
                }
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }
}

