/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.adjacencymatrix.visualize;

import fr.proline.studio.dam.tasks.data.LightPeptideMatch;
import fr.proline.studio.dam.tasks.data.LightProteinMatch;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class ConnectedComponents {
    private ArrayList<LightProteinMatch> m_proteins = new ArrayList();
    private ArrayList<LightPeptideMatch> m_peptides = new ArrayList();
    private HashMap<LightProteinMatch, ArrayList<LightPeptideMatch>> m_proteinToPeptideMap = new HashMap();
    private HashMap<LightPeptideMatch, ArrayList<LightProteinMatch>> m_peptideToProteinMap = new HashMap();
    private HashMap<LightProteinMatch, ArrayList<LightProteinMatch>> m_equivalentProteins = null;
    private int m_maxIndex = 0;
    private int m_maxSize = 0;

    public ConnectedComponents(ArrayList<LightProteinMatch> proteins, ArrayList<LightPeptideMatch> peptides, HashMap<LightProteinMatch, ArrayList<LightPeptideMatch>> proteinToPeptideMap, HashMap<LightPeptideMatch, ArrayList<LightProteinMatch>> peptideToProteinMap, HashMap<LightProteinMatch, ArrayList<LightProteinMatch>> equivalentProteins) {
        this.m_proteins = proteins;
        this.m_peptides = peptides;
        this.m_proteinToPeptideMap = proteinToPeptideMap;
        this.m_peptideToProteinMap = peptideToProteinMap;
        this.m_equivalentProteins = equivalentProteins;
    }

    public int getLargestComponent() {
        return this.m_maxIndex;
    }

    public ArrayList<Component> getConnectedComponents(boolean keepSameSet) {
        int proteinIndex = 0;
        int peptideIndex = 0;
        int componentIndex = 0;
        int proteinSize = this.m_proteins.size();
        int peptideSize = this.m_peptides.size();
        HashSet<LightProteinMatch> proteinFlagSet = new HashSet<LightProteinMatch>(proteinSize);
        HashSet<LightPeptideMatch> peptideFlagSet = new HashSet<LightPeptideMatch>(peptideSize);
        LinkedList<LightProteinMatch> proteinQueue = new LinkedList<LightProteinMatch>();
        LinkedList<LightPeptideMatch> peptideQueue = new LinkedList<LightPeptideMatch>();
        ArrayList<Component> componentSet = new ArrayList<Component>();
        LightProteinMatch proteinTemp = this.m_proteins.get(0);
        LightPeptideMatch peptideTemp = this.m_peptides.get(0);
        proteinQueue.add(proteinTemp);
        proteinFlagSet.add(proteinTemp);
        componentIndex = -1;
        while (proteinIndex < proteinSize && peptideIndex < peptideSize) {
            int j;
            ++componentIndex;
            Component componentNull = new Component();
            componentNull.m_equivalentProteins = this.m_equivalentProteins;
            componentSet.add(componentNull);
            while (!proteinQueue.isEmpty() || !peptideQueue.isEmpty()) {
                while (!proteinQueue.isEmpty()) {
                    proteinTemp = (LightProteinMatch)proteinQueue.remove();
                    ArrayList<LightPeptideMatch> peptideList = this.m_proteinToPeptideMap.get(proteinTemp);
                    for (LightPeptideMatch temp1 : peptideList) {
                        if (peptideFlagSet.contains(temp1)) continue;
                        peptideQueue.add(temp1);
                        peptideFlagSet.add(temp1);
                    }
                    componentSet.get(componentIndex).getProteinArray(false).add(proteinTemp);
                }
                while (!peptideQueue.isEmpty()) {
                    peptideTemp = (LightPeptideMatch)peptideQueue.remove();
                    ArrayList<LightProteinMatch> proteinList = this.m_peptideToProteinMap.get(peptideTemp);
                    for (LightProteinMatch temp2 : proteinList) {
                        if (proteinFlagSet.contains(temp2)) continue;
                        proteinQueue.add(temp2);
                        proteinFlagSet.add(temp2);
                    }
                    componentSet.get(componentIndex).getPeptideArray().add(peptideTemp);
                }
            }
            int tempCheckSize = componentSet.get(componentIndex).getProteinSize(false) + componentSet.get(componentIndex).getPeptideSize();
            if (tempCheckSize > this.m_maxSize) {
                this.m_maxIndex = componentIndex;
                this.m_maxSize = tempCheckSize;
            }
            if (proteinIndex < proteinSize) {
                int i;
                for (i = proteinIndex; i < proteinSize; ++i) {
                    LightProteinMatch proteinCur = this.m_proteins.get(i);
                    if (proteinFlagSet.contains(proteinCur)) continue;
                    proteinQueue.add(proteinCur);
                    proteinFlagSet.add(proteinCur);
                    break;
                }
                proteinIndex = i;
                continue;
            }
            for (j = peptideIndex; j < peptideSize; ++j) {
                LightPeptideMatch peptideCur = this.m_peptides.get(j);
                if (peptideFlagSet.contains(peptideCur)) continue;
                peptideQueue.add(peptideCur);
                peptideFlagSet.add(peptideCur);
                break;
            }
            peptideIndex = j;
        }
        if (keepSameSet) {
            return componentSet;
        }
        return this.filterComponents(componentSet);
    }

    private ArrayList<Component> filterComponents(ArrayList<Component> cList) {
        ArrayList<Component> subCList = new ArrayList<Component>();
        for (Component temp : cList) {
            if (temp.getPeptideArray().size() <= 1 || temp.getProteinArray(false).size() <= 1 || this.fullMatch(temp)) continue;
            subCList.add(temp);
        }
        return subCList;
    }

    private boolean fullMatch(Component temp) {
        for (LightPeptideMatch peptTemp : temp.getPeptideArray()) {
            ArrayList<LightProteinMatch> protList = this.m_peptideToProteinMap.get(peptTemp);
            if (protList.size() == temp.getProteinArray(false).size()) continue;
            return false;
        }
        return true;
    }
}

