/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.LockedDataModel;
import fr.proline.studio.extendedtablemodel.SecondAxisTableModelInterface;
import fr.proline.studio.graphics.BestGraphicsInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.PlotPanel;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.graphics.XAxis;
import fr.proline.studio.graphics.YAxis;
import fr.proline.studio.graphics.core.GraphicsToolbarPanel;
import fr.proline.studio.graphics.core.PlotToolbarListenerInterface;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.DataboxMultiGraphics;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiGraphicsPanel
extends GraphicsToolbarPanel
implements DataBoxPanelInterface {
    private static final Logger m_logger = LoggerFactory.getLogger(MultiGraphicsPanel.class);
    protected AbstractDataBox m_dataBox;
    protected boolean m_canChooseColor = false;
    protected JComboBox<PlotType> m_allPlotsComboBox;
    protected JComboBox<String> m_valueXComboBox;
    protected JComboBox<String> m_valueYComboBox;
    protected JComboBox<String> m_valueZComboBox;
    protected int[] columnXYIndex = new int[2];
    protected JLabel m_valueXLabel;
    protected JLabel m_valueYLabel;
    protected JLabel m_valueZLabel;
    protected List<ExtendedTableModelInterface> m_valuesList = null;
    protected List<CrossSelectionInterface> m_crossSelectionInterfaceList = null;
    protected SecondAxisTableModelInterface m_valueOn2Yxis = null;
    protected boolean m_isUpdatingCbx = false;
    private boolean m_setHideButton;

    public MultiGraphicsPanel(boolean dataLocked, boolean canChooseColor, boolean isDoubleYAxis, boolean setHideButton) {
        super(dataLocked, isDoubleYAxis);
        this.m_canChooseColor = canChooseColor;
        this.m_setHideButton = setHideButton;
        this.fillGraphicToolbar();
    }

    protected final JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(0, 5, 0, 5);
        PlotPanel panel = new PlotPanel();
        this.m_plotPanel = panel.getBasePlotPanel();
        this.m_plotPanel.setPlotToolbarListener((PlotToolbarListenerInterface)this);
        JPanel selectPanel = this.createSelectPanel();
        c.gridx = 0;
        c.gridy = 0;
        internalPanel.add((Component)selectPanel, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        internalPanel.add((Component)panel, c);
        return internalPanel;
    }

    public final void fillToolbar(JToolBar toolbar) {
        SettingsButton settingsButton = new SettingsButton(null, (SettingsInterface)this.m_plotPanel);
        ExportButton exportImageButton = new ExportButton("Graphic", (JPanel)this.m_plotPanel);
        if (this.m_canChooseColor) {
            toolbar.add((Component)settingsButton);
        }
        if (this.m_setHideButton) {
            final JToggleButton showSelectionButton = new JToggleButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SELECT_ALL));
            showSelectionButton.setSize(this.m_gridButton.getSize());
            showSelectionButton.setToolTipText("Hide Selection");
            showSelectionButton.setEnabled(true);
            showSelectionButton.setFocusPainted(false);
            showSelectionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((DataboxMultiGraphics)MultiGraphicsPanel.this.m_dataBox).hideSelection(showSelectionButton.isSelected());
                }
            });
            toolbar.add(showSelectionButton);
        }
        toolbar.addSeparator();
        toolbar.add((Component)exportImageButton);
    }

    protected JPanel createSelectPanel() {
        JPanel selectPanel = new JPanel();
        selectPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel selectLabel = new JLabel("Graphic :");
        this.m_allPlotsComboBox = new JComboBox<PlotType>(PlotType.LINEAR_PLOTS);
        this.m_valueXComboBox = new JComboBox();
        this.m_valueYComboBox = new JComboBox();
        this.m_valueZComboBox = new JComboBox();
        this.m_valueXLabel = new JLabel();
        this.m_valueYLabel = new JLabel();
        this.m_valueZLabel = new JLabel();
        this.updateXYCbxVisibility();
        this.m_allPlotsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiGraphicsPanel.this.fillXYCombobox();
                MultiGraphicsPanel.this.setDataImpl(false, null);
                MultiGraphicsPanel.this.updateXYCbxVisibility();
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        selectPanel.add((Component)selectLabel, c);
        ++c.gridx;
        selectPanel.add(this.m_allPlotsComboBox, c);
        ++c.gridx;
        selectPanel.add((Component)this.m_valueXLabel, c);
        ++c.gridx;
        selectPanel.add(this.m_valueXComboBox, c);
        ++c.gridx;
        selectPanel.add((Component)this.m_valueYLabel, c);
        ++c.gridx;
        selectPanel.add(this.m_valueYComboBox, c);
        ++c.gridx;
        selectPanel.add((Component)this.m_valueZLabel, c);
        ++c.gridx;
        selectPanel.add(this.m_valueZComboBox, c);
        ++c.gridx;
        c.weightx = 1.0;
        selectPanel.add(Box.createHorizontalGlue(), c);
        return selectPanel;
    }

    protected void updateXYCbxVisibility() {
        PlotType plotType = (PlotType)this.m_allPlotsComboBox.getSelectedItem();
        this.m_valueXLabel.setVisible(plotType.needsX());
        this.m_valueXComboBox.setVisible(plotType.needsX());
        this.m_valueYLabel.setVisible(plotType.needsY());
        this.m_valueYComboBox.setVisible(plotType.needsY());
        this.m_valueZLabel.setVisible(plotType.needsZ());
        this.m_valueZComboBox.setVisible(plotType.needsZ());
        if (plotType.needsX()) {
            this.m_valueXLabel.setText(plotType.getXLabel());
        }
        if (plotType.needsY()) {
            this.m_valueYLabel.setText(plotType.getYLabel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillXYCombobox() {
        this.m_isUpdatingCbx = true;
        try {
            BestGraphicsInterface bestGraphics;
            int[] cols;
            boolean hasValues;
            ((DefaultComboBoxModel)this.m_valueXComboBox.getModel()).removeAllElements();
            ((DefaultComboBoxModel)this.m_valueYComboBox.getModel()).removeAllElements();
            ((DefaultComboBoxModel)this.m_valueZComboBox.getModel()).removeAllElements();
            PlotType plotType = (PlotType)this.m_allPlotsComboBox.getSelectedItem();
            HashSet acceptedValues = plotType.getAcceptedXValues();
            int nbValuesType = 0;
            boolean bl = hasValues = this.m_valuesList != null && !this.m_valuesList.isEmpty();
            if (hasValues) {
                nbValuesType = this.m_valuesList.get(0).getColumnCount();
            }
            int bestColX = -1;
            int bestColY = -1;
            if (hasValues && this.m_valuesList.get(0) instanceof BestGraphicsInterface && (cols = (bestGraphics = (BestGraphicsInterface)this.m_valuesList.get(0)).getBestColIndex(plotType)) != null) {
                bestColX = cols[0];
                bestColY = cols[1];
            }
            int bestColIndexXCbx = 0;
            int bestColIndexYCbx = nbValuesType >= 2 ? 1 : 0;
            int nbValuesInCbx = 0;
            for (int i = 0; i < nbValuesType; ++i) {
                Class c = this.m_valuesList.get(0).getDataColumnClass(i);
                if (!acceptedValues.contains(c)) continue;
                ReferenceToColumn ref = new ReferenceToColumn(this.m_valuesList.get(0).getDataColumnIdentifier(i), i);
                ((DefaultComboBoxModel)this.m_valueXComboBox.getModel()).addElement(ref);
                ((DefaultComboBoxModel)this.m_valueYComboBox.getModel()).addElement(ref);
                if (bestColX == i) {
                    bestColIndexXCbx = nbValuesInCbx;
                }
                if (bestColY == i) {
                    bestColIndexYCbx = nbValuesInCbx;
                }
                ++nbValuesInCbx;
            }
            if (nbValuesType > 0) {
                this.m_valueXComboBox.setSelectedIndex(bestColIndexXCbx);
            }
            if (nbValuesType > 0) {
                this.m_valueYComboBox.setSelectedIndex(bestColIndexYCbx);
            }
            if (plotType.needsZ()) {
                ArrayList zValues = plotType.getZValues();
                for (int i = 0; i < zValues.size(); ++i) {
                    ((DefaultComboBoxModel)this.m_valueZComboBox.getModel()).addElement(zValues.get(i));
                }
            }
        }
        finally {
            this.m_isUpdatingCbx = false;
        }
    }

    protected void setXYZComboBox() {
        if (this.m_valueXComboBox.getItemCount() == 0) {
            this.fillXYCombobox();
            ActionListener actionForXYCbx = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MultiGraphicsPanel.this.m_isUpdatingCbx) {
                        return;
                    }
                    ReferenceToColumn refX = (ReferenceToColumn)MultiGraphicsPanel.this.m_valueXComboBox.getSelectedItem();
                    ReferenceToColumn refY = (ReferenceToColumn)MultiGraphicsPanel.this.m_valueYComboBox.getSelectedItem();
                    String zParameter = (String)MultiGraphicsPanel.this.m_valueZComboBox.getSelectedItem();
                    int[] cols = new int[]{refX.getColumnIndex(), refY.getColumnIndex()};
                    if (cols[0] == MultiGraphicsPanel.this.columnXYIndex[0] && cols[1] == MultiGraphicsPanel.this.columnXYIndex[1]) {
                        return;
                    }
                    MultiGraphicsPanel.this.columnXYIndex[0] = cols[0];
                    MultiGraphicsPanel.this.columnXYIndex[1] = cols[1];
                    MultiGraphicsPanel.this.m_plotPanel.updatePlots(cols, zParameter);
                    MultiGraphicsPanel.this.m_plotPanel.repaint();
                }
            };
            this.m_valueXComboBox.addActionListener(actionForXYCbx);
            this.m_valueYComboBox.addActionListener(actionForXYCbx);
            this.m_valueZComboBox.addActionListener(actionForXYCbx);
        }
    }

    public void setData(List<ExtendedTableModelInterface> valuesList, List<CrossSelectionInterface> crossSelectionInterfaceList) {
        this.setData(valuesList, crossSelectionInterfaceList, this.m_valueOn2Yxis, false, null);
    }

    public void setData(List<ExtendedTableModelInterface> valuesList, List<CrossSelectionInterface> crossSelectionInterfaceList, SecondAxisTableModelInterface value2, boolean keepZoom, Double limitMinAxisY) {
        if (this.m_plotPanel.isLocked()) {
            return;
        }
        this.m_valuesList = valuesList;
        this.m_crossSelectionInterfaceList = crossSelectionInterfaceList;
        this.m_valueOn2Yxis = value2;
        if (valuesList == null) {
            return;
        }
        for (int i = 0; i < valuesList.size(); ++i) {
            ExtendedTableModelInterface values = valuesList.get(i);
            if (!this.m_dataLocked || values instanceof LockedDataModel) continue;
            values = new LockedDataModel(values);
            valuesList.set(i, values);
        }
        this.setXYZComboBox();
        this.setDataImpl(keepZoom, limitMinAxisY);
        if (this.m_dataLocked) {
            this.m_plotPanel.lockData(this.m_dataLocked);
        }
    }

    private void setDataImpl(boolean keepZoom, Double limitMinAxisY) {
        ReferenceToColumn refX = (ReferenceToColumn)this.m_valueXComboBox.getSelectedItem();
        ReferenceToColumn refY = (ReferenceToColumn)this.m_valueYComboBox.getSelectedItem();
        if (refX != null && refY != null) {
            this.columnXYIndex[0] = refX.getColumnIndex();
            this.columnXYIndex[1] = refY.getColumnIndex();
        }
        PlotType plotType = (PlotType)this.m_allPlotsComboBox.getSelectedItem();
        switch (plotType) {
            case LINEAR_PLOT: {
                XAxis xAxis = this.m_plotPanel.getXAxis();
                double minXValue = xAxis.getMinValue();
                double maxXValue = xAxis.getMaxValue();
                keepZoom &= maxXValue > minXValue;
                YAxis yAxis = this.m_plotPanel.getYAxis();
                double minYValue = yAxis.getMinValue();
                double maxYValue = yAxis.getMaxValue();
                double minYValueRight = 0.0;
                double maxYValueRight = 0.0;
                if (this.m_isDoubleYAxis) {
                    YAxis yAxisRight = this.m_plotPanel.getYAxisRight();
                    minYValueRight = yAxisRight.getMinValue();
                    maxYValueRight = yAxisRight.getMaxValue();
                }
                ArrayList previousSharedParameters = this.m_plotPanel.getParameters();
                this.m_plotPanel.clearPlots();
                if (this.m_isDoubleYAxis) {
                    this.setPlotsWithDoubleYAxis(limitMinAxisY, previousSharedParameters);
                } else {
                    this.setPlots(limitMinAxisY, previousSharedParameters);
                }
                keepZoom &= maxYValue > minYValue;
                if (keepZoom &= xAxis.getRangeModifiedByUser() || yAxis.getRangeModifiedByUser() || this.m_isDoubleYAxis && this.m_plotPanel.getYAxisRight().getRangeModifiedByUser()) {
                    xAxis = this.m_plotPanel.getXAxis();
                    if (xAxis.isEnum()) {
                        xAxis.setRange(minXValue + 0.5, maxXValue - 0.5);
                    } else {
                        xAxis.setRange(minXValue, maxXValue);
                    }
                    yAxis = this.m_plotPanel.getYAxis();
                    if (yAxis.isEnum()) {
                        yAxis.setRange(minYValue + 0.5, maxYValue - 0.5);
                    } else {
                        yAxis.setRange(minYValue, maxYValue);
                    }
                    if (this.m_isDoubleYAxis) {
                        YAxis yAxisRight = this.m_plotPanel.getYAxisRight();
                        if (yAxisRight.isEnum()) {
                            yAxisRight.setRange(minYValueRight + 0.5, maxYValueRight - 0.5);
                        } else {
                            yAxisRight.setRange(minYValueRight, maxYValueRight);
                        }
                    }
                }
                this.m_plotPanel.repaint();
                break;
            }
        }
    }

    private void setPlots(Double limitMinAxisY, ArrayList<ParameterList> sharedParameterListArray) {
        for (int i = 0; i < this.m_valuesList.size(); ++i) {
            CrossSelectionInterface crossSelectionInterface = this.m_crossSelectionInterfaceList == null || this.m_crossSelectionInterfaceList.size() <= i ? null : this.m_crossSelectionInterfaceList.get(i);
            PlotLinear plotGraphics = new PlotLinear(this.m_plotPanel, this.m_valuesList.get(i), crossSelectionInterface, this.columnXYIndex[0], this.columnXYIndex[1], limitMinAxisY, sharedParameterListArray);
            plotGraphics.setPlotInformation(this.m_valuesList.get(i).getPlotInformation());
            plotGraphics.setIsPaintMarker(false);
            sharedParameterListArray = plotGraphics.getParameters();
            this.m_plotPanel.addPlot((PlotXYAbstract)plotGraphics, true);
        }
    }

    private void setPlotsWithDoubleYAxis(Double limitMinAxisY, ArrayList<ParameterList> sharedParameterListArray) {
        double mainPlotMaxY = Double.NEGATIVE_INFINITY;
        double secondPlotMaxY = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.m_valuesList.size(); ++i) {
            CrossSelectionInterface crossSelectionInterface = this.m_crossSelectionInterfaceList == null || this.m_crossSelectionInterfaceList.size() <= i ? null : this.m_crossSelectionInterfaceList.get(i);
            PlotLinear plotGraphics = new PlotLinear(this.m_plotPanel, this.m_valuesList.get(i), crossSelectionInterface, this.columnXYIndex[0], this.columnXYIndex[1], limitMinAxisY, sharedParameterListArray);
            mainPlotMaxY = Math.max(mainPlotMaxY, plotGraphics.getYMax());
            plotGraphics.setPlotInformation(this.m_valuesList.get(i).getPlotInformation());
            plotGraphics.setIsPaintMarker(false);
            sharedParameterListArray = plotGraphics.getParameters();
            this.m_plotPanel.addPlot((PlotXYAbstract)plotGraphics, true);
        }
        if (this.m_valueOn2Yxis != null && this.m_valueOn2Yxis.getRowCount() != 0) {
            CrossSelectionInterface crossSelectionInterface2 = null;
            PlotLinear plotGraphics = new PlotLinear(this.m_plotPanel, (ExtendedTableModelInterface)this.m_valueOn2Yxis, crossSelectionInterface2, this.columnXYIndex[0], this.columnXYIndex[1], limitMinAxisY, null);
            secondPlotMaxY = plotGraphics.getYMax();
            plotGraphics.setPlotInformation(this.m_valueOn2Yxis.getPlotInformation());
            plotGraphics.setIsPaintMarker(false);
            this.m_plotPanel.addPlot((PlotXYAbstract)plotGraphics, false);
            Color color = this.m_valueOn2Yxis.getPlotInformation().getPlotColor();
            String axisTitle = this.m_valueOn2Yxis.getName();
            if (axisTitle == null) {
                axisTitle = "";
            }
            this.m_plotPanel.setSecondAxisPlotInfo(axisTitle + " " + this.m_valueOn2Yxis.getDataColumnIdentifier(this.columnXYIndex[1]), color);
        }
        this.m_plotPanel.updateAxis();
    }

    @Override
    public void addSingleValue(Object v) {
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public void setHideButton(boolean h) {
        this.m_setHideButton = h;
    }

    protected static class ReferenceToColumn {
        private final String m_name;
        private final int m_columnIndex;

        public ReferenceToColumn(String name, int columnIndex) {
            this.m_name = name;
            this.m_columnIndex = columnIndex;
        }

        public int getColumnIndex() {
            return this.m_columnIndex;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

