/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.aaproperties.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.Sequence;

public class CaseFreeAminoAcidCompoundSet
implements CompoundSet<AminoAcidCompound> {
    private final Map<String, AminoAcidCompound> aminoAcidCompoundCache = new HashMap<String, AminoAcidCompound>();
    private final Map<AminoAcidCompound, Set<AminoAcidCompound>> equivalentsCache = new HashMap<AminoAcidCompound, Set<AminoAcidCompound>>();
    private static final CaseFreeAminoAcidCompoundSet aminoAcidCompoundSet = new CaseFreeAminoAcidCompoundSet();

    public CaseFreeAminoAcidCompoundSet() {
        this.aminoAcidCompoundCache.put("A", new AminoAcidCompound(null, "A", "Ala", "Alanine", Float.valueOf(71.0788f)));
        this.aminoAcidCompoundCache.put("R", new AminoAcidCompound(null, "R", "Arg", "Arginine", Float.valueOf(156.1875f)));
        this.aminoAcidCompoundCache.put("N", new AminoAcidCompound(null, "N", "Asn", "Asparagine", Float.valueOf(114.1039f)));
        this.aminoAcidCompoundCache.put("D", new AminoAcidCompound(null, "D", "Asp", "Aspartic acid", Float.valueOf(115.0886f)));
        this.aminoAcidCompoundCache.put("C", new AminoAcidCompound(null, "C", "Cys", "Cysteine", Float.valueOf(103.1388f)));
        this.aminoAcidCompoundCache.put("E", new AminoAcidCompound(null, "E", "Glu", "Glutamic acid", Float.valueOf(129.1155f)));
        this.aminoAcidCompoundCache.put("Q", new AminoAcidCompound(null, "Q", "Gln", "Glutamine", Float.valueOf(128.1307f)));
        this.aminoAcidCompoundCache.put("G", new AminoAcidCompound(null, "G", "Gly", "Glycine", Float.valueOf(57.0519f)));
        this.aminoAcidCompoundCache.put("H", new AminoAcidCompound(null, "H", "His", "Histidine", Float.valueOf(137.1411f)));
        this.aminoAcidCompoundCache.put("I", new AminoAcidCompound(null, "I", "Ile", "Isoleucine", Float.valueOf(113.1594f)));
        this.aminoAcidCompoundCache.put("L", new AminoAcidCompound(null, "L", "Leu", "Leucine", Float.valueOf(113.1594f)));
        this.aminoAcidCompoundCache.put("K", new AminoAcidCompound(null, "K", "Lys", "Lysine", Float.valueOf(128.1741f)));
        this.aminoAcidCompoundCache.put("M", new AminoAcidCompound(null, "M", "Met", "Methionine", Float.valueOf(131.1986f)));
        this.aminoAcidCompoundCache.put("F", new AminoAcidCompound(null, "F", "Phe", "Phenylalanine", Float.valueOf(147.1766f)));
        this.aminoAcidCompoundCache.put("P", new AminoAcidCompound(null, "P", "Pro", "Proline", Float.valueOf(97.1167f)));
        this.aminoAcidCompoundCache.put("S", new AminoAcidCompound(null, "S", "Ser", "Serine", Float.valueOf(87.0782f)));
        this.aminoAcidCompoundCache.put("T", new AminoAcidCompound(null, "T", "Thr", "Threonine", Float.valueOf(101.1051f)));
        this.aminoAcidCompoundCache.put("W", new AminoAcidCompound(null, "W", "Trp", "Tryptophan", Float.valueOf(186.2132f)));
        this.aminoAcidCompoundCache.put("Y", new AminoAcidCompound(null, "Y", "Tyr", "Tyrosine", Float.valueOf(163.176f)));
        this.aminoAcidCompoundCache.put("V", new AminoAcidCompound(null, "V", "Val", "Valine", Float.valueOf(99.1326f)));
        this.aminoAcidCompoundCache.put("B", new AminoAcidCompound(null, "B", "Asx", "Asparagine or Aspartic acid", null));
        this.aminoAcidCompoundCache.put("Z", new AminoAcidCompound(null, "Z", "Glx", "Glutamine or Glutamic acid", null));
        this.aminoAcidCompoundCache.put("J", new AminoAcidCompound(null, "J", "Xle", "Leucine or Isoleucine", null));
        this.aminoAcidCompoundCache.put("X", new AminoAcidCompound(null, "X", "Xaa", "Unspecified", null));
        this.aminoAcidCompoundCache.put("-", new AminoAcidCompound(null, "-", "---", "Unspecified", null));
        this.aminoAcidCompoundCache.put(".", new AminoAcidCompound(null, ".", "...", "Unspecified", null));
        this.aminoAcidCompoundCache.put("_", new AminoAcidCompound(null, "_", "___", "Unspecified", null));
        this.aminoAcidCompoundCache.put("*", new AminoAcidCompound(null, "*", "***", "Stop", null));
        this.aminoAcidCompoundCache.put("U", new AminoAcidCompound(null, "U", "Sec", "Selenocysteine", Float.valueOf(150.0388f)));
        this.aminoAcidCompoundCache.put("O", new AminoAcidCompound(null, "O", "Pyl", "Pyrrolysine", Float.valueOf(255.3172f)));
        HashMap<String, AminoAcidCompound> lowerCaseSet = new HashMap<String, AminoAcidCompound>();
        for (String s : this.aminoAcidCompoundCache.keySet()) {
            lowerCaseSet.put(s.toLowerCase(), this.aminoAcidCompoundCache.get(s));
        }
        this.aminoAcidCompoundCache.putAll(lowerCaseSet);
    }

    public String getStringForCompound(AminoAcidCompound compound) {
        return compound.toString();
    }

    public AminoAcidCompound getCompoundForString(String string) {
        if (string.length() == 0) {
            return null;
        }
        if (string.length() > this.getMaxSingleCompoundStringLength()) {
            throw new IllegalArgumentException("String supplied (" + string + ") is too long. Max is " + this.getMaxSingleCompoundStringLength());
        }
        return this.aminoAcidCompoundCache.get(string);
    }

    public int getMaxSingleCompoundStringLength() {
        return 1;
    }

    public boolean isCompoundStringLengthEqual() {
        return true;
    }

    public static CaseFreeAminoAcidCompoundSet getAminoAcidCompoundSet() {
        return aminoAcidCompoundSet;
    }

    public boolean compoundsEquivalent(AminoAcidCompound compoundOne, AminoAcidCompound compoundTwo) {
        Set<AminoAcidCompound> equivalents = this.getEquivalentCompounds(compoundOne);
        return equivalents != null && equivalents.contains(compoundTwo);
    }

    public Set<AminoAcidCompound> getEquivalentCompounds(AminoAcidCompound compound) {
        if (this.equivalentsCache.isEmpty()) {
            for (AminoAcidCompound c : this.aminoAcidCompoundCache.values()) {
                this.equivalentsCache.put(c, Collections.singleton(c));
            }
            this.addAmbiguousEquivalents("N", "D", "B");
            this.addAmbiguousEquivalents("E", "Q", "Z");
            this.addAmbiguousEquivalents("I", "L", "J");
            HashSet<AminoAcidCompound> gaps = new HashSet<AminoAcidCompound>();
            AminoAcidCompound gap1 = this.aminoAcidCompoundCache.get("-");
            gaps.add(gap1);
            AminoAcidCompound gap2 = this.aminoAcidCompoundCache.get(".");
            gaps.add(gap2);
            AminoAcidCompound gap3 = this.aminoAcidCompoundCache.get("_");
            gaps.add(gap3);
            this.equivalentsCache.put(gap1, gaps);
            this.equivalentsCache.put(gap2, gaps);
            this.equivalentsCache.put(gap3, gaps);
            this.equivalentsCache.put(this.aminoAcidCompoundCache.get("X"), new HashSet());
        }
        return this.equivalentsCache.get(compound);
    }

    private void addAmbiguousEquivalents(String one, String two, String either) {
        HashSet<AminoAcidCompound> equivalents = new HashSet<AminoAcidCompound>();
        AminoAcidCompound cOne = this.aminoAcidCompoundCache.get(one);
        equivalents.add(cOne);
        AminoAcidCompound cTwo = this.aminoAcidCompoundCache.get(two);
        equivalents.add(cTwo);
        AminoAcidCompound cEither = this.aminoAcidCompoundCache.get(either);
        equivalents.add(cEither);
        this.equivalentsCache.put(cEither, equivalents);
        equivalents = new HashSet();
        equivalents.add(cOne);
        equivalents.add(cEither);
        this.equivalentsCache.put(cOne, equivalents);
        equivalents = new HashSet();
        equivalents.add(cTwo);
        equivalents.add(cEither);
        this.equivalentsCache.put(cTwo, equivalents);
    }

    public boolean hasCompound(AminoAcidCompound compound) {
        return this.aminoAcidCompoundCache.containsValue(compound);
    }

    public List<AminoAcidCompound> getAllCompounds() {
        return new ArrayList<AminoAcidCompound>(this.aminoAcidCompoundCache.values());
    }

    public boolean isComplementable() {
        return false;
    }

    public boolean isValidSequence(Sequence<AminoAcidCompound> sequence) {
        for (AminoAcidCompound c : sequence) {
            if (this.hasCompound(c)) continue;
            return false;
        }
        return true;
    }
}

