/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.service;

import fr.proline.module.seq.config.ParsingRuleEntry;
import fr.proline.module.seq.config.SeqRepoConfig;
import fr.proline.module.seq.service.DataSourceBuilder;
import fr.proline.module.seq.util.RegExUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListMatchingRules {
    List<String> m_fastaDirs;
    private static final Logger LOG = LoggerFactory.getLogger(ListMatchingRules.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            DataSourceBuilder dsBuilder = new DataSourceBuilder();
            Map<String, List<File>> fastaPaths = dsBuilder.getFastaFiles();
            LOG.info(" ---- Scanning Fasta local path ---- ");
            Set<Map.Entry<String, List<File>>> entries = fastaPaths.entrySet();
            for (Map.Entry<String, List<File>> entry : entries) {
                String fastaName = entry.getKey();
                List<File> fastaFiles = entry.getValue();
                ParsingRuleEntry rule = ParsingRuleEntry.getParsingRuleEntry(fastaName);
                String m_seDbIdentRegEx = null;
                if (rule != null) {
                    LOG.info(" Using rule \"{}\" for \"{}\" ", (Object)rule.getProteinAccRegEx(), (Object)fastaName);
                    String releaseRegEx = rule.getFastaReleaseRegEx();
                    LOG.info("   Release (using rule \"{}\") = \"{}\" ", (Object)releaseRegEx, (Object)RegExUtil.parseReleaseVersion(fastaName, releaseRegEx));
                    m_seDbIdentRegEx = rule.getProteinAccRegEx();
                } else {
                    LOG.info(" Using default rule \"{}\" for fasta \"{}\" ", (Object)SeqRepoConfig.getInstance().getDefaultProtAccRegEx(), (Object)fastaName);
                    m_seDbIdentRegEx = SeqRepoConfig.getInstance().getDefaultProtAccRegEx();
                }
                for (File nextFile : fastaFiles) {
                    BufferedReader br = null;
                    try {
                        FileInputStream is = new FileInputStream(nextFile);
                        br = new BufferedReader(new InputStreamReader((InputStream)is, "ISO-8859-1"));
                        String rawLine = br.readLine();
                        int countEntry = 0;
                        while (countEntry < 3 && rawLine != null) {
                            String trimmedLine = rawLine.trim();
                            if (!trimmedLine.isEmpty() && trimmedLine.startsWith(">")) {
                                ++countEntry;
                                String foundEntry = RegExUtil.getMatchingString(trimmedLine, m_seDbIdentRegEx);
                                if (foundEntry == null) {
                                    LOG.warn("\t !! No accession group found for entry \"{}\".", (Object)trimmedLine);
                                } else {
                                    LOG.info("\t Accession \"{}\" will be used for entry \"{}\".", (Object)foundEntry, (Object)trimmedLine);
                                }
                            }
                            rawLine = br.readLine();
                        }
                    }
                    finally {
                        if (br == null) continue;
                        try {
                            br.close();
                        }
                        catch (IOException exClose) {
                            LOG.error("Error closing [" + nextFile + ']', (Throwable)exClose);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

