/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.module.seq.service;

import ch.qos.logback.classic.Level;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import fr.profi.util.ThreadLogger;
import fr.proline.module.seq.Constants;
import fr.proline.module.seq.DatabaseAccess;
import fr.proline.module.seq.dto.DDatabankInstance;
import fr.proline.module.seq.dto.DDatabankProtein;
import fr.proline.module.seq.service.BioSequenceRetriever;
import fr.proline.module.seq.service.ProjectHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetrieveService {
    private static final Logger LOG = LoggerFactory.getLogger(RetrieveService.class);
    private static final long TIMER_BEFORE_DELAY = TimeUnit.SECONDS.toMillis(15L);

    private RetrieveService() {
    }

    public static void main(String[] args) {
        Thread.currentThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadLogger(LOG));
        RetrieveCommand params = new RetrieveCommand();
        JCommander command = new JCommander((Object)params, args);
        command.usage();
        if (params.debug) {
            ch.qos.logback.classic.Logger prolineLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"fr.proline");
            prolineLogger.setLevel(Level.DEBUG);
            LOG.debug("--- Proline Logger set to DEBUG level ");
        }
        DatabaseAccess.getSEQDatabaseConnector(true);
        if (params.hourDelay > 0) {
            Timer timer = new Timer("Timer-retrieveBioSequencesForAllProjects");
            final boolean forceUpdate = params.forceUpdate;
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    Thread currentThread = Thread.currentThread();
                    if (!(currentThread.getUncaughtExceptionHandler() instanceof ThreadLogger)) {
                        currentThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadLogger(LOG));
                    }
                    try {
                        RetrieveService.retrieveBioSequencesForAllProjects(forceUpdate);
                    }
                    catch (Exception ex) {
                        LOG.error("Error running  retrieveBioSequencesForAllProjects()", (Throwable)ex);
                    }
                }
            };
            timer.scheduleAtFixedRate(timerTask, TIMER_BEFORE_DELAY, TimeUnit.HOURS.toMillis(params.hourDelay.intValue()));
            LOG.info("Running \"retrieve task\" every {} hour(s)", (Object)params.hourDelay);
        } else {
            LOG.info("No given hourDelay : Running a single \"retrieve task\"");
            try {
                if (params.projectId == 0) {
                    RetrieveService.retrieveBioSequencesForAllProjects(params.forceUpdate);
                } else {
                    ArrayList<Long> rsmIds = new ArrayList<Long>();
                    if (params.rsmId > 0) {
                        rsmIds.add(params.rsmId.longValue());
                    }
                    RetrieveService.retrieveBioSequences(params.projectId.intValue(), params.forceUpdate, rsmIds);
                }
                BioSequenceRetriever.waitExecutorShutdown();
                System.out.println("\nMain terminated !");
                System.exit(0);
            }
            catch (Exception e) {
                LOG.error("Error running  retrieveBioSequences ", (Throwable)e);
                System.out.println("\nMain terminated with ERROR");
                System.exit(1);
            }
        }
    }

    public static void retrieveBioSequencesForAllProjects(boolean forceUpdate) throws Exception {
        LOG.info("Start RetrieveService for all projects");
        int persistedProteinsCount = 0;
        long start = System.currentTimeMillis();
        List<Long> projectIds = ProjectHandler.retrieveAllActiveProjectIds();
        if (projectIds == null || projectIds.isEmpty()) {
            LOG.warn("NO MSI Project found");
        } else {
            for (Long projectId : projectIds) {
                if (projectId == null) continue;
                ProjectHandler projectHandler = new ProjectHandler(projectId);
                List<Long> rsmIds = projectHandler.findAllRSMIds();
                persistedProteinsCount += RetrieveService._retrieveBioSequences(projectHandler, forceUpdate, rsmIds);
                DatabaseAccess.getDataStoreConnectorFactory().closeProjectConnectors(projectId.longValue());
            }
        }
        long duration = System.currentTimeMillis() - start;
        LOG.info("Total for all projects execution: {} Protein Identifiers handled in {} ms", (Object)persistedProteinsCount, (Object)duration);
    }

    public static int retrieveBioSequences(long projectId, boolean forceUpdate, List<Long> rsmIds) throws Exception {
        long start = System.currentTimeMillis();
        ProjectHandler projectHandler = new ProjectHandler(projectId);
        if (rsmIds == null || rsmIds.isEmpty()) {
            rsmIds = projectHandler.findAllRSMIds();
        }
        LOG.info("Start RetrieveBioSequences for RSMs {} of Project #{}", (Object)rsmIds.toString(), (Object)projectId);
        int persistedProteinsCount = RetrieveService._retrieveBioSequences(projectHandler, forceUpdate, rsmIds);
        long duration = System.currentTimeMillis() - start;
        LOG.info("Total RetrieveBioSequences for RSMs of Project #{} execution: {} Protein Identifiers persisted in {} ms", new Object[]{projectId, persistedProteinsCount, duration});
        return persistedProteinsCount;
    }

    private static int _retrieveBioSequences(ProjectHandler projectHandler, boolean forceUpdate, List<Long> rsmIds) throws Exception {
        int persistedProteinsCount = 0;
        if (projectHandler.isProjectActive().booleanValue()) {
            HashMap<DDatabankInstance, Set<DDatabankProtein>> proteinsByDatabank = new HashMap<DDatabankInstance, Set<DDatabankProtein>>();
            List<Long> finalRsmIds = projectHandler.filterRSMIdsToUpdate(rsmIds, forceUpdate);
            Map<Long, DDatabankInstance> databankBySeqDatabase = projectHandler.retrieveAllSeqDatabases();
            projectHandler.findProteinIdentifiers(proteinsByDatabank, databankBySeqDatabase, finalRsmIds);
            if (proteinsByDatabank == null || proteinsByDatabank.isEmpty()) {
                LOG.warn("NO DatabankProtein found");
            } else {
                persistedProteinsCount = BioSequenceRetriever.retrieveBioSequences(proteinsByDatabank);
                if (Constants.PERSISTENCE) {
                    projectHandler.fillProteinMatchesProperties(databankBySeqDatabase, proteinsByDatabank, finalRsmIds);
                }
            }
            projectHandler.close();
        } else {
            LOG.warn("Project #{} is not active", (Object)projectHandler.getProjectId());
        }
        return persistedProteinsCount;
    }

    public static class RetrieveCommand {
        @Parameter(names={"-p", "--project"}, description="the ID of the single project to process")
        private Integer projectId = 0;
        @Parameter(names={"-debug"}, description="set logger level to DEBUG (verbose mode)")
        private boolean debug = false;
        @Parameter(names={"-t", "--time"}, description="the daemon periodicity (in hours)")
        private Integer hourDelay = -1;
        @Parameter(names={"-f", "--forceUpdate"}, description="force update of MSIdb result summaries and biosequences (even if already updated)")
        private boolean forceUpdate = false;
        @Parameter(names={"-rsm"}, description="specify rsm id to update")
        private Integer rsmId = 0;
    }
}

