/*
 * Decompiled with CFR 0.152.
 */
package mr.go.sgfilter;

import mr.go.sgfilter.DataFilter;

public class RamerDouglasPeuckerFilter
implements DataFilter {
    private double epsilon;

    public RamerDouglasPeuckerFilter(double epsilon) {
        if (epsilon <= 0.0) {
            throw new IllegalArgumentException("Epsilon nust be > 0");
        }
        this.epsilon = epsilon;
    }

    @Override
    public double[] filter(double[] data) {
        return this.ramerDouglasPeuckerFunction(data, 0, data.length - 1);
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    protected double[] ramerDouglasPeuckerFunction(double[] points, int startIndex, int endIndex) {
        double dmax = 0.0;
        int idx = 0;
        double a = endIndex - startIndex;
        double b = points[endIndex] - points[startIndex];
        double c = -(b * (double)startIndex - a * points[startIndex]);
        double norm = Math.sqrt(Math.pow(a, 2.0) + Math.pow(b, 2.0));
        for (int i = startIndex + 1; i < endIndex; ++i) {
            double distance = Math.abs(b * (double)i - a * points[i] + c) / norm;
            if (!(distance > dmax)) continue;
            idx = i;
            dmax = distance;
        }
        if (dmax >= this.epsilon) {
            double[] recursiveResult1 = this.ramerDouglasPeuckerFunction(points, startIndex, idx);
            double[] recursiveResult2 = this.ramerDouglasPeuckerFunction(points, idx, endIndex);
            double[] result = new double[recursiveResult1.length - 1 + recursiveResult2.length];
            System.arraycopy(recursiveResult1, 0, result, 0, recursiveResult1.length - 1);
            System.arraycopy(recursiveResult2, 0, result, recursiveResult1.length - 1, recursiveResult2.length);
            return result;
        }
        return new double[]{points[startIndex], points[endIndex]};
    }

    public void setEpsilon(double epsilon) {
        if (epsilon <= 0.0) {
            throw new IllegalArgumentException("Epsilon nust be > 0");
        }
        this.epsilon = epsilon;
    }
}

