/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.fatcat;

import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.fatcat.FatCatRigid;
import org.biojava.nbio.structure.align.fatcat.FatCatUserArgumentProcessor;
import org.biojava.nbio.structure.align.fatcat.calc.FatCatAligner;
import org.biojava.nbio.structure.align.fatcat.calc.FatCatParameters;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.ConfigurationException;

public class FatCat {
    public static final String VERSION = "1.1";
    public static String newline = System.getProperty("line.separator");
    FatCatAligner aligner;
    public static final String algorithmName = "jFatCat";

    public static void main(String[] argv) throws ConfigurationException {
        FatCatUserArgumentProcessor processor = new FatCatUserArgumentProcessor();
        processor.process(argv);
    }

    public String toString() {
        return "JFatCat v. 1.1";
    }

    public AFPChain alignRigid(Atom[] ca1, Atom[] ca2) throws StructureException {
        FatCatRigid fatCat = new FatCatRigid();
        return fatCat.align(ca1, ca2);
    }

    public AFPChain alignRigid(Atom[] ca1, Atom[] ca2, FatCatParameters params) throws StructureException {
        AFPChain afpChain = this.align(ca1, ca2, params, true);
        afpChain.setAlgorithmName("jFatCat_rigid");
        afpChain.setVersion(VERSION);
        return afpChain;
    }

    public AFPChain alignFlexible(Atom[] ca1, Atom[] ca2, FatCatParameters params) throws StructureException {
        AFPChain afpChain = this.align(ca1, ca2, params, false);
        afpChain.setAlgorithmName("jFatCat_flexible");
        afpChain.setVersion(VERSION);
        return afpChain;
    }

    protected AFPChain align(Atom[] ca1, Atom[] ca2, FatCatParameters params, boolean doRigid) throws StructureException {
        this.aligner = new FatCatAligner();
        this.aligner.align(ca1, ca2, doRigid, params);
        return this.aligner.getAfpChain();
    }

    public FatCatAligner getFatCatAligner() {
        if (this.aligner == null) {
            this.aligner = new FatCatAligner();
        }
        return this.aligner;
    }
}

