/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.model;

import fr.profi.mzdb.model.ILcContext;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.util.ms.MsUtils;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class SpectrumData {
    protected double[] mzList;
    protected float[] intensityList;
    protected float[] leftHwhmList;
    protected float[] rightHwhmList;
    protected int peaksCount;

    public SpectrumData(double[] mzList, float[] intensityList, float[] lHwhmList, float[] rHwhmList) {
        this.peaksCount = mzList.length;
        this.mzList = mzList;
        this.intensityList = intensityList;
        this.leftHwhmList = lHwhmList;
        this.rightHwhmList = rHwhmList;
    }

    public SpectrumData(double[] mzList, float[] intensityList) {
        this(mzList, intensityList, null, null);
    }

    public int getPeaksCount() {
        return this.peaksCount;
    }

    public double[] getMzList() {
        return this.mzList;
    }

    public float[] getIntensityList() {
        return this.intensityList;
    }

    public float[] getLeftHwhmList() {
        return this.leftHwhmList;
    }

    public float[] getRightHwhmList() {
        return this.rightHwhmList;
    }

    public Peak[] toPeaks(ILcContext lcContext) {
        Peak[] peaks = new Peak[this.peaksCount];
        for (int i = 0; i < this.peaksCount; ++i) {
            float leftHwhm = 0.0f;
            float rightHwhm = 0.0f;
            if (this.leftHwhmList != null && this.rightHwhmList != null) {
                leftHwhm = this.leftHwhmList[i];
                rightHwhm = this.rightHwhmList[i];
            }
            peaks[i] = new Peak(this.mzList[i], this.intensityList[i], leftHwhm, rightHwhm, lcContext);
        }
        return peaks;
    }

    public void addSpectrumData(SpectrumData spectrumData) {
        if (spectrumData != null) {
            this.mzList = ArrayUtils.addAll((double[])this.mzList, (double[])spectrumData.mzList);
            this.intensityList = ArrayUtils.addAll((float[])this.intensityList, (float[])spectrumData.intensityList);
            if (spectrumData.leftHwhmList != null && spectrumData.rightHwhmList != null) {
                this.leftHwhmList = ArrayUtils.addAll((float[])this.leftHwhmList, (float[])spectrumData.leftHwhmList);
                this.rightHwhmList = ArrayUtils.addAll((float[])this.rightHwhmList, (float[])spectrumData.rightHwhmList);
            }
            this.peaksCount = this.mzList.length;
        }
    }

    public void resizeDataArrays(int newLength) {
        this.mzList = Arrays.copyOf(this.mzList, newLength);
        this.intensityList = Arrays.copyOf(this.intensityList, newLength);
        if (this.leftHwhmList != null && this.rightHwhmList != null) {
            this.leftHwhmList = Arrays.copyOf(this.leftHwhmList, newLength);
            this.rightHwhmList = Arrays.copyOf(this.rightHwhmList, newLength);
        }
        this.peaksCount = newLength;
    }

    public double getMinMz() {
        if (this.peaksCount == 0) {
            return 0.0;
        }
        return this.mzList[0];
    }

    public double getMaxMz() {
        if (this.peaksCount == 0) {
            return 0.0;
        }
        return this.mzList[this.peaksCount - 1];
    }

    public boolean isEmpty() {
        return this.peaksCount == 0;
    }

    private int _binSearchIndexToNearestIndex(int binSearchIndex) {
        if (binSearchIndex >= 0) {
            return binSearchIndex;
        }
        int idx = -binSearchIndex - 1;
        if (idx == 0) {
            return -1;
        }
        return idx;
    }

    public Peak getNearestPeak(double mz, double mzTolPPM, ILcContext lcContext) {
        if (this.peaksCount == 0) {
            return null;
        }
        double[] myMzList = this.mzList;
        double mzDa = MsUtils.ppmToDa(mz, mzTolPPM);
        int binSearchIndex = Arrays.binarySearch(myMzList, mz);
        int idx = binSearchIndex >= 0 ? binSearchIndex : -binSearchIndex - 1;
        double prevVal = 0.0;
        double nextVal = 0.0;
        int newIdx = 0;
        if (idx == this.peaksCount) {
            prevVal = myMzList[this.peaksCount - 1];
            if (Math.abs(mz - prevVal) > mzDa) {
                return null;
            }
            newIdx = idx - 1;
        } else if (idx == 0) {
            nextVal = myMzList[idx];
            if (Math.abs(mz - nextVal) > mzDa) {
                return null;
            }
            newIdx = idx;
        } else {
            double diffPrevVal;
            nextVal = myMzList[idx];
            prevVal = myMzList[idx - 1];
            double diffNextVal = Math.abs(mz - nextVal);
            if (diffNextVal < (diffPrevVal = Math.abs(mz - prevVal))) {
                if (diffNextVal > mzDa) {
                    return null;
                }
                newIdx = idx;
            } else {
                if (diffPrevVal > mzDa) {
                    return null;
                }
                newIdx = idx - 1;
            }
        }
        return new Peak(myMzList[newIdx], this.intensityList[newIdx], this.leftHwhmList[newIdx], this.rightHwhmList[newIdx], lcContext);
    }

    public int getNearestPeakIndex(double value) {
        int idx = Arrays.binarySearch(this.mzList, value);
        idx = idx < 0 ? ~idx : idx;
        double min = Double.MAX_VALUE;
        for (int k = Math.max(0, idx - 1); k <= Math.min(this.peaksCount - 1, idx + 1); ++k) {
            if (!(Math.abs(this.mzList[k] - value) < min)) continue;
            min = Math.abs(this.mzList[k] - value);
            idx = k;
        }
        return idx;
    }

    public int getPeakIndex(double value, double ppmTol) {
        int idx = Arrays.binarySearch(this.mzList, value);
        idx = idx < 0 ? ~idx : idx;
        double min = Double.MAX_VALUE;
        int resultIdx = -1;
        for (int k = Math.max(0, idx - 1); k <= Math.min(this.peaksCount - 1, idx + 1); ++k) {
            if (!(1000000.0 * Math.abs(this.mzList[k] - value) / value < ppmTol) || !(Math.abs(this.mzList[k] - value) < min)) continue;
            min = Math.abs(this.mzList[k] - value);
            resultIdx = k;
        }
        return resultIdx;
    }

    public SpectrumData mzRangeFilter(double mzMin, double mzMax) {
        int maxBinSearchIndex;
        int lastIdx;
        if (mzMin > mzMax) {
            double tmp = mzMax;
            mzMax = mzMin;
            mzMin = tmp;
        }
        int nbPoints = this.peaksCount;
        int minBinSearchIndex = Arrays.binarySearch(this.mzList, mzMin);
        int firstIdx = this._binSearchIndexToNearestIndex(minBinSearchIndex);
        if (firstIdx == nbPoints) {
            return null;
        }
        if (firstIdx == -1) {
            firstIdx = 0;
        }
        if ((lastIdx = this._binSearchIndexToNearestIndex(maxBinSearchIndex = Arrays.binarySearch(this.mzList, firstIdx, nbPoints, mzMax))) == -1) {
            return null;
        }
        SpectrumData filteredSpectrumData = new SpectrumData(Arrays.copyOfRange(this.mzList, firstIdx, lastIdx), Arrays.copyOfRange(this.intensityList, firstIdx, lastIdx));
        if (this.leftHwhmList != null) {
            filteredSpectrumData.leftHwhmList = Arrays.copyOfRange(this.leftHwhmList, firstIdx, lastIdx);
            filteredSpectrumData.rightHwhmList = Arrays.copyOfRange(this.rightHwhmList, firstIdx, lastIdx);
        }
        return filteredSpectrumData;
    }
}

