/*
 * Decompiled with CFR 0.152.
 */
package jwave;

import jwave.Transform;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;
import jwave.transforms.BasicTransform;
import jwave.transforms.DiscreteFourierTransform;
import jwave.transforms.FastWaveletTransform;
import jwave.transforms.WaveletPacketTransform;
import jwave.transforms.wavelets.Wavelet;
import jwave.transforms.wavelets.WaveletBuilder;

public class TransformBuilder {
    public static Transform create(String transformName, Wavelet wavelet) {
        BasicTransform basicTransform = null;
        try {
            switch (transformName) {
                case "Discrete Fourier Transform": {
                    basicTransform = new DiscreteFourierTransform();
                    break;
                }
                case "Fast Wavelet Transform": {
                    basicTransform = new FastWaveletTransform(wavelet);
                    break;
                }
                case "Wavelet Packet Transform": {
                    basicTransform = new WaveletPacketTransform(wavelet);
                    break;
                }
                default: {
                    throw new JWaveFailure("TransformBuilder::create - unknown type of transform for given string!");
                }
            }
        }
        catch (JWaveException e) {
            e.showMessage();
            e.printStackTrace();
        }
        return new Transform(basicTransform);
    }

    public static Transform create(String transformName, String waveletName) {
        return TransformBuilder.create(transformName, WaveletBuilder.create(waveletName));
    }

    public static String identify(Transform transform) {
        BasicTransform basicTransform = transform.getBasicTransform();
        return basicTransform.getName();
    }
}

