/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.junit.Assert;
import org.junit.Test;
import org.python.core.JyAttribute;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyType;
import org.python.util.PythonInterpreter;

public class ConcurrentTypeTest {
    private static int RUNNERS = 100;
    static final String javaImportScript;
    static final String javaImportScript2;
    static final String loadedJava;
    static final String loaderScript;
    static final String loaderScript2;

    @Test
    public void testSharedState() {
        ArrayList<SharedStateRunner> runners = new ArrayList<SharedStateRunner>(RUNNERS);
        for (int i = 0; i < RUNNERS; ++i) {
            runners.add(new SharedStateRunner(javaImportScript, i));
        }
        this.awaitAll(runners);
        for (SharedStateRunner r : runners) {
            PyObject e = r.globals.__finditem__("e");
            Assert.assertEquals((String)("Runner " + r.instance), null, (Object)e);
        }
    }

    @Test
    public void testSeparateState() {
        ArrayList<SeparateStateRunner> runners = new ArrayList<SeparateStateRunner>(RUNNERS);
        for (int i = 0; i < RUNNERS; ++i) {
            runners.add(new SeparateStateRunner(javaImportScript, i));
        }
        this.awaitAll(runners);
        for (SeparateStateRunner r : runners) {
            PyObject e = r.globals.__finditem__("e");
            Assert.assertEquals((String)("Runner " + r.instance), null, (Object)e);
        }
    }

    @Test
    public void testSeparateState2() {
        ArrayList<SeparateStateRunner> runners = new ArrayList<SeparateStateRunner>(RUNNERS);
        for (int i = 0; i < RUNNERS; ++i) {
            runners.add(new SeparateStateRunner(javaImportScript2, i));
        }
        this.awaitAll(runners);
        for (SeparateStateRunner r : runners) {
            PyObject e = r.globals.__finditem__("e");
            Assert.assertEquals((String)("Runner " + r.instance), null, (Object)e);
        }
    }

    @Test
    public void testSeparateLoader() {
        ClassCacheFileManager fileManager = this.getClassCacheFileManager(loadedJava, "Foo");
        ArrayList<SeparateLoaderRunner> runners = new ArrayList<SeparateLoaderRunner>(RUNNERS);
        for (int i = 0; i < RUNNERS; ++i) {
            runners.add(new SeparateLoaderRunner(loaderScript, i, fileManager.newClassLoader()));
        }
        this.awaitAll(runners);
        for (SeparateLoaderRunner r : runners) {
            PyObject e = r.globals.__finditem__("e");
            Assert.assertEquals((String)("Runner " + r.instance), null, (Object)e);
            PyObject staticConstant = r.globals.__finditem__("staticConstant");
            Assert.assertNotNull((Object)staticConstant);
            Assert.assertEquals((long)staticConstant.asInt(), (long)42L);
            PyObject x = r.globals.__finditem__("x");
            Assert.assertEquals((long)x.asInt(), (long)42L);
        }
    }

    @Test
    public void testSeparateLoader2() {
        ClassCacheFileManager fileManager = this.getClassCacheFileManager(loadedJava, "Foo");
        ArrayList<SeparateLoaderRunner> runners = new ArrayList<SeparateLoaderRunner>(RUNNERS);
        for (int i = 0; i < RUNNERS; ++i) {
            runners.add(new SeparateLoaderRunner(loaderScript2, i, fileManager.newClassLoader()));
        }
        this.awaitAll(runners);
        HashSet<Object> classes = new HashSet<Object>();
        HashSet<PyType> types2 = new HashSet<PyType>();
        for (SeparateLoaderRunner r : runners) {
            PyObject e = r.globals.__finditem__("e");
            Assert.assertEquals((String)("Runner " + r.instance), null, (Object)e);
            PyObject m = r.globals.__finditem__("m");
            Assert.assertEquals((Object)m.toString(), (Object)"forty-two");
            PyObject x = r.globals.__finditem__("x");
            Assert.assertEquals((Object)x.toString(), (Object)"forty-two");
            PyType f = (PyType)r.globals.__finditem__("Foo");
            types2.add(f);
            Object c = JyAttribute.getAttr(f, (byte)-128);
            classes.add(c);
        }
    }

    private ClassCacheFileManager getClassCacheFileManager(final String javaSource, String name) {
        JavaCompiler COMPILER = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager stdFileManager = COMPILER.getStandardFileManager(null, null, null);
        SimpleJavaFileObject sourceFile = new SimpleJavaFileObject(URI.create("string:///" + name + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE){

            @Override
            public CharSequence getCharContent(boolean ignore) {
                return javaSource;
            }
        };
        List<1> compilationUnits = Collections.singletonList(sourceFile);
        ClassCacheFileManager fileManager = new ClassCacheFileManager(stdFileManager);
        JavaCompiler.CompilationTask task = COMPILER.getTask(null, fileManager, null, null, null, compilationUnits);
        Assert.assertTrue((String)"Compilation of Java class failed", (boolean)task.call());
        return fileManager;
    }

    /*
     * WARNING - void declaration
     */
    private void awaitAll(List<? extends ScriptRunner> runners) {
        void var3_6;
        for (ScriptRunner scriptRunner : runners) {
            scriptRunner.thread.start();
        }
        boolean running = true;
        boolean bl = false;
        while (running && var3_6 < 10) {
            running = false;
            for (ScriptRunner scriptRunner : runners) {
                Thread t = scriptRunner.thread;
                try {
                    t.join(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                running |= t.isAlive();
            }
            ++var3_6;
        }
        Assert.assertFalse((String)"runners did not finish", (boolean)running);
    }

    static {
        Options.importSite = false;
        javaImportScript = String.join((CharSequence)"\n", "try:", "    from javax.swing.text.Utilities import *", "    f = getNextWord", "except Exception as e:", "    pass");
        javaImportScript2 = String.join((CharSequence)"\n", "try:", "    from java.lang import Thread", "    Thread.sleep(instance*10)", "    from javax.swing.text.Utilities import *", "    f = getNextWord", "except Exception as e:", "    pass");
        loadedJava = String.join((CharSequence)"\n", "package thin.air;", "public class Foo {", "    public static final int staticConstant = 42;", "    public String member = \"forty-two\";", "    public static int staticMethod() { return 42; }", "    public String method() { return member; }", "}");
        loaderScript = String.join((CharSequence)"\n", "try:", "    from thin.air.Foo import *", "    x = staticMethod()", "except Exception as e:", "    pass");
        loaderScript2 = String.join((CharSequence)"\n", "try:", "    from thin.air import Foo", "    f = Foo()", "    m = f.member", "    x = f.method()", "except Exception as e:", "    pass");
    }

    private static class ClassCacheFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        final Map<String, ClassFileObject> map = new HashMap<String, ClassFileObject>();

        protected ClassCacheFileManager(JavaFileManager fileManager) {
            super(fileManager);
        }

        @Override
        public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
            ClassFileObject file;
            if (kind == JavaFileObject.Kind.CLASS && (file = this.map.get(className)) != null) {
                return file;
            }
            return super.getJavaFileForInput(location, className, kind);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            if (kind == JavaFileObject.Kind.CLASS) {
                return new ClassFileObject(className);
            }
            return super.getJavaFileForOutput(location, className, kind, sibling);
        }

        public ClassLoader newClassLoader() {
            return new ClassLoader(){

                @Override
                protected Class<?> findClass(String className) throws ClassNotFoundException {
                    ClassFileObject file = map.get(className);
                    if (file != null) {
                        byte[] b = file.stream.toByteArray();
                        return this.defineClass(className, b, 0, b.length);
                    }
                    throw new ClassNotFoundException();
                }
            };
        }

        protected class ClassFileObject
        extends SimpleJavaFileObject {
            private final String className;
            private ByteArrayOutputStream stream;

            ClassFileObject(String className) {
                super(URI.create("map:///" + className), JavaFileObject.Kind.CLASS);
                this.className = className;
            }

            @Override
            public OutputStream openOutputStream() throws IOException {
                this.stream = new ByteArrayOutputStream(1024);
                ClassCacheFileManager.this.map.put(this.className, this);
                return this.stream;
            }
        }
    }

    private static class SeparateLoaderRunner
    extends ScriptRunner {
        final PySystemState sys = new PySystemState();

        SeparateLoaderRunner(String script, int instance, ClassLoader classLoader) {
            super(instance);
            this.sys.setClassLoader(classLoader);
            this.setInterp(new PythonInterpreter(this.globals, this.sys), script);
        }
    }

    private static class SeparateStateRunner
    extends ScriptRunner {
        final PySystemState sys = new PySystemState();

        SeparateStateRunner(String script, int instance) {
            super(instance);
            this.setInterp(new PythonInterpreter(this.globals, this.sys), script);
        }
    }

    private static class SharedStateRunner
    extends ScriptRunner {
        SharedStateRunner(String script, int instance) {
            super(instance);
            this.setInterp(new PythonInterpreter(this.globals), script);
        }
    }

    private static abstract class ScriptRunner
    implements Runnable {
        final int instance;
        final Thread thread;
        String script;
        PyCode code;
        final PyStringMap globals = Py.newStringMap();
        PythonInterpreter interp;

        ScriptRunner(int instance) {
            this.instance = instance;
            this.thread = new Thread(this);
            this.globals.__setitem__("instance", (PyObject)Py.newInteger(instance));
        }

        void setInterp(PythonInterpreter interp, String script) {
            this.interp = interp;
            this.script = script;
            this.code = interp.compile(script);
        }

        @Override
        public void run() {
            this.interp.exec(this.code);
        }
    }
}

