/*
 * Decompiled with CFR 0.152.
 */
package jwave.compressions;

import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;

public abstract class Compressor {
    protected double _threshold = 1.0;
    protected double _magnitude = 0.0;

    public Compressor() {
        this._threshold = 1.0;
    }

    public Compressor(double threshold) {
        try {
            if (threshold <= 0.0) {
                throw new JWaveFailure("Compressor - given threshold should be larger than zero!");
            }
        }
        catch (JWaveException e) {
            e.showMessage();
            System.out.println("Compressor - setting threshold to default value: 1.0");
            threshold = 1.0;
        }
        this._threshold = threshold;
    }

    protected double[] compress(double[] arr, double magnitude) {
        int arrLength = arr.length;
        double[] arrComp = new double[arrLength];
        for (int i = 0; i < arrLength; ++i) {
            arrComp[i] = Math.abs(arr[i]) >= magnitude * this._threshold ? arr[i] : 0.0;
        }
        return arrComp;
    }

    protected double[][] compress(double[][] mat, double magnitude) {
        int matHilbNoOfRows = mat.length;
        int matHilbNoOfCols = mat[0].length;
        double[][] matComp = new double[matHilbNoOfRows][matHilbNoOfCols];
        for (int i = 0; i < matHilbNoOfRows; ++i) {
            for (int j = 0; j < matHilbNoOfCols; ++j) {
                matComp[i][j] = Math.abs(mat[i][j]) >= magnitude * this._threshold ? mat[i][j] : 0.0;
            }
        }
        return matComp;
    }

    protected double[][][] compress(double[][][] spc, double magnitude) {
        int matHilbNoOfRows = spc.length;
        int matHilbNoOfCols = spc[0].length;
        int matHilbNoOfLvls = spc[0][0].length;
        double[][][] spcComp = new double[matHilbNoOfRows][matHilbNoOfCols][matHilbNoOfLvls];
        for (int i = 0; i < matHilbNoOfRows; ++i) {
            for (int j = 0; j < matHilbNoOfCols; ++j) {
                for (int k = 0; k < matHilbNoOfLvls; ++k) {
                    spcComp[i][j][k] = Math.abs(spc[i][j][k]) >= magnitude * this._threshold ? spc[i][j][k] : 0.0;
                }
            }
        }
        return spcComp;
    }

    public double getThreshold() {
        return this._threshold;
    }

    public double getMagnitude() {
        return this._magnitude;
    }

    public abstract double[] compress(double[] var1);

    public abstract double[][] compress(double[][] var1);

    public abstract double[][][] compress(double[][][] var1);
}

