/*
 * Decompiled with CFR 0.152.
 */
package jwave.datatypes.spaces;

import java.util.HashMap;
import jwave.datatypes.blocks.Block;
import jwave.datatypes.blocks.BlockHash;
import jwave.datatypes.spaces.Space;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;

public class SpaceHash
extends Space {
    HashMap<Integer, Block> _hashMapBlocks = null;

    public SpaceHash() {
    }

    public SpaceHash(Space space) {
        super(space);
        try {
            this.alloc();
            for (int i = 0; i < this._noOfRows; ++i) {
                for (int j = 0; j < this._noOfCols; ++j) {
                    for (int k = 0; k < this._noOfLvls; ++k) {
                        this.set(i, j, k, space.get(i, j, k));
                    }
                }
            }
        }
        catch (JWaveException e) {
            e.printStackTrace();
        }
    }

    public SpaceHash(int noOfRows, int noOfCols, int noOfLvls) {
        super(noOfRows, noOfCols, noOfLvls);
    }

    public SpaceHash(int offSetRow, int offSetCol, int offSetLvl, int noOfRows, int noOfCols, int noOfLvls) {
        super(offSetRow, offSetCol, offSetLvl, noOfRows, noOfCols, noOfLvls);
    }

    @Override
    public Space copy() {
        return new SpaceHash(this);
    }

    @Override
    public boolean isAllocated() {
        boolean isAllocated = true;
        if (this._hashMapBlocks == null) {
            isAllocated = false;
        }
        return isAllocated;
    }

    @Override
    public void alloc() throws JWaveException {
        if (!this.isAllocated()) {
            this._hashMapBlocks = new HashMap();
        }
    }

    @Override
    public void erase() throws JWaveException {
        if (this._hashMapBlocks != null) {
            this._hashMapBlocks.clear();
        }
        this._hashMapBlocks = null;
    }

    @Override
    public double get(int i, int j, int k) throws JWaveException {
        this.checkMemory();
        this.check(i, j, k);
        Block block = null;
        double value = 0.0;
        if (!this._hashMapBlocks.containsKey(k)) {
            throw new JWaveFailure("Line - no value stored for requested i: " + i);
        }
        block = this._hashMapBlocks.get(k);
        value = block.get(i, j);
        return value;
    }

    @Override
    public void set(int i, int j, int k, double value) throws JWaveException {
        this.checkMemory();
        this.check(i, j, k);
        Block block = null;
        if (this._hashMapBlocks.containsKey(k)) {
            block = this._hashMapBlocks.get(k);
            block.set(i, j, value);
        } else {
            block = new BlockHash(this._offSetRow, this._offSetCol, this._noOfRows, this._noOfCols);
            block.alloc();
            block.set(i, j, value);
            this._hashMapBlocks.put(k, block);
        }
    }
}

