/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms;

import jwave.datatypes.natives.Complex;
import jwave.exceptions.JWaveError;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;
import jwave.tools.MathToolKit;
import jwave.transforms.wavelets.Wavelet;

public abstract class BasicTransform {
    protected String _name = null;

    public String getName() {
        return this._name;
    }

    public Wavelet getWavelet() throws JWaveFailure {
        throw new JWaveFailure("BasicTransform#getWavelet - not available");
    }

    public abstract double[] forward(double[] var1) throws JWaveException;

    public abstract double[] reverse(double[] var1) throws JWaveException;

    public double[] forward(double[] arrTime, int level) throws JWaveException {
        throw new JWaveError("BasicTransform#forward - method is not implemented for this transform type!");
    }

    public double[] reverse(double[] arrFreq, int level) throws JWaveException {
        throw new JWaveError("BasicTransform#reverse - method is not implemented for this transform type!");
    }

    public double[][] decompose(double[] arrTime) throws JWaveException {
        throw new JWaveError("BasicTransform#decompose - method is not implemented for this transform type!");
    }

    public double[] recompose(double[][] matDeComp) throws JWaveException {
        int level = matDeComp.length - 1;
        double[] arrTime = null;
        try {
            arrTime = this.recompose(matDeComp, level);
        }
        catch (JWaveFailure e) {
            e.showMessage();
            e.printStackTrace();
        }
        return arrTime;
    }

    public double[] recompose(double[][] matDeComp, int level) throws JWaveException {
        double[] arrTime = null;
        try {
            arrTime = this.recompose(matDeComp, level);
        }
        catch (JWaveFailure e) {
            e.showMessage();
            e.printStackTrace();
        }
        return arrTime;
    }

    public Complex[] forward(Complex[] arrTime) throws JWaveException {
        double[] arrTimeBulk = new double[2 * arrTime.length];
        for (int i = 0; i < arrTime.length; ++i) {
            int k = i * 2;
            arrTimeBulk[k] = arrTime[i].getReal();
            arrTimeBulk[k + 1] = arrTime[i].getImag();
        }
        double[] arrHilbBulk = this.forward(arrTimeBulk);
        Complex[] arrHilb = new Complex[arrTime.length];
        for (int i = 0; i < arrTime.length; ++i) {
            int k = i * 2;
            arrHilb[i] = new Complex(arrHilbBulk[k], arrHilbBulk[k + 1]);
        }
        return arrHilb;
    }

    public Complex[] reverse(Complex[] arrHilb) throws JWaveException {
        double[] arrHilbBulk = new double[2 * arrHilb.length];
        for (int i = 0; i < arrHilb.length; ++i) {
            int k = i * 2;
            arrHilbBulk[k] = arrHilb[i].getReal();
            arrHilbBulk[k + 1] = arrHilb[i].getImag();
        }
        double[] arrTimeBulk = this.reverse(arrHilbBulk);
        Complex[] arrTime = new Complex[arrHilb.length];
        for (int i = 0; i < arrTime.length; ++i) {
            int k = i * 2;
            arrTime[i] = new Complex(arrTimeBulk[k], arrTimeBulk[k + 1]);
        }
        return arrTime;
    }

    public double[][] forward(double[][] matTime) throws JWaveException {
        int maxM = MathToolKit.getExponent(matTime.length);
        int maxN = MathToolKit.getExponent(matTime[0].length);
        return this.forward(matTime, maxM, maxN);
    }

    public double[][] forward(double[][] matTime, int lvlM, int lvlN) throws JWaveException {
        double[] arrHilb;
        double[] arrTime;
        int noOfRows = matTime.length;
        int noOfCols = matTime[0].length;
        double[][] matHilb = new double[noOfRows][noOfCols];
        for (int i = 0; i < noOfRows; ++i) {
            arrTime = new double[noOfCols];
            for (int j = 0; j < noOfCols; ++j) {
                arrTime[j] = matTime[i][j];
            }
            arrHilb = this.forward(arrTime, lvlN);
            for (int j = 0; j < noOfCols; ++j) {
                matHilb[i][j] = arrHilb[j];
            }
        }
        for (int j = 0; j < noOfCols; ++j) {
            arrTime = new double[noOfRows];
            for (int i = 0; i < noOfRows; ++i) {
                arrTime[i] = matHilb[i][j];
            }
            arrHilb = this.forward(arrTime, lvlM);
            for (int i = 0; i < noOfRows; ++i) {
                matHilb[i][j] = arrHilb[i];
            }
        }
        return matHilb;
    }

    public double[][] reverse(double[][] matFreq) throws JWaveException {
        int maxM = MathToolKit.getExponent(matFreq.length);
        int maxN = MathToolKit.getExponent(matFreq[0].length);
        return this.reverse(matFreq, maxM, maxN);
    }

    public double[][] reverse(double[][] matFreq, int lvlM, int lvlN) throws JWaveException {
        double[] arrTime;
        double[] arrFreq;
        int noOfRows = matFreq.length;
        int noOfCols = matFreq[0].length;
        double[][] matTime = new double[noOfRows][noOfCols];
        for (int j = 0; j < noOfCols; ++j) {
            arrFreq = new double[noOfRows];
            for (int i = 0; i < noOfRows; ++i) {
                arrFreq[i] = matFreq[i][j];
            }
            arrTime = this.reverse(arrFreq, lvlM);
            for (int i = 0; i < noOfRows; ++i) {
                matTime[i][j] = arrTime[i];
            }
        }
        for (int i = 0; i < noOfRows; ++i) {
            arrFreq = new double[noOfCols];
            for (int j = 0; j < noOfCols; ++j) {
                arrFreq[j] = matTime[i][j];
            }
            arrTime = this.reverse(arrFreq, lvlN);
            for (int j = 0; j < noOfCols; ++j) {
                matTime[i][j] = arrTime[j];
            }
        }
        return matTime;
    }

    public double[][][] forward(double[][][] spcTime) throws JWaveException {
        int maxP = MathToolKit.getExponent(spcTime.length);
        int maxQ = MathToolKit.getExponent(spcTime[0].length);
        int maxR = MathToolKit.getExponent(spcTime[0][0].length);
        return this.forward(spcTime, maxP, maxQ, maxR);
    }

    public double[][][] forward(double[][][] spcTime, int lvlP, int lvlQ, int lvlR) throws JWaveException {
        int noOfRows = spcTime.length;
        int noOfCols = spcTime[0].length;
        int noOfHigh = spcTime[0][0].length;
        double[][][] spcHilb = new double[noOfRows][noOfCols][noOfHigh];
        for (int i = 0; i < noOfRows; ++i) {
            double[][] matTime = new double[noOfCols][noOfHigh];
            for (int j = 0; j < noOfCols; ++j) {
                for (int k = 0; k < noOfHigh; ++k) {
                    matTime[j][k] = spcTime[i][j][k];
                }
            }
            double[][] matHilb = this.forward(matTime, lvlP, lvlQ);
            for (int j = 0; j < noOfCols; ++j) {
                for (int k = 0; k < noOfHigh; ++k) {
                    spcHilb[i][j][k] = matHilb[j][k];
                }
            }
        }
        for (int j = 0; j < noOfCols; ++j) {
            for (int k = 0; k < noOfHigh; ++k) {
                double[] arrTime = new double[noOfRows];
                for (int i = 0; i < noOfRows; ++i) {
                    arrTime[i] = spcHilb[i][j][k];
                }
                double[] arrHilb = this.forward(arrTime, lvlR);
                for (int i = 0; i < noOfRows; ++i) {
                    spcHilb[i][j][k] = arrHilb[i];
                }
            }
        }
        return spcHilb;
    }

    public double[][][] reverse(double[][][] spcHilb) throws JWaveException {
        int maxP = MathToolKit.getExponent(spcHilb.length);
        int maxQ = MathToolKit.getExponent(spcHilb[0].length);
        int maxR = MathToolKit.getExponent(spcHilb[0][0].length);
        return this.reverse(spcHilb, maxP, maxQ, maxR);
    }

    public double[][][] reverse(double[][][] spcHilb, int lvlP, int lvlQ, int lvlR) throws JWaveException {
        int noOfRows = spcHilb.length;
        int noOfCols = spcHilb[0].length;
        int noOfHigh = spcHilb[0][0].length;
        double[][][] spcTime = new double[noOfRows][noOfCols][noOfHigh];
        for (int i = 0; i < noOfRows; ++i) {
            double[][] matHilb = new double[noOfCols][noOfHigh];
            for (int j = 0; j < noOfCols; ++j) {
                for (int k = 0; k < noOfHigh; ++k) {
                    matHilb[j][k] = spcHilb[i][j][k];
                }
            }
            double[][] matTime = this.reverse(matHilb, lvlP, lvlQ);
            for (int j = 0; j < noOfCols; ++j) {
                for (int k = 0; k < noOfHigh; ++k) {
                    spcTime[i][j][k] = matTime[j][k];
                }
            }
        }
        for (int j = 0; j < noOfCols; ++j) {
            for (int k = 0; k < noOfHigh; ++k) {
                double[] arrHilb = new double[noOfRows];
                for (int i = 0; i < noOfRows; ++i) {
                    arrHilb[i] = spcTime[i][j][k];
                }
                double[] arrTime = this.reverse(arrHilb, lvlR);
                for (int i = 0; i < noOfRows; ++i) {
                    spcTime[i][j][k] = arrTime[i];
                }
            }
        }
        return spcTime;
    }

    protected boolean isBinary(int number) {
        return MathToolKit.isBinary(number);
    }

    protected int calcExponent(int number) throws JWaveException {
        if (!this.isBinary(number)) {
            throw new JWaveFailure("BasicTransform#calcExponent - given number is not binary: 2^p | p\u20acN .. = 1, 2, 4, 8, 16, 32, .. ");
        }
        return MathToolKit.getExponent(number);
    }
}

