/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms.wavelets.biorthogonal;

import jwave.transforms.wavelets.Wavelet;

public class BiOrthogonal
extends Wavelet {
    protected void _buildBiOrthonormalSpace() {
        this._scalingReCon = new double[this._motherWavelength];
        this._waveletReCon = new double[this._motherWavelength];
        for (int i = 0; i < this._motherWavelength; ++i) {
            if (i % 2 == 0) {
                this._scalingReCon[i] = -this._waveletDeCom[i];
                this._waveletReCon[i] = -this._scalingDeCom[i];
                continue;
            }
            this._scalingReCon[i] = this._waveletDeCom[i];
            this._waveletReCon[i] = this._scalingDeCom[i];
        }
    }

    @Override
    public double[] forward(double[] arrTime, int arrTimeLength) {
        double[] arrHilb = new double[arrTimeLength];
        int h = arrHilb.length >> 1;
        for (int i = 0; i < h; ++i) {
            arrHilb[i + h] = 0.0;
            arrHilb[i] = 0.0;
            for (int j = 0; j < this._motherWavelength; ++j) {
                int k;
                for (k = (i << 1) + j; k >= arrHilb.length; k -= arrHilb.length) {
                }
                int n = i;
                arrHilb[n] = arrHilb[n] + arrTime[k] * this._scalingDeCom[j];
                int n2 = i + h;
                arrHilb[n2] = arrHilb[n2] + arrTime[k] * this._waveletDeCom[j];
            }
        }
        return arrHilb;
    }

    @Override
    public double[] reverse(double[] arrHilb, int arrHilbLength) {
        double[] arrTime = new double[arrHilbLength];
        for (int i = 0; i < arrTime.length; ++i) {
            arrTime[i] = 0.0;
        }
        int h = arrTime.length >> 1;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < this._motherWavelength; ++j) {
                int k;
                for (k = (i << 1) + j; k >= arrTime.length; k -= arrTime.length) {
                }
                int n = k;
                arrTime[n] = arrTime[n] + (arrHilb[i] * this._scalingReCon[j] + arrHilb[i + h] * this._waveletReCon[j]);
            }
        }
        return arrTime;
    }
}

