/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms.wavelets.daubechies;

import jwave.transforms.wavelets.Wavelet;

public class Daubechies3
extends Wavelet {
    public Daubechies3() {
        this._name = "Daubechies 3";
        this._transformWavelength = 2;
        this._motherWavelength = 6;
        this._scalingDeCom = new double[this._motherWavelength];
        double sqrt10 = Math.sqrt(10.0);
        double constA = Math.sqrt(5.0 + 2.0 * sqrt10);
        this._scalingDeCom[0] = (1.0 + 1.0 * sqrt10 + 1.0 * constA) / 16.0;
        this._scalingDeCom[1] = (5.0 + 1.0 * sqrt10 + 3.0 * constA) / 16.0;
        this._scalingDeCom[2] = (10.0 - 2.0 * sqrt10 + 2.0 * constA) / 16.0;
        this._scalingDeCom[3] = (10.0 - 2.0 * sqrt10 - 2.0 * constA) / 16.0;
        this._scalingDeCom[4] = (5.0 + 1.0 * sqrt10 - 3.0 * constA) / 16.0;
        this._scalingDeCom[5] = (1.0 + 1.0 * sqrt10 - 1.0 * constA) / 16.0;
        double sqrt02 = Math.sqrt(2.0);
        int i = 0;
        while (i < this._motherWavelength) {
            int n = i++;
            this._scalingDeCom[n] = this._scalingDeCom[n] / sqrt02;
        }
        this._buildOrthonormalSpace();
    }
}

