/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.hac;

import org.opencompare.hac.ClusteringBuilder;

public final class ClusteringMatrixBuilder
implements ClusteringBuilder {
    private static final int INVALID = -1;
    private final int[][] clustering;
    private int currentStep;

    public ClusteringMatrixBuilder(int nObservations) {
        int nSteps = nObservations;
        this.clustering = new int[nSteps][nObservations];
        for (int observation = 0; observation < nObservations; ++observation) {
            this.clustering[0][observation] = observation;
            for (int step = 1; step < nSteps; ++step) {
                this.clustering[step][observation] = -1;
            }
        }
        this.currentStep = 0;
    }

    public void merge(int i, int j, double dissimilarity) {
        int previousStep = this.currentStep++;
        for (int observation = 0; observation < this.clustering.length; ++observation) {
            int previousCluster = this.clustering[previousStep][observation];
            this.clustering[this.currentStep][observation] = previousCluster == j ? i : previousCluster;
        }
    }

    public int[][] getClustering() {
        return this.clustering;
    }
}

