/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.hac.dendrogram;

import org.opencompare.hac.dendrogram.DendrogramNode;
import org.opencompare.hac.dendrogram.MergeNode;
import org.opencompare.hac.dendrogram.ObservationNode;

public final class Dendrogram {
    private final DendrogramNode root;

    public Dendrogram(DendrogramNode root) {
        this.root = root;
    }

    public DendrogramNode getRoot() {
        return this.root;
    }

    public void dump() {
        this.dumpNode("  ", this.root);
    }

    private void dumpNode(String indent, DendrogramNode node) {
        if (node == null) {
            System.out.println(indent + "<null>");
        } else if (node instanceof ObservationNode) {
            System.out.println(indent + "Observation: " + node);
        } else if (node instanceof MergeNode) {
            System.out.println(indent + "Merge:");
            this.dumpNode(indent + "  ", ((MergeNode)node).getLeft());
            this.dumpNode(indent + "  ", ((MergeNode)node).getRight());
        }
    }
}

