/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.hac.dendrogram;

import org.opencompare.hac.ClusteringBuilder;
import org.opencompare.hac.dendrogram.Dendrogram;
import org.opencompare.hac.dendrogram.DendrogramNode;
import org.opencompare.hac.dendrogram.MergeNode;
import org.opencompare.hac.dendrogram.ObservationNode;

public final class DendrogramBuilder
implements ClusteringBuilder {
    private final DendrogramNode[] nodes;
    private MergeNode lastMergeNode;

    public DendrogramBuilder(int nObservations) {
        this.nodes = new DendrogramNode[nObservations];
        for (int i = 0; i < nObservations; ++i) {
            this.nodes[i] = new ObservationNode(i);
        }
    }

    public final void merge(int i, int j, double dissimilarity) {
        MergeNode node = new MergeNode(this.nodes[i], this.nodes[j], dissimilarity);
        this.nodes[i] = node;
        this.lastMergeNode = node;
    }

    public final Dendrogram getDendrogram() {
        if (this.nodes.length == 1) {
            return new Dendrogram(this.nodes[0]);
        }
        return new Dendrogram(this.lastMergeNode);
    }
}

