/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.datatypes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import umich.ms.datatypes.scan.IScan;
import umich.ms.util.DoubleRange;

public class LCMSDataSubset
implements Serializable {
    public static final LCMSDataSubset WHOLE_RUN = new LCMSDataSubset();
    public static final LCMSDataSubset MS1_WITH_SPECTRA;
    public static final LCMSDataSubset MS2_WITH_SPECTRA;
    public static final LCMSDataSubset STRUCTURE_ONLY;
    private static final long serialVersionUID = 7992060642981830599L;
    Integer scanNumLo;
    Integer scanNumHi;
    Set<Integer> msLvls;
    List<DoubleRange> mzRanges;
    private volatile int hashCode;

    public LCMSDataSubset() {
        this.scanNumLo = null;
        this.scanNumHi = null;
        this.msLvls = null;
        this.mzRanges = null;
    }

    public LCMSDataSubset(Integer scanNumLo, Integer scanNumHi, Set<Integer> msLvls, List<DoubleRange> mzRanges) {
        this.scanNumLo = scanNumLo;
        this.scanNumHi = scanNumHi;
        this.msLvls = msLvls;
        this.mzRanges = mzRanges;
    }

    public Integer getScanNumLo() {
        return this.scanNumLo;
    }

    public void setScanNumLo(Integer scanNumLo) {
        this.scanNumLo = scanNumLo;
    }

    public Integer getScanNumHi() {
        return this.scanNumHi;
    }

    public void setScanNumHi(Integer scanNumHi) {
        this.scanNumHi = scanNumHi;
    }

    public Set<Integer> getMsLvls() {
        return this.msLvls;
    }

    public void setMsLvls(Set<Integer> msLvls) {
        this.msLvls = msLvls;
    }

    public List<DoubleRange> getMzRanges() {
        return this.mzRanges;
    }

    public void setMzRanges(List<DoubleRange> mzRanges) {
        this.mzRanges = mzRanges;
    }

    public boolean isInSubset(IScan scan) {
        int num = scan.getNum();
        if (this.scanNumLo != null && num < this.scanNumLo) {
            return false;
        }
        if (this.scanNumHi != null && num > this.scanNumHi) {
            return false;
        }
        Integer msLevel = scan.getMsLevel();
        if (this.msLvls != null && !this.msLvls.contains(msLevel)) {
            return false;
        }
        if (this.mzRanges != null) {
            DoubleRange range;
            if (msLevel == 1) {
                if (scan.getScanMzWindowLower() == null || scan.getScanMzWindowUpper() == null) {
                    throw new IllegalStateException(String.format("Could not check if scan #%d (MS%d) is in LCMSDataSubset, as lower/upper m/z range was not present in the scan.", num, msLevel));
                }
                range = new DoubleRange(scan.getScanMzWindowLower(), scan.getScanMzWindowUpper());
            } else {
                if (scan.getPrecursor() == null) {
                    throw new IllegalStateException(String.format("Could not check if scan #%d (MS%d) is in LCMSDataSubset, as precursor info was not present in the scan.", num, msLevel));
                }
                range = new DoubleRange(scan.getPrecursor().getMzRangeStart(), scan.getPrecursor().getMzRangeEnd());
            }
            for (DoubleRange listedRange : this.mzRanges) {
                if (!(range.overlapRelative(listedRange) < 0.5)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean contains(LCMSDataSubset other) {
        Set<Integer> msLvlsThis = this.getMsLvls();
        Set<Integer> msLvlsThat = other.getMsLvls();
        if (msLvlsThis != null && msLvlsThat != null && !msLvlsThis.containsAll(msLvlsThat)) {
            return false;
        }
        List<DoubleRange> mzRangesThis = this.getMzRanges();
        List<DoubleRange> mzRangesThat = other.getMzRanges();
        if (mzRangesThis != null && mzRangesThat != null && !mzRangesThis.containsAll(mzRangesThat)) {
            return false;
        }
        Integer scanNumLoThis = this.getScanNumLo();
        Integer scanNumLoThat = other.getScanNumLo();
        if (scanNumLoThis != null && scanNumLoThat != null && scanNumLoThis > scanNumLoThat) {
            return false;
        }
        Integer scanNumHiThis = this.getScanNumHi();
        Integer scanNumHiThat = other.getScanNumHi();
        return scanNumHiThis == null || scanNumHiThat == null || scanNumHiThis >= scanNumHiThat;
    }

    public LCMSDataSubset merge(LCMSDataSubset other) {
        LCMSDataSubset merged = new LCMSDataSubset();
        Set<Integer> msLvlsThis = this.getMsLvls();
        Set<Integer> msLvlsThat = other.getMsLvls();
        if (msLvlsThis != null && msLvlsThat != null) {
            HashSet<Integer> mergedMsLvls = new HashSet<Integer>(msLvlsThis);
            mergedMsLvls.addAll(msLvlsThat);
            merged.setMsLvls(mergedMsLvls);
        }
        List<DoubleRange> mzRangesThis = this.getMzRanges();
        List<DoubleRange> mzRangesThat = other.getMzRanges();
        if (mzRangesThis != null && mzRangesThat != null) {
            ArrayList<DoubleRange> mergedMzRanges = new ArrayList<DoubleRange>(mzRangesThis);
            mergedMzRanges.addAll(mzRangesThat);
            merged.setMzRanges(mergedMzRanges);
        }
        Integer scanNumLoThis = this.getScanNumLo();
        Integer scanNumLoThat = other.getScanNumLo();
        if (scanNumLoThis != null && scanNumLoThat != null) {
            merged.setScanNumLo(Math.min(scanNumLoThis, scanNumLoThat));
        }
        Integer scanNumHiThis = this.getScanNumHi();
        Integer scanNumHiThat = other.getScanNumHi();
        if (scanNumHiThis != null && scanNumHiThat != null) {
            merged.setScanNumHi(Math.max(scanNumHiThis, scanNumHiThat));
        }
        return merged;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LCMSDataSubset)) {
            return false;
        }
        LCMSDataSubset that = (LCMSDataSubset)o;
        if (this.msLvls != null ? !this.msLvls.equals(that.msLvls) : that.msLvls != null) {
            return false;
        }
        if (this.mzRanges != null ? !this.mzRanges.equals(that.mzRanges) : that.mzRanges != null) {
            return false;
        }
        if (this.scanNumHi != null ? !this.scanNumHi.equals(that.scanNumHi) : that.scanNumHi != null) {
            return false;
        }
        return !(this.scanNumLo != null ? !this.scanNumLo.equals(that.scanNumLo) : that.scanNumLo != null);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (this.hashCode == 0) {
            result = 7;
            result = 41 * result + (this.scanNumLo != null ? this.scanNumLo.hashCode() : -1073741824);
            result = 41 * result + (this.scanNumHi != null ? this.scanNumHi.hashCode() : -715827882);
            result = 41 * result + (this.msLvls != null ? this.msLvls.hashCode() : -536870912);
            result = 41 * result + (this.mzRanges != null ? this.mzRanges.hashCode() : -429496729);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{MS-Lvls: ");
        sb = this.msLvls == null ? sb.append("any") : sb.append(Arrays.toString(this.msLvls.toArray()));
        sb.append(", ScanNumRange: ");
        sb = this.scanNumLo == null ? sb.append("any") : sb.append(this.scanNumLo);
        sb.append(" - ");
        sb = this.scanNumHi == null ? sb.append("any") : sb.append(this.scanNumHi);
        sb.append(", Precursors: ");
        sb = this.mzRanges == null ? sb.append("any") : sb.append(Arrays.toString(this.mzRanges.toArray()));
        sb.append("}");
        return sb.toString();
    }

    static {
        HashSet<Integer> msLvls1 = new HashSet<Integer>(1);
        msLvls1.add(1);
        MS1_WITH_SPECTRA = new LCMSDataSubset(null, null, msLvls1, null);
        HashSet<Integer> msLvls2 = new HashSet<Integer>(1);
        msLvls2.add(2);
        MS2_WITH_SPECTRA = new LCMSDataSubset(null, null, msLvls2, null);
        Set<Integer> msLvlsEmpty = Collections.emptySet();
        STRUCTURE_ONLY = new LCMSDataSubset(null, null, msLvlsEmpty, null);
    }
}

