/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.datatypes;

import com.google.common.collect.Range;
import java.io.Serializable;
import umich.ms.util.DoubleRange;

public class LCMSRange
implements Serializable {
    public static final Range<Integer> FULL_SCAN_RANGE = Range.closed((Comparable)Integer.valueOf(Integer.MIN_VALUE), (Comparable)Integer.valueOf(Integer.MAX_VALUE));
    public static final LCMSRange WHOLE_RUN = new LCMSRange();
    public static final LCMSRange WHOLE_RUN_MS1 = new LCMSRange(FULL_SCAN_RANGE, 1, null);
    public static final LCMSRange WHOLE_RUN_MS2 = new LCMSRange(FULL_SCAN_RANGE, 2, null);
    public static final LCMSRange WHOLE_RUN_STRUCTURE = new LCMSRange(FULL_SCAN_RANGE, -1, null);
    private static final long serialVersionUID = 1931602507383305152L;
    private final Range<Integer> scanRange;
    private final Integer msLevel;
    private final DoubleRange mzRange;

    protected LCMSRange() {
        this.scanRange = FULL_SCAN_RANGE;
        this.msLevel = null;
        this.mzRange = null;
    }

    protected LCMSRange(Range<Integer> scanRange, Integer msLevel, DoubleRange mzRange) {
        if (scanRange == null) {
            throw new IllegalArgumentException("scanRange can't be null, if you want to cover all scans, use LCMSRange.FULL_SCAN_RANGE");
        }
        if (msLevel == null && mzRange != null) {
            throw new IllegalArgumentException("If you provide a non-null mzRange, you must provide an msLevel as well.");
        }
        this.scanRange = scanRange;
        this.msLevel = msLevel;
        this.mzRange = mzRange;
    }

    public static final LCMSRange create() {
        return WHOLE_RUN;
    }

    public static final LCMSRange create(Range<Integer> scanRange) {
        return new LCMSRange(scanRange, null, null);
    }

    public static final LCMSRange create(Range<Integer> scanRange, Integer msLevel) {
        return new LCMSRange(scanRange, msLevel, null);
    }

    public static final LCMSRange create(Range<Integer> scanRange, Integer msLevel, DoubleRange mzRange) {
        return new LCMSRange(scanRange, msLevel, mzRange);
    }

    public Range<Integer> getScanRange() {
        return this.scanRange;
    }

    public Integer getMsLevel() {
        return this.msLevel;
    }

    public DoubleRange getMzRange() {
        return this.mzRange;
    }
}

