/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.datatypes.scan;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import umich.ms.datatypes.spectrum.ISpectrum;
import umich.ms.util.StrongReference;

public enum StorageStrategy {
    STRONG(StrongReference.class, new SpecRefBuilder(){

        @Override
        public Reference<ISpectrum> build(ISpectrum spec) {
            return new StrongReference<ISpectrum>(spec);
        }
    }),
    SOFT(SoftReference.class, new SpecRefBuilder(){

        @Override
        public Reference<ISpectrum> build(ISpectrum spec) {
            return new SoftReference<ISpectrum>(spec);
        }
    }),
    WEAK(WeakReference.class, new SpecRefBuilder(){

        @Override
        public Reference<ISpectrum> build(ISpectrum spec) {
            return new WeakReference<ISpectrum>(spec);
        }
    });

    private final Class<? extends Reference> refType;
    private final SpecRefBuilder builder;

    private StorageStrategy(Class<? extends Reference> refType, SpecRefBuilder builder) {
        this.refType = refType;
        this.builder = builder;
    }

    public Reference<ISpectrum> getRef(ISpectrum spec) {
        return this.builder.build(spec);
    }

    private static abstract class SpecRefBuilder {
        private SpecRefBuilder() {
        }

        public abstract Reference<ISpectrum> build(ISpectrum var1);
    }
}

