/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.datatypes.scan.props;

import umich.ms.fileio.filetypes.mzml.util.PSIMSCV;
import umich.ms.util.StringUtils;

public enum ScanType {
    UNKNOWN("Unknown"),
    FULL("Full"),
    SIM("SIM"),
    SRM("SRM"),
    CRM("CRM"),
    MRM("MRM"),
    ZOOM("Zoom"),
    Q1("Q1"),
    Q3("Q3");

    public String name;

    private ScanType(String name) {
        this.name = name;
    }

    public static ScanType fromString(String name) {
        if (name == null) {
            return null;
        }
        ScanType type = StringUtils.getEnumFromString(ScanType.class, name);
        return type != null ? type : UNKNOWN;
    }

    public static ScanType fromPSIMSOntology(String psiMsTermNumber) {
        if (psiMsTermNumber == null) {
            return null;
        }
        if (psiMsTermNumber.equalsIgnoreCase(PSIMSCV.MS_SCAN_TYPE_FULL.accession)) {
            return FULL;
        }
        if (psiMsTermNumber.equalsIgnoreCase(PSIMSCV.MS_SCAN_TYPE_SIM.accession)) {
            return SIM;
        }
        if (psiMsTermNumber.equalsIgnoreCase(PSIMSCV.MS_SCAN_TYPE_SRM.accession)) {
            return SRM;
        }
        if (psiMsTermNumber.equalsIgnoreCase(PSIMSCV.MS_SCAN_TYPE_ZOOM.accession)) {
            return ZOOM;
        }
        if (psiMsTermNumber.equalsIgnoreCase(PSIMSCV.MS_SCAN_TYPE_CRM.accession)) {
            return CRM;
        }
        return UNKNOWN;
    }
}

