/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzxml.example;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.TreeMap;
import umich.ms.datatypes.LCMSDataSubset;
import umich.ms.datatypes.scan.IScan;
import umich.ms.datatypes.scan.StorageStrategy;
import umich.ms.datatypes.scancollection.impl.ScanCollectionDefault;
import umich.ms.datatypes.spectrum.ISpectrum;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.mzxml.MZXMLFile;

public class Example3 {
    public static void main(String[] args) throws FileParsingException {
        Path path = Paths.get("some-path-to.mzXML", new String[0]);
        path = Paths.get(args[0], new String[0]);
        MZXMLFile source = new MZXMLFile(path.toString());
        ScanCollectionDefault scans = new ScanCollectionDefault();
        scans.setDefaultStorageStrategy(StorageStrategy.SOFT);
        scans.isAutoloadSpectra(true);
        scans.setDataSource(source);
        source.setNumThreadsForParsing(null);
        scans.loadData(LCMSDataSubset.MS1_WITH_SPECTRA);
        TreeMap<Integer, IScan> num2scanMap = scans.getMapNum2scan();
        for (IScan scan : num2scanMap.values()) {
            ISpectrum spectrum = scan.getSpectrum();
            if (spectrum == null) {
                System.out.printf("%s does NOT have a parsed spectrum\n", scan.toString());
                continue;
            }
            System.out.printf("%s has a parsed spectrum, it contains %d data points\n", scan.toString(), spectrum.getMZs().length);
        }
    }
}

