/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzxml.example;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import umich.ms.datatypes.LCMSData;
import umich.ms.datatypes.LCMSDataSubset;
import umich.ms.datatypes.lcmsrun.LCMSRunInfo;
import umich.ms.datatypes.scan.IScan;
import umich.ms.datatypes.scan.StorageStrategy;
import umich.ms.datatypes.scancollection.IScanCollection;
import umich.ms.datatypes.scancollection.ScanIndex;
import umich.ms.datatypes.spectrum.ISpectrum;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.mzxml.MZXMLFile;
import umich.ms.fileio.filetypes.mzxml.MZXMLIndex;

public class Example4 {
    public static void main(String[] args) throws FileParsingException {
        Path path = Paths.get("some-path-to.mzXML", new String[0]);
        path = Paths.get(args[0], new String[0]);
        MZXMLFile source = new MZXMLFile(path.toString());
        MZXMLIndex idx = source.fetchIndex();
        LCMSRunInfo runInfo = source.fetchRunInfo();
        Set<Integer> msLevel = Collections.singleton(2);
        LCMSDataSubset subset = new LCMSDataSubset(1, 3, msLevel, null);
        List<IScan> parsedScans = source.parse(subset);
        LCMSData data = new LCMSData(source);
        data.load(LCMSDataSubset.WHOLE_RUN);
        data.releaseMemory();
        data.load(new LCMSDataSubset(null, null, msLevel, null));
        data.releaseMemory();
        data.load(LCMSDataSubset.MS2_WITH_SPECTRA);
        data.releaseMemory();
        Object dataUser = new Object();
        data.load(LCMSDataSubset.WHOLE_RUN, dataUser);
        System.out.printf("The data is loaded and used by [%s] object.\n", System.identityHashCode(dataUser));
        dataUser = null;
        data.load(LCMSDataSubset.STRUCTURE_ONLY);
        IScanCollection scans = data.getScans();
        scans.isAutoloadSpectra(true);
        scans.setDefaultStorageStrategy(StorageStrategy.SOFT);
        TreeMap<Integer, ScanIndex> msLevel2index = scans.getMapMsLevel2index();
        ScanIndex ms2idx = msLevel2index.get(2);
        TreeMap<Integer, IScan> num2scan = ms2idx.getNum2scan();
        Set<Map.Entry<Integer, IScan>> scanEntries = num2scan.entrySet();
        for (Map.Entry<Integer, IScan> scanEntry : scanEntries) {
            Integer scanNum = scanEntry.getKey();
            IScan scan = scanEntry.getValue();
            ISpectrum spectrum = scan.fetchSpectrum();
            int scanNumInternal = scan.getNum();
            Object idxElem = idx.getByNum(scanNumInternal);
            int scanNumRaw = idxElem.getRawNumber();
            int numPoints = spectrum.getMZs().length;
            System.out.printf("Scan #%d (raw #%d) contained %d data points\n", scanNumInternal, scanNumRaw, numPoints);
        }
        Integer firstMS2ScanNum = scans.getMapMsLevel2index().get(2).getNum2scan().firstKey();
        IScan scan = scans.getScanByNum(firstMS2ScanNum);
        scan = scans.getNextScanAtSameMsLevel(scan);
        String parentScanRef = scan.getPrecursor().getParentScanRefRaw();
        System.out.printf("Scan #%d (MS%d) is a child scan of {%s}\n", scan.getNum(), scan.getMsLevel(), parentScanRef);
        data.releaseMemory();
    }
}

