/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.util.base64;

import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.util.ByteArrayHolder;

public class Base64Context {
    int ibitWorkArea;
    long lbitWorkArea;
    ByteArrayHolder bytesHolder;
    int pos;
    int readPos;
    boolean eof;
    int currentLinePos;
    int modulus;

    public String toString() {
        return String.format("%s[currentLinePos=%s, eof=%s, ibitWorkArea=%s, lbitWorkArea=%s, modulus=%s, pos=%s, readPos=%s]", this.getClass().getSimpleName(), this.currentLinePos, this.eof, this.ibitWorkArea, this.lbitWorkArea, this.modulus, this.pos, this.readPos);
    }

    public byte[] ensureBufferHasCapacityLeft(int size) throws FileParsingException {
        if (this.bytesHolder == null) {
            this.bytesHolder = new ByteArrayHolder(size);
        } else {
            this.bytesHolder.ensureHasSpace(size);
        }
        return this.bytesHolder.getUnderlyingBytes();
    }

    public void syncBufferPos() {
        if (this.bytesHolder != null) {
            this.bytesHolder.setPosition(this.pos);
        }
    }

    protected int available() {
        return this.bytesHolder != null ? this.pos - this.readPos : 0;
    }

    public ByteArrayHolder readResults() {
        if (this.bytesHolder != null) {
            this.syncBufferPos();
            return this.bytesHolder;
        }
        return null;
    }

    public void close() throws FileParsingException {
    }
}

