/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.processing.ChromatogramAnnotator;
import fr.proline.mzscope.processing.IAnnotator;
import fr.proline.mzscope.processing.PeakelAnnotator;
import fr.proline.studio.gui.DefaultDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class BatchExtractionDialog
extends DefaultDialog {
    private JComboBox<String> m_annotatorCbx;

    public BatchExtractionDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Batch extraction");
        this.setHelpHeaderText("The list of mz or (mz,rt) pairs of the extraction table will be extracted <br> from all open raw files. If no rt is provided then the extraction reports <br>only the chromatogram max intensity. If rt values are provided, the extracted <br>chromatograms will be annotated by the following annotators: <br><ul> <li>peakel detection: detect peakels then match peakels by (mz,rt,z).</li><li>basic: simply search for non-null intensities before and after the specified rt.</li></ul>");
        this.initInternalPanel();
        this.pack();
    }

    private void initInternalPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        JLabel label = new JLabel("Annotator: ");
        panel.add((Component)label, c);
        this.m_annotatorCbx = new JComboBox<String>(new String[]{"basic", "peakel detection"});
        ++c.gridx;
        panel.add(this.m_annotatorCbx, c);
        this.setInternalComponent(panel);
    }

    public IAnnotator getAnnotator() {
        return this.m_annotatorCbx.getSelectedItem().equals("peakel detection") ? new PeakelAnnotator() : new ChromatogramAnnotator();
    }
}

