/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.model.Signal;
import fr.proline.mzscope.ui.SignalWrapper;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.PlotBaseAbstract;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.PlotPanel;
import fr.proline.studio.graphics.PlotStick;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(SignalPanel.class);
    protected final PlotPanel m_plotPanel;
    protected final PlotXYAbstract m_linear;
    protected final Signal m_signal;

    public SignalPanel(Signal signal) {
        this.m_signal = signal;
        this.m_plotPanel = new PlotPanel();
        BasePlotPanel basePlot = this.m_plotPanel.getBasePlotPanel();
        basePlot.setPlotTitle("2d signal");
        basePlot.setDrawCursor(true);
        SignalWrapper wrappedSignal = new SignalWrapper(this.m_signal, "original signal", CyclicColorPalette.getColor((int)1));
        if (signal.getSignalType() == 0) {
            this.m_linear = new PlotLinear(basePlot, (ExtendedTableModelInterface)wrappedSignal, null, 0, 1);
            ((PlotLinear)this.m_linear).setPlotInformation(wrappedSignal.getPlotInformation());
            ((PlotLinear)this.m_linear).setStrokeFixed(true);
            ((PlotLinear)this.m_linear).setAntiAliasing(true);
        } else {
            this.m_linear = new PlotStick(basePlot, (ExtendedTableModelInterface)wrappedSignal, null, 0, 1);
            ((PlotStick)this.m_linear).setStrokeFixed(true);
            ((PlotStick)this.m_linear).setPlotInformation(wrappedSignal.getPlotInformation());
        }
        basePlot.setPlot((PlotBaseAbstract)this.m_linear);
        this.setLayout(new BorderLayout());
        JToolBar toolbar = this.createToolBar();
        this.add((Component)this.m_plotPanel, "Center");
        this.add((Component)toolbar, "North");
        this.setPreferredSize(new Dimension(300, 500));
    }

    protected JToolBar createToolBar() {
        return new JToolBar();
    }
}

