/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.dialog;

import fr.proline.mzscope.ui.model.MzScopePreferences;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

class MS1MzBoundsPanel
extends JPanel {
    private JPanel noBoundsPanel;
    private JRadioButton noBoundsRB;
    private JPanel mzBoundsPanel;
    private JRadioButton mzBoundsRB;
    private JTextField maxMzTF;
    private JTextField minMzTF;
    private JPanel mzPanel;
    private JRadioButton mzRB;
    private JTextField mzTF;
    private JPanel tolerancePanel;
    private JTextField toleranceTF;

    public MS1MzBoundsPanel(String title) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new TitledBorder(title));
        this.add(this.getTolerancePanel());
        this.add(this.getNoBoundsPanel());
        this.add(this.getMassBoundsPanel());
        this.add(this.getMassPanel());
        ButtonGroup group = new ButtonGroup();
        group.add(this.noBoundsRB);
        group.add(this.mzBoundsRB);
        group.add(this.mzRB);
    }

    private JPanel getTolerancePanel() {
        if (this.tolerancePanel == null) {
            this.tolerancePanel = new JPanel();
            this.tolerancePanel.setLayout(new FlowLayout(0));
            JLabel toleranceLabel = new JLabel();
            toleranceLabel.setText("m/z tolerance (ppm):");
            this.tolerancePanel.add(toleranceLabel);
            this.tolerancePanel.add(this.getToleranceTF());
        }
        return this.tolerancePanel;
    }

    JTextField getToleranceTF() {
        if (this.toleranceTF == null) {
            this.toleranceTF = new JTextField();
            this.toleranceTF.setColumns(5);
            this.toleranceTF.setToolTipText("Tolerance in ppm");
            this.toleranceTF.setText(Float.toString(MzScopePreferences.getInstance().getMzPPMTolerance()));
        }
        return this.toleranceTF;
    }

    private JPanel getNoBoundsPanel() {
        if (this.noBoundsPanel == null) {
            this.noBoundsPanel = new JPanel();
            this.noBoundsPanel.setLayout(new FlowLayout(0));
            this.noBoundsPanel.add(this.getNoBoundsRB());
        }
        return this.noBoundsPanel;
    }

    JRadioButton getNoBoundsRB() {
        if (this.noBoundsRB == null) {
            this.noBoundsRB = new JRadioButton("No m/z bounds");
            this.noBoundsRB.setSelected(true);
            this.noBoundsRB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MS1MzBoundsPanel.this.setMassBoundsEnabled(false);
                    MS1MzBoundsPanel.this.setMassEnabled(false);
                }
            });
        }
        return this.noBoundsRB;
    }

    private JPanel getMassBoundsPanel() {
        if (this.mzBoundsPanel == null) {
            this.mzBoundsPanel = new JPanel();
            this.mzBoundsPanel.setLayout(new BoxLayout(this.mzBoundsPanel, 1));
            JPanel prb = new JPanel();
            prb.setLayout(new FlowLayout(0));
            prb.add(this.getMzBoundsRB());
            this.mzBoundsPanel.add(prb);
            JPanel pmin = new JPanel();
            pmin.setLayout(new FlowLayout(0));
            JLabel labelMinMz = new JLabel();
            labelMinMz.setText("minimum m/z:");
            pmin.add(labelMinMz);
            pmin.add(this.getMinMzTF());
            this.mzBoundsPanel.add(pmin);
            JPanel pmax = new JPanel();
            pmax.setLayout(new FlowLayout(0));
            JLabel labelMaxMz = new JLabel();
            labelMaxMz.setText("maximum m/z:");
            pmax.add(labelMaxMz);
            pmax.add(this.getMaxMzTF());
            this.mzBoundsPanel.add(pmax);
        }
        return this.mzBoundsPanel;
    }

    JRadioButton getMzBoundsRB() {
        if (this.mzBoundsRB == null) {
            this.mzBoundsRB = new JRadioButton("Enable m/z bounds");
            this.mzBoundsRB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MS1MzBoundsPanel.this.setMassBoundsEnabled(true);
                    MS1MzBoundsPanel.this.setMassEnabled(false);
                }
            });
        }
        return this.mzBoundsRB;
    }

    JTextField getMinMzTF() {
        if (this.minMzTF == null) {
            this.minMzTF = new JTextField();
            this.minMzTF.setText("0.0");
            this.minMzTF.setColumns(5);
            this.minMzTF.setEnabled(false);
            this.minMzTF.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent evt) {
                    MS1MzBoundsPanel.this.minMzTFFocusGained(evt);
                }
            });
        }
        return this.minMzTF;
    }

    JTextField getMaxMzTF() {
        if (this.maxMzTF == null) {
            this.maxMzTF = new JTextField();
            this.maxMzTF.setText("0.0");
            this.maxMzTF.setColumns(5);
            this.maxMzTF.setEnabled(false);
            this.maxMzTF.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent evt) {
                    MS1MzBoundsPanel.this.maxMzTFFocusGained(evt);
                }
            });
        }
        return this.maxMzTF;
    }

    private JPanel getMassPanel() {
        if (this.mzPanel == null) {
            this.mzPanel = new JPanel();
            this.mzPanel.setLayout(new FlowLayout(0));
            this.mzPanel.add(this.getMzRB());
            this.mzPanel.add(this.getMzTF());
        }
        return this.mzPanel;
    }

    JTextField getMzTF() {
        if (this.mzTF == null) {
            this.mzTF = new JTextField();
            this.mzTF.setText("0.0");
            this.mzTF.setColumns(5);
            this.mzTF.setEnabled(false);
            this.mzTF.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent evt) {
                    MS1MzBoundsPanel.this.mzTFFocusGained(evt);
                }
            });
        }
        return this.mzTF;
    }

    JRadioButton getMzRB() {
        if (this.mzRB == null) {
            this.mzRB = new JRadioButton("Detect at m/z:");
            this.mzRB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MS1MzBoundsPanel.this.setMassBoundsEnabled(false);
                    MS1MzBoundsPanel.this.setMassEnabled(true);
                }
            });
        }
        return this.mzRB;
    }

    private void setMassBoundsEnabled(boolean enabled) {
        this.getMinMzTF().setEnabled(enabled);
        this.getMaxMzTF().setEnabled(enabled);
        if (enabled) {
            this.minMzTF.requestFocusInWindow();
        }
    }

    private void setMassEnabled(boolean enabled) {
        this.getMzTF().setEnabled(enabled);
        if (enabled) {
            this.mzTF.requestFocusInWindow();
        }
    }

    private void minMzTFFocusGained(FocusEvent evt) {
        this.minMzTF.selectAll();
    }

    private void maxMzTFFocusGained(FocusEvent evt) {
        this.maxMzTF.selectAll();
    }

    private void mzTFFocusGained(FocusEvent evt) {
        this.mzTF.selectAll();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getMaxMzTF().setEnabled(enabled && this.getMzBoundsRB().isSelected());
        this.getMinMzTF().setEnabled(enabled && this.getMzBoundsRB().isSelected());
        this.getMzTF().setEnabled(enabled && this.getMzRB().isSelected());
        this.getToleranceTF().setEnabled(enabled);
        this.getMzBoundsRB().setEnabled(enabled);
        this.getMzRB().setEnabled(enabled);
        this.getNoBoundsRB().setEnabled(enabled);
    }
}

