/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.discrepancy;

import umontreal.ssj.discrepancy.Discrepancy;
import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.Rank1Lattice;
import umontreal.ssj.rng.LFSR113;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.util.Num;

public class Searcher {
    protected static RandomStream gen = new LFSR113();
    protected Discrepancy disc;
    protected PointSet lat;
    protected double[] gamma;
    protected double bestVal;
    protected int[] bestAs;
    protected boolean primeN = false;
    protected boolean power2F = false;

    protected void print(int[] y, int s) {
        System.out.printf("  a = [ ", new Object[0]);
        for (int j = 0; j < s; ++j) {
            System.out.printf("%d  ", y[j]);
        }
        System.out.printf("]%n", new Object[0]);
    }

    private void incr(int[] y, int n, int s) {
        for (int i = s - 1; i >= 1; --i) {
            int n2 = i;
            y[n2] = y[n2] + 1;
            if (y[i] < n) {
                return;
            }
            if (i <= 1) continue;
            y[i] = 1;
        }
    }

    private void incrPrime(int[] y, int n, int s) {
        for (int i = s - 1; i >= 1; --i) {
            int n2 = i;
            y[n2] = y[n2] + 1;
            if (this.power2F) {
                int n3 = i;
                y[n3] = y[n3] + 1;
            } else {
                while (Num.gcd(n, y[i]) != 1) {
                    int n4 = i;
                    y[n4] = y[n4] + 1;
                }
            }
            if (y[i] < n) {
                return;
            }
            if (i <= 1) continue;
            y[i] = 1;
        }
    }

    private double exhaust(int s, boolean relPrime) {
        int j;
        int n = this.disc.getNumPoints();
        this.gamma = this.disc.getGamma();
        int[] y = new int[s];
        for (j = 0; j < s; ++j) {
            y[j] = 1;
        }
        this.bestVal = Double.MAX_VALUE;
        this.bestAs[0] = 1;
        while (y[1] < n) {
            this.lat = new Rank1Lattice(n, y, s);
            double err = this.disc.compute(this.lat, this.gamma);
            if (err < this.bestVal) {
                this.bestVal = err;
                for (j = 1; j < s; ++j) {
                    this.bestAs[j] = y[j];
                }
            }
            if (relPrime) {
                this.incrPrime(y, n, s);
                continue;
            }
            this.incr(y, n, s);
        }
        return this.bestVal;
    }

    private double random(int s, int k, boolean relPrime) {
        int n = this.disc.getNumPoints();
        this.gamma = this.disc.getGamma();
        int nm1 = n - 1;
        this.bestVal = Double.MAX_VALUE;
        int[] y = new int[s];
        this.bestAs[0] = 1;
        y[0] = 1;
        for (int i = 0; i < k; ++i) {
            int j;
            for (j = 1; j < s; ++j) {
                if (this.power2F) {
                    y[j] = gen.nextInt(1, nm1);
                    if (!relPrime) continue;
                    int n2 = j;
                    y[n2] = y[n2] | 1;
                    continue;
                }
                do {
                    y[j] = gen.nextInt(1, nm1);
                } while (relPrime && Num.gcd(n, y[j]) != 1);
            }
            this.lat = new Rank1Lattice(n, y, s);
            double err = this.disc.compute(this.lat, this.gamma);
            if (!(err < this.bestVal)) continue;
            this.bestVal = err;
            for (j = 1; j < s; ++j) {
                this.bestAs[j] = y[j];
            }
        }
        return this.bestVal;
    }

    public Searcher(Discrepancy disc, boolean primeN) {
        this.disc = disc;
        int s = disc.getDimension();
        int n = disc.getNumPoints();
        this.bestAs = new int[s];
        this.primeN = primeN;
        this.power2F = (n & n - 1) == 0;
    }

    public double exhaust(int s) {
        return this.exhaust(s, false);
    }

    public double exhaustPrime(int s) {
        if (this.primeN) {
            return this.exhaust(s, false);
        }
        return this.exhaust(s, true);
    }

    public double random(int s, int k) {
        return this.random(s, k, false);
    }

    public double randomPrime(int s, int k) {
        if (this.primeN) {
            return this.random(s, k, false);
        }
        return this.random(s, k, true);
    }

    public double getBestVal() {
        return this.bestVal;
    }

    public int[] getBestAs() {
        return this.bestAs;
    }

    public void initGen(int seed) {
        if (seed == 0 || seed == 1) {
            seed = 7654321;
        }
        int s = 12345;
        int[] state = new int[]{seed, 12345, 12345, 12345};
        LFSR113.setPackageSeed(state);
        gen = new LFSR113();
    }
}

