/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import umontreal.ssj.hups.ContainerPointSet;
import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.util.PrintfFormat;

public class RandShiftedMod1PointSet
extends ContainerPointSet {
    protected double[] shift;

    public RandShiftedMod1PointSet(PointSet p, int dimShift, RandomStream stream) {
        this.init(p);
        if (dimShift <= 0) {
            throw new IllegalArgumentException("Cannot construct RandShiftedPointSet with dimShift <= 0");
        }
        this.shiftStream = stream;
        this.shift = new double[dimShift];
        this.capacityShift = this.dimShift = dimShift;
    }

    public int getShiftDimension() {
        return this.dimShift;
    }

    @Override
    public void addRandomShift(int d1, int d2, RandomStream stream) {
        if (null == stream) {
            throw new IllegalArgumentException(PrintfFormat.NEWLINE + "   Calling addRandomShift with null stream");
        }
        this.shiftStream = stream;
        this.addRandomShift(d1, d2);
    }

    @Override
    public void addRandomShift(RandomStream stream) {
        this.shiftStream = stream;
        this.addRandomShift(0, this.dimShift);
    }

    @Override
    public void addRandomShift(int d1, int d2) {
        if (d1 < 0 || d1 > d2) {
            throw new IllegalArgumentException("illegal parameter d1 or d2");
        }
        if (d2 > this.capacityShift) {
            int d3;
            for (d3 = Math.max(4, this.capacityShift); d2 > d3; d3 *= 2) {
            }
            double[] temp = new double[d3];
            this.capacityShift = d3;
            for (int i = 0; i < d1; ++i) {
                temp[i] = this.shift[i];
            }
            this.shift = temp;
        }
        this.dimShift = d2;
        for (int i = d1; i < d2; ++i) {
            this.shift[i] = this.shiftStream.nextDouble();
        }
    }

    @Override
    public void addRandomShift() {
        this.addRandomShift(0, this.dimShift);
    }

    @Override
    public double getCoordinate(int i, int j) {
        double u;
        if (this.dimShift <= j) {
            this.addRandomShift(this.dimShift, 1 + j);
        }
        if ((u = this.P.getCoordinate(i, j) + this.shift[j]) >= 1.0) {
            u -= 1.0;
        }
        if (u > 0.0) {
            return u;
        }
        return this.EpsilonHalf;
    }

    @Override
    public String toString() {
        return "RandShiftedPointSet of: {" + PrintfFormat.NEWLINE + this.P.toString() + PrintfFormat.NEWLINE + "}";
    }

    @Override
    public PointSetIterator iterator() {
        return new RandShiftedMod1PointSetIterator();
    }

    private class RandShiftedMod1PointSetIterator
    extends ContainerPointSet.ContainerPointSetIterator {
        private RandShiftedMod1PointSetIterator() {
        }

        @Override
        public double nextCoordinate() {
            double u;
            int d1 = this.innerIterator.getCurCoordIndex();
            if (RandShiftedMod1PointSet.this.dimShift <= d1) {
                RandShiftedMod1PointSet.this.addRandomShift(RandShiftedMod1PointSet.this.dimShift, 1 + d1);
            }
            if ((u = RandShiftedMod1PointSet.this.shift[d1] + this.innerIterator.nextCoordinate()) >= 1.0) {
                u -= 1.0;
            }
            if (u > 0.0) {
                return u;
            }
            return this.EpsilonHalf;
        }
    }
}

