/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.simevents;

import umontreal.ssj.simevents.ContinuousState;
import umontreal.ssj.simevents.Event;
import umontreal.ssj.simevents.eventlist.EventList;
import umontreal.ssj.simevents.eventlist.SplayTree;

public class Simulator {
    protected double currentTime = 0.0;
    protected EventList eventList;
    protected boolean stopped = true;
    protected boolean simulating = false;
    protected ContinuousState continuousState = null;
    public static Simulator defaultSimulator = null;

    public Simulator() {
        this.eventList = new SplayTree();
    }

    public Simulator(EventList eventList) {
        if (eventList == null) {
            throw new NullPointerException();
        }
        this.eventList = eventList;
    }

    public double time() {
        return this.currentTime;
    }

    public void init() {
        this.currentTime = 0.0;
        this.eventList.clear();
        this.stopped = false;
        this.simulating = false;
    }

    public void init(EventList evlist) {
        if (evlist == null) {
            throw new NullPointerException();
        }
        this.eventList = evlist;
        this.init();
    }

    public EventList getEventList() {
        return this.eventList;
    }

    public boolean isSimulating() {
        return this.simulating;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    protected Event removeFirstEvent() {
        if (this.stopped) {
            return null;
        }
        Event ev = this.eventList.removeFirst();
        if (ev == null) {
            return null;
        }
        this.currentTime = ev.eventTime;
        ev.eventTime = -10.0;
        return ev;
    }

    public void start() {
        if (this.eventList.isEmpty()) {
            throw new IllegalStateException("start() called with an empty event list");
        }
        this.stopped = false;
        this.simulating = true;
        try {
            Event ev;
            while ((ev = this.removeFirstEvent()) != null && !this.stopped) {
                ev.actions();
            }
        }
        finally {
            this.stopped = true;
            this.simulating = false;
        }
    }

    public void stop() {
        this.stopped = true;
    }

    public ContinuousState continuousState() {
        if (this.continuousState == null) {
            this.continuousState = new ContinuousState(this);
        }
        return this.continuousState;
    }

    public static Simulator getDefaultSimulator() {
        if (defaultSimulator == null) {
            defaultSimulator = new Simulator();
        }
        return defaultSimulator;
    }
}

