/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.map;

import fr.profi.mzdb.MzDbReaderHelper;
import fr.profi.mzdb.io.reader.cache.MzDbEntityCache;
import fr.profi.mzdb.model.SpectrumSlice;
import fr.profi.mzdb.util.concurrent.CallableCallback;
import fr.profi.mzdb.util.concurrent.Callback;
import fr.proline.mzscope.map.LcMsMap;
import fr.proline.mzscope.map.LcMsViewport;
import fr.proline.mzscope.map.color.IntensityPainter;
import fr.proline.mzscope.map.math.Function1D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;

public class LcMsMapChunk {
    private Date creationTime = new Date();
    private LcMsMap map = null;
    private SpectrumSlice[] slices = null;
    private BufferedImage image = null;
    private LcMsViewport viewport = null;
    private byte[] pixels = null;
    private DoubleImageData[] values = null;
    private double maxValue = 0.0;
    private int nbData = 0;

    public LcMsMapChunk(LcMsMap map, LcMsViewport viewport) {
        this.setMap(map);
        this.setViewport(viewport);
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public LcMsMap getMap() {
        return this.map;
    }

    public final void setMap(LcMsMap map) {
        this.map = map;
    }

    public LcMsViewport getViewport() {
        return this.viewport;
    }

    public final void setViewport(LcMsViewport viewport) {
        this.viewport = new LcMsViewport(viewport);
    }

    public Callable<SpectrumSlice[]> getSlicesProcess(Callback<SpectrumSlice[]> callbackWhenDone) {
        return MzDbReaderHelper.getSpectrumSlicesInRanges((double)this.viewport.minMz, (double)this.viewport.maxMz, (float)((float)this.viewport.minRt), (float)((float)this.viewport.maxRt), (File)this.getMap().getFile(), (MzDbEntityCache)this.getMap().getCache(), callbackWhenDone);
    }

    public SpectrumSlice[] getSlices() {
        try {
            return Executors.newSingleThreadExecutor().submit(this.getSlicesProcess(null)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Callable<LcMsMapChunk> getImageProcess(final int imageWidth, final int imageHeight, final Function1D intensityFactor, Callback<LcMsMapChunk> callbackWhenDone, final IntensityPainter painter) {
        Callable<LcMsMapChunk> generateImage = new Callable<LcMsMapChunk>(){

            @Override
            public LcMsMapChunk call() throws Exception {
                LcMsMapChunk.this.doSQLiteRequest();
                LcMsMapChunk.this.generateDoubleImage(imageWidth, imageHeight);
                LcMsMapChunk.this.generateImageFromDouble(imageWidth, imageHeight, intensityFactor, painter);
                return LcMsMapChunk.this;
            }
        };
        return new CallableCallback((Callable)generateImage, callbackWhenDone);
    }

    public Callable<LcMsMapChunk> updateImageColorProcess(final int imageWidth, final int imageHeight, final Function1D intensityFactor, Callback<LcMsMapChunk> callbackWhenDone, final IntensityPainter painter) {
        Callable<LcMsMapChunk> generateImage = new Callable<LcMsMapChunk>(){

            @Override
            public LcMsMapChunk call() throws Exception {
                LcMsMapChunk.this.generateImageFromDouble(imageWidth, imageHeight, intensityFactor, painter);
                return LcMsMapChunk.this;
            }
        };
        return new CallableCallback((Callable)generateImage, callbackWhenDone);
    }

    public BufferedImage getLastImage() {
        return this.image;
    }

    public SpectrumSlice[] getLastSlices() {
        return this.slices;
    }

    private void addIntensity(double mz, double rt, int sliceIndex, int dataIndex, int imageWidth, int imageHeight) {
        Point2D p = this.viewport.value2pixel(mz, rt, imageWidth, imageHeight);
        int x = (int)p.getX();
        int y = (int)p.getY();
        if (x >= 0 && x < imageWidth && y >= 0 && y < imageHeight) {
            int l = x + y * imageWidth;
            double intensity = this.slices[sliceIndex].getData().getIntensityList()[dataIndex];
            if (this.values[l].intensitySum <= 0.0) {
                ++this.nbData;
            }
            this.values[l].intensitySum += intensity;
            this.maxValue = Math.max(this.maxValue, this.values[l].intensitySum);
        }
    }

    private void generateImageFromDouble(int imageWidth, int imageHeight, Function1D intensityFactor, IntensityPainter painter) {
        int squareSize = 1;
        int pixelCount = imageWidth * imageHeight;
        double imageFillRate = (double)this.nbData / (double)pixelCount;
        if (imageFillRate < 0.1) {
            squareSize = 3;
        }
        if (imageFillRate < 0.01) {
            squareSize = 5;
        }
        if (imageFillRate < 0.002) {
            squareSize = 7;
        }
        if (imageFillRate < 0.001) {
            squareSize = 9;
        }
        for (int y = 0; y < imageHeight; ++y) {
            for (int x = 0; x < imageWidth; ++x) {
                int l = x + y * imageWidth;
                double intensity = intensityFactor.eval(this.values[l].intensitySum / this.maxValue);
                if (intensity <= 0.0) continue;
                Color c = painter.getColor(intensity);
                for (int dy = Math.max(0, y - squareSize / 2); dy <= Math.min(imageHeight - 1, y + squareSize / 2); ++dy) {
                    for (int dx = Math.max(0, x - squareSize / 2); dx <= Math.min(imageWidth - 1, x + squareSize / 2); ++dx) {
                        if (dx < 0 || dx >= imageWidth || dy < 0 || dy >= imageHeight) continue;
                        l = (dx + dy * imageWidth) * 4;
                        this.pixels[l] = -1;
                        this.pixels[l + 1] = (byte)c.getBlue();
                        this.pixels[l + 2] = (byte)c.getGreen();
                        this.pixels[l + 3] = (byte)c.getRed();
                    }
                }
            }
        }
    }

    private void doSQLiteRequest() {
        if (this.map == null) {
            throw new IllegalStateException("map cannot be null");
        }
        try {
            this.slices = Executors.newSingleThreadExecutor().submit(this.getSlicesProcess(null)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("exception getting slices", e);
        }
    }

    private void generateDoubleImage(int imageWidth, int imageHeight) {
        if (this.slices == null) {
            throw new IllegalStateException("slices");
        }
        this.image = new BufferedImage(imageWidth, imageHeight, 6);
        this.values = new DoubleImageData[imageWidth * imageHeight];
        this.pixels = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
        Graphics2D graphics = this.image.createGraphics();
        graphics.setPaint(new Color(0, 0, 0));
        graphics.fillRect(0, 0, imageWidth, imageHeight);
        for (int i = 0; i < imageWidth * imageHeight; ++i) {
            this.values[i] = new DoubleImageData();
        }
        this.maxValue = 0.0;
        this.nbData = 0;
        for (int sliceIndex = 0; sliceIndex < this.slices.length; ++sliceIndex) {
            SpectrumSlice slice = this.slices[sliceIndex];
            double[] mzs = slice.getData().getMzList();
            float[] intensities = slice.getData().getIntensityList();
            float rt = slice.getHeader().getTime();
            if ((double)rt >= this.viewport.minRt && (double)rt <= this.viewport.maxRt) {
                for (int dataIndex = 0; dataIndex < mzs.length; ++dataIndex) {
                    double mz = mzs[dataIndex];
                    if (mz >= this.viewport.minMz && mz <= this.viewport.maxMz) {
                        this.addIntensity(mz, rt, sliceIndex, dataIndex, imageWidth, imageHeight);
                        continue;
                    }
                    System.out.println("mz = " + mz + " is out of mz range " + this.viewport.minMz + "-" + this.viewport.maxMz);
                }
                continue;
            }
            System.out.println("rt = " + rt + " is out of rt range " + this.viewport.minRt + "-" + this.viewport.maxRt);
        }
    }

    private static class DoubleImageData {
        public double intensitySum = 0.0;

        private DoubleImageData() {
        }
    }
}

