/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.peakels;

import fr.profi.mzdb.model.Peakel;
import fr.proline.mzscope.model.BaseFeature;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.processing.SpectrumUtils;
import fr.proline.mzscope.ui.IMzScopeController;
import fr.proline.mzscope.ui.peakels.PeakelWrapper;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ImportedDataTableModel;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.filter.actions.ClearRestrainAction;
import fr.proline.studio.filter.actions.RestrainAction;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.PlotBaseAbstract;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.graphics.marker.AbstractMarker;
import fr.proline.studio.graphics.marker.LabelMarker;
import fr.proline.studio.graphics.marker.coordinates.AbstractCoordinates;
import fr.proline.studio.graphics.marker.coordinates.PixelCoordinates;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.table.AbstractTableAction;
import fr.proline.studio.table.DecoratedMarkerTable;
import fr.proline.studio.table.TablePopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPeakelsPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPeakelsPanel.class);
    private static final String LAST_DIR = "mzscope.last.csv.features.directory";
    private JFileChooser m_fchooser;
    protected int m_modelSelectedRowBeforeSort = -1;
    protected DecoratedMarkerTable m_table;
    protected CompoundTableModel m_compoundTableModel;
    protected IMzScopeController m_viewersController;
    protected BasePlotPanel m_graphPlot;
    protected MarkerContainerPanel m_markerContainerPanel;

    public AbstractPeakelsPanel(IMzScopeController controller) {
        this.m_viewersController = controller;
        this.m_fchooser = new JFileChooser();
        this.m_fchooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".csv");
            }

            @Override
            public String getDescription() {
                return "*.csv";
            }
        });
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.m_table = new FeatureTable();
        this.m_compoundTableModel = this.buildTableModel();
        this.m_table.setModel((TableModel)this.m_compoundTableModel);
        this.m_table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AbstractPeakelsPanel.this.tableMouseClicked(evt);
            }
        });
        jScrollPane.setViewportView((Component)this.m_table);
        this.m_table.setFillsViewportHeight(true);
        this.m_table.setViewport(jScrollPane.getViewport());
        this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AbstractPeakelsPanel.this.updatePeakelsViewer(AbstractPeakelsPanel.this.getSelectedPeakels());
            }
        });
        JToolBar toolbar = this.initToolbar();
        this.m_markerContainerPanel = new MarkerContainerPanel(jScrollPane, (MarkerComponentInterface)this.m_table);
        tablePanel.add((Component)toolbar, "West");
        tablePanel.add((Component)this.m_markerContainerPanel, "Center");
        JSplitPane splitPane = new JSplitPane();
        splitPane.setLeftComponent(tablePanel);
        this.m_graphPlot = new BasePlotPanel();
        splitPane.setRightComponent((Component)this.m_graphPlot);
        this.add((Component)splitPane, "Center");
    }

    protected abstract CompoundTableModel buildTableModel();

    protected JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        FilterButton filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_table.getModel())){

            protected void filteringDone() {
            }
        };
        ExportButton exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_table.getModel()), "Features-Peakels", (JXTable)this.m_table);
        toolbar.add((Component)filterButton);
        toolbar.add((Component)exportButton);
        return toolbar;
    }

    protected void tableMouseClicked(MouseEvent evt) {
        List<IPeakel> peakels = this.getSelectedIPeakels();
        this.updatePeakelsViewer(this.getSelectedPeakels());
        if (evt.getClickCount() == 2 && peakels != null && peakels.size() > 0) {
            this.m_viewersController.getRawFileViewer(peakels.get(0).getRawFile(), true).displayPeakel(peakels.get(0));
        }
    }

    protected abstract List<IPeakel> getSelectedIPeakels();

    protected abstract List<Peakel> getSelectedPeakels();

    private void updatePeakelsViewer(List<Peakel> peakels) {
        if (peakels != null) {
            this.m_graphPlot.clearPlots();
            float maxY = 0.0f;
            int index = 0;
            for (Peakel p : peakels) {
                maxY = Math.max(p.getApexIntensity(), maxY);
                PeakelWrapper wrapper = new PeakelWrapper(p, index++);
                PlotLinear plot = new PlotLinear(this.m_graphPlot, (ExtendedTableModelInterface)wrapper, null, 0, 1);
                plot.setPlotInformation(wrapper.getPlotInformation());
                this.m_graphPlot.addPlot((PlotXYAbstract)plot);
            }
            ((PlotBaseAbstract)this.m_graphPlot.getPlots().get(0)).clearMarkers();
            if (peakels.size() == 2) {
                double correlation = SpectrumUtils.correlation(peakels.get(0), peakels.get(1));
                double ompCorrelation = SpectrumUtils.correlationOMP(peakels.get(0), peakels.get(1), false);
                double ompSmoothedCorrelation = SpectrumUtils.correlationOMP(peakels.get(0), peakels.get(1), true);
                LabelMarker marker = new LabelMarker(this.m_graphPlot, (AbstractCoordinates)new PixelCoordinates(10, 60), MessageFormat.format("Corr: {0}, OMP: {1}, smooth OMP: {2}", correlation, ompCorrelation, ompSmoothedCorrelation));
                ((PlotBaseAbstract)this.m_graphPlot.getPlots().get(0)).addMarker((AbstractMarker)marker);
            }
            this.m_graphPlot.getYAxis().lockMinValue(Double.valueOf(0.0));
            this.m_graphPlot.getYAxis().setRange(0.0, (double)maxY);
            this.m_graphPlot.repaint();
        }
    }

    protected int getModelRowId(int rowId) {
        CompoundTableModel compoundTableModel = (CompoundTableModel)this.m_table.getModel();
        if (compoundTableModel.getRowCount() != 0) {
            rowId = this.m_table.convertRowIndexToModel(rowId);
            rowId = compoundTableModel.convertCompoundRowToBaseModelRow(rowId);
        }
        return rowId;
    }

    void matchCSVIons() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String directory = prefs.get(LAST_DIR, this.m_fchooser.getCurrentDirectory().getAbsolutePath());
        this.m_fchooser.setCurrentDirectory(new File(directory));
        int result = this.m_fchooser.showOpenDialog(this);
        if (result == 0) {
            File csvFile = this.m_fchooser.getSelectedFile();
            String fileName = csvFile.getName();
            if (!fileName.endsWith(".csv")) {
                JOptionPane.showMessageDialog(this, "The file must be a csv file", "Error", 0);
                return;
            }
            prefs.put(LAST_DIR, csvFile.getParentFile().getAbsolutePath());
            ImportedDataTableModel importedTableModel = new ImportedDataTableModel();
            Exception csvException = ImportedDataTableModel.loadFile((ImportedDataTableModel)importedTableModel, (String)csvFile.getAbsolutePath(), (char)';', (boolean)true, (boolean)false);
            if (csvException == null) {
                int mzColumnIdx = this.findColumn((AbstractTableModel)importedTableModel, new String[]{"moz", "m/z", "mz", "exp. moz"});
                int rtColumnIdx = this.findColumn((AbstractTableModel)importedTableModel, new String[]{"rt", "retention_time", "retention time", "elution_time", "elution time", "time"});
                int zColumnIdx = this.findColumn((AbstractTableModel)importedTableModel, new String[]{"charge", "z"});
                int iColumnIdx = this.findColumn((AbstractTableModel)importedTableModel, new String[]{"Abundance"});
                if (mzColumnIdx != -1) {
                    ArrayList<BaseFeature> ions = new ArrayList<BaseFeature>(importedTableModel.getRowCount());
                    for (int k = 0; k < importedTableModel.getRowCount(); ++k) {
                        double mz = (Double)importedTableModel.getValueAt(k, mzColumnIdx);
                        float rt = rtColumnIdx != -1 ? ((Double)importedTableModel.getValueAt(k, rtColumnIdx)).floatValue() : -1.0f;
                        int z = zColumnIdx != -1 ? ((Long)importedTableModel.getValueAt(k, zColumnIdx)).intValue() : 0;
                        float i = iColumnIdx != -1 ? ((Double)importedTableModel.getValueAt(k, iColumnIdx)).floatValue() : -1.0f;
                        BaseFeature ion = new BaseFeature(mz, rt, rt, rt, null, 1);
                        ion.setCharge(z);
                        ion.setApexIntensity(i);
                        ions.add(ion);
                    }
                    logger.info("Matching features from {}", (Object)csvFile.getName());
                    this.matchIons(ions, importedTableModel);
                } else {
                    StringBuffer columnNamesBuffer = new StringBuffer("[");
                    for (int i = 0; i < importedTableModel.getColumnCount(); ++i) {
                        columnNamesBuffer.append(importedTableModel.getColumnName(i)).append(";");
                    }
                    columnNamesBuffer.deleteCharAt(columnNamesBuffer.length() - 1);
                    columnNamesBuffer.append("]");
                    String message = "No column named \"mz\",\"moz\" or \"m/z\" detected in the imported file.\n Verify the column headers (the column separator must be \";\") \n" + columnNamesBuffer.toString();
                    JOptionPane.showMessageDialog(this, message, "Error", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Error while redading CSV file : " + csvException.getMessage(), "Error", 0);
            }
        }
    }

    protected abstract void matchIons(List<BaseFeature> var1, ImportedDataTableModel var2);

    protected String getRowAsString(int row, ImportedDataTableModel tableModel) {
        StringBuilder stb = new StringBuilder();
        for (int k = 0; k < tableModel.getColumnCount(); ++k) {
            stb.append(tableModel.getValueAt(row, k)).append(", ");
        }
        return stb.toString();
    }

    protected int findColumn(AbstractTableModel tableModel, String[] alternativeNames) {
        int columnIdx = -1;
        for (String name : alternativeNames) {
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                if (!name.trim().equalsIgnoreCase(tableModel.getColumnName(i).trim())) continue;
                columnIdx = i;
            }
            if (columnIdx != -1) break;
        }
        return columnIdx;
    }

    protected class FeatureTable
    extends DecoratedMarkerTable {
        protected FeatureTable() {
        }

        public TablePopupMenu initPopupMenu() {
            TablePopupMenu popupMenu = new TablePopupMenu();
            popupMenu.addAction((AbstractTableAction)new DisplayRawFileAction());
            popupMenu.addAction((AbstractTableAction)new DisplayFeatureInCurrentRawFileAction());
            popupMenu.addAction(null);
            popupMenu.addAction((AbstractTableAction)new RestrainAction(){

                public void filteringDone() {
                }
            });
            popupMenu.addAction((AbstractTableAction)new ClearRestrainAction(){

                public void filteringDone() {
                }
            });
            return popupMenu;
        }

        public void prepostPopupMenu() {
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }
    }

    protected class DisplayFeatureInCurrentRawFileAction
    extends AbstractTableAction {
        public DisplayFeatureInCurrentRawFileAction() {
            super("Display in the currently active raw file");
        }

        public void actionPerformed(int col, int row, int[] selectedRows, JTable table) {
            List<IPeakel> peakels = AbstractPeakelsPanel.this.getSelectedIPeakels();
            if (peakels != null && peakels.size() > 0) {
                AbstractPeakelsPanel.this.m_viewersController.getCurrentRawFileViewer().displayPeakel(peakels.get(0));
            }
        }

        public void updateEnabled(int row, int col, int[] selectedRows, JTable table) {
            this.setEnabled(selectedRows.length == 1);
        }
    }

    protected class DisplayRawFileAction
    extends AbstractTableAction {
        public DisplayRawFileAction() {
            super("Display in the raw file");
        }

        public void actionPerformed(int col, int row, int[] selectedRows, JTable table) {
            List<IPeakel> peakels = AbstractPeakelsPanel.this.getSelectedIPeakels();
            if (peakels != null && peakels.size() > 0) {
                AbstractPeakelsPanel.this.m_viewersController.getRawFileViewer(peakels.get(0).getRawFile(), true).displayPeakel(peakels.get(0));
            }
        }

        public void updateEnabled(int row, int col, int[] selectedRows, JTable table) {
            this.setEnabled(selectedRows.length == 1);
        }
    }
}

