/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public final class ReadWriteLockImpl
implements ReadWriteLock,
Serializable {
    private static final long serialVersionUID = 1536L;
    public final ReadLock readLock = new ReadLock();
    public final WriteLock writeLock = new WriteLock();
    private transient int givenLocks;
    private transient int waitingWriters;
    private transient Thread writerThread;

    @Override
    public ReadLock readLock() {
        return this.readLock;
    }

    @Override
    public WriteLock writeLock() {
        return this.writeLock;
    }

    public final class WriteLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = 1536L;

        @Override
        public void lock() {
            try {
                this.lockInterruptibly();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lockInterruptibly() throws InterruptedException {
            ReadWriteLockImpl readWriteLockImpl = ReadWriteLockImpl.this;
            synchronized (readWriteLockImpl) {
                ReadWriteLockImpl.this.waitingWriters++;
                while (ReadWriteLockImpl.this.givenLocks != 0) {
                    ReadWriteLockImpl.this.wait();
                }
                ReadWriteLockImpl.this.waitingWriters--;
                ReadWriteLockImpl.this.writerThread = Thread.currentThread();
            }
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock() {
            ReadWriteLockImpl readWriteLockImpl = ReadWriteLockImpl.this;
            synchronized (readWriteLockImpl) {
                ReadWriteLockImpl.this.writerThread = null;
                ReadWriteLockImpl.this.notifyAll();
            }
        }
    }

    public final class ReadLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = 1536L;

        @Override
        public void lock() {
            try {
                this.lockInterruptibly();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lockInterruptibly() throws InterruptedException {
            ReadWriteLockImpl readWriteLockImpl = ReadWriteLockImpl.this;
            synchronized (readWriteLockImpl) {
                if (ReadWriteLockImpl.this.writerThread == Thread.currentThread()) {
                    return;
                }
                while (ReadWriteLockImpl.this.writerThread != null || ReadWriteLockImpl.this.waitingWriters != 0) {
                    ReadWriteLockImpl.this.wait();
                }
                ReadWriteLockImpl.this.givenLocks++;
            }
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock() {
            ReadWriteLockImpl readWriteLockImpl = ReadWriteLockImpl.this;
            synchronized (readWriteLockImpl) {
                if (ReadWriteLockImpl.this.writerThread == Thread.currentThread()) {
                    return;
                }
                assert (ReadWriteLockImpl.this.givenLocks > 0);
                ReadWriteLockImpl.this.givenLocks--;
                ReadWriteLockImpl.this.notifyAll();
            }
        }
    }
}

